package com.xebialabs.xlrelease.actors.cluster

import com.xebialabs.xlplatform.cluster.full.downing.{MajorityLeaderAutoDowningProvider, OldestLeaderAutoDowningProvider}
import org.apache.pekko.actor.Address
import org.apache.pekko.cluster.Member
import org.apache.pekko.cluster.MemberStatus._

object XlrCluster {
  private val ALIVE_STATUSES = Seq(Joining, Up, WeaklyUp, PreparingForShutdown, ReadyForShutdown)
  val LEGACY_DOWNING_PROVIDERS: Seq[String] = Seq(classOf[MajorityLeaderAutoDowningProvider].getName, classOf[OldestLeaderAutoDowningProvider].getName)

  object ClusterManagerConstants {
    final val PEKKO_NATIVE = "xlr-pekko-native"
    final val XLR_LEGACY = "xlr-legacy"
  }

  object ServiceDiscoveryConstants {
    final val JDBC = "jdbc"
  }

  implicit class ClusterMemberOps(val member: Member) extends AnyVal {
    def isAlive: Boolean = ALIVE_STATUSES.contains(member.status)
  }

  implicit class ClusterAddressOps(val address: Address) {
    def nodeAddress: String = {
      val host = address.host.get
      val port = address.port.get
      s"$host:$port"
    }
  }
}
