/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.setup.FileCopier;
import com.xebialabs.deployit.setup.SetupHelperMethods;
import com.xebialabs.deployit.setup.UpgradeHelper;
import com.xebialabs.deployit.util.DeployitKeyStore;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.io.FolderChecksum;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.config.XlrConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

public class XLReleaseSetup {
    private final String serverName;
    private final ServerConfigFile serverConfigFile;
    private final XLReleaseServerLaunchOptions launchOptions;
    private ServerConfiguration configuration;
    private boolean askServerUrl = true;
    private boolean generateKeyStore;
    private boolean generatePasswordEncryptionKey;
    private String passwordEncryptionKeyPassword;

    public XLReleaseSetup(String serverName, ServerConfigFile serverConfigFile, XLReleaseServerLaunchOptions launchOptions, ServerConfiguration serverConfiguration) {
        this.serverName = serverName;
        this.serverConfigFile = serverConfigFile;
        this.launchOptions = launchOptions;
        this.configuration = serverConfiguration;
    }

    public void run() {
        String previousInstallation = this.launchOptions.getPreviousInstallation();
        if (Strings.isNotBlank((String)previousInstallation)) {
            this.runUpgrade(previousInstallation);
        } else if (this.launchOptions.isReinitialize()) {
            this.reinitialize();
        } else {
            this.runComplete();
        }
    }

    private void runUpgrade(String previousInstallation) {
        if (!this.launchOptions.isDoSetup()) {
            throw new RuntimeException("Option `-previous-installation` is only supported in setup mode (with `-setup` option)");
        }
        UpgradeHelper upgradeHelper = new UpgradeHelper(previousInstallation, this.launchOptions.isForceUpgrades(), new FileCopier());
        Path previousInstallationPath = new File(previousInstallation).toPath();
        File confFolder = new File(String.format("%s/conf", previousInstallation));
        List configFiles = CollectionConverters.asJava((Seq)FolderChecksum.listAllFilesSorted((File)confFolder)).stream().filter(file -> !file.getName().equalsIgnoreCase("script.policy")).filter(file -> !file.getName().equalsIgnoreCase("xlr-wrapper-linux.conf")).filter(file -> !file.getName().equalsIgnoreCase("xlr-wrapper-win.conf")).map(file -> previousInstallationPath.relativize(file.toPath()).toString()).collect(Collectors.toList());
        XlrConfig xlrConfig = new XlrConfig(ConfigFactory.parseFile((File)Paths.get(previousInstallation, "conf", "xl-release.conf").toFile()).withFallback((ConfigMergeable)XlrConfig.bootConfig().rootConfig()));
        Path reportFolder = xlrConfig.reportingEngineLocation();
        ArrayList<String> dirs = new ArrayList<String>();
        if (!reportFolder.isAbsolute()) {
            dirs.add(reportFolder.toString());
        }
        dirs.add("ext");
        upgradeHelper.copyData(configFiles, dirs, Arrays.asList("conf/script.policy", "conf/xlr-wrapper-linux.conf", "conf/xlr-wrapper-win.conf"));
    }

    private void reinitialize() {
        if (!this.launchOptions.isForce()) {
            System.out.println("The -reinitialize will only work with a default repository setup and not when Digital.ai Release is configured with an external database.");
            System.out.println("Are you sure you want to continue (yes or no)?");
            if (!SetupHelperMethods.getBooleanResponse((boolean)false)) {
                return;
            }
        }
        String repositoryKeystorePassword = this.launchOptions.getRepositoryKeystorePassword();
        SecretKey passwordEncryptionKey = null;
        if (null != repositoryKeystorePassword) {
            DeployitKeyStore.generateRandomKeyStore((File)new File("conf"), (String)repositoryKeystorePassword);
            passwordEncryptionKey = DeployitKeyStore.getPasswordEncryptionKey();
        } else {
            passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeystorePassword);
        }
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        this.useDefaultValues(this.launchOptions.getDefaultsFile());
        this.serverConfigFile.writeConfiguration(this.configuration);
        this.configuration = this.serverConfigFile.loadConfig();
        this.initializeRepository();
        System.out.println("Finished reinitialization.");
    }

    private void useDefaultValues(String defaultsFile) {
        block4: {
            int httpPort = this.configuration.getHttpPort();
            this.configuration.setDefaults();
            this.configuration.setHttpPort(httpPort);
            if (defaultsFile == null) break block4;
            File file = new File(defaultsFile);
            OverthereUtils.checkState((boolean)file.exists(), (String)"The given file [%s] with defaults does not exist.", (Object[])new Object[]{defaultsFile});
            Properties properties = new Properties();
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(file);
                properties.load(inStream);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Cannot load [" + file + "] to read defaults from.");
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(inStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)inStream);
            this.configuration.load(properties);
        }
    }

    private void runComplete() {
        SecretKey passwordEncryptionKey;
        System.out.println("\nWelcome to the " + this.serverName + " setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the " + this.serverName + " configuration you can run run.cmd -setup on Windows or run.sh -setup on Unix.");
        boolean editingExistingConfiguration = false;
        if (this.serverConfigFile.exists() && this.askDoYouWantToEditTheExistingConfiguration()) {
            passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
            this.serverConfigFile.readIntoConfiguration(this.configuration);
            editingExistingConfiguration = true;
        }
        if (XLReleaseSetup.askToUseSimpleSetup()) {
            if (!editingExistingConfiguration) {
                this.askAdminPassword();
                this.askToCreatePasswordEncryptionKey();
            } else {
                this.upgradeConfigurationWithDefaultValues();
            }
        } else {
            if (!editingExistingConfiguration) {
                this.askAdminPassword();
                this.askToCreatePasswordEncryptionKey();
            }
            if (this.askToEnableSsl()) {
                if (this.askToGenerateKeys()) {
                    this.setDefaultKeyStoreSettings();
                } else {
                    this.askKeyStoreSettings();
                }
                if (this.askToEnableMutualSsl()) {
                    this.askTrustStoreSettings();
                }
            }
            this.askHttpBindAddressForJetty();
            this.askHttpPortForJetty();
            this.askWebContextRoot();
            this.askServerUrl();
            this.askMinumAmountOfThreads();
            this.askMaximumAmountOfThreads();
        }
        if (this.reviewAndConfirm()) {
            passwordEncryptionKey = null;
            if (this.generatePasswordEncryptionKey) {
                DeployitKeyStore.generateRandomKeyStore((File)new File("conf"), (String)this.passwordEncryptionKeyPassword);
                passwordEncryptionKey = DeployitKeyStore.getPasswordEncryptionKey();
            } else {
                passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            }
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
            System.out.println("Saving to " + this.serverConfigFile);
            this.serverConfigFile.writeConfiguration(this.configuration);
            System.out.println("Configuration saved.");
            if (this.generateKeyStore) {
                this.generateKeyStore();
            }
            this.configuration = this.serverConfigFile.loadConfig();
            System.out.println("You can now start your " + this.serverName + " by executing the command run.cmd on Windows or run.sh on Unix.");
            System.out.println("Note: If your " + this.serverName + " is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private boolean reviewAndConfirm() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Do you agree with the following settings for " + this.serverName + " and would you like to save them?");
        System.out.println("Changes will be saved in " + this.serverConfigFile.getName());
        System.out.println("\tSSL will be " + (this.configuration.isSsl() ? "enabled" : "disabled"));
        if (this.configuration.isSsl()) {
            if (this.generateKeyStore) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + this.configuration.getKeyStorePath());
                System.out.println("\tKeystore password is " + this.configuration.getKeyStorePassword());
                System.out.println("\tKeystore key password is " + this.configuration.getKeyStoreKeyPassword());
            }
        }
        System.out.println("\tHTTP bind address is " + this.configuration.getHttpBindAddress());
        System.out.println("\tHTTP port is " + this.configuration.getHttpPort());
        System.out.println("\tContext root is " + this.configuration.getWebContextRoot());
        if (this.askServerUrl) {
            System.out.println("\tPublic Server URL is " + this.configuration.getServerUrl());
        }
        System.out.println("\tHTTP server will use a minimum of " + this.configuration.getMinThreads() + " and a maximum of " + this.configuration.getMaxThreads() + " threads");
        if (this.generatePasswordEncryptionKey) {
            System.out.println("\tPassword encryption key will be generated.");
        }
        return SetupHelperMethods.getBooleanResponse((boolean)true);
    }

    private boolean askDoYouWantToEditTheExistingConfiguration() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("An existing " + this.serverName + " configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean useOldConfig = SetupHelperMethods.getBooleanResponse((boolean)true);
        if (useOldConfig) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return useOldConfig;
    }

    private void upgradeConfigurationWithDefaultValues() {
        if (this.configuration.getMinThreads() == 0) {
            this.configuration.setMinThreads(30);
        }
        if (this.configuration.getMaxThreads() == 0) {
            this.configuration.setMaxThreads(150);
        }
    }

    private void askToCreatePasswordEncryptionKey() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("The password encryption key protects the passwords stored in the repository. ");
        System.out.println("Do you want to generate a new password encryption key?");
        System.out.println("Options are yes or no.");
        this.generatePasswordEncryptionKey = SetupHelperMethods.getBooleanResponse((boolean)true);
        if (this.generatePasswordEncryptionKey) {
            System.out.println("The password encryption key is optionally secured by a password.");
            System.out.println("Please enter the password you wish to use. (Use an empty password to avoid a password prompt when starting " + this.serverName + ".)");
            this.passwordEncryptionKeyPassword = SetupHelperMethods.getConfirmedPassword();
        }
    }

    private static boolean askToUseSimpleSetup() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return SetupHelperMethods.getBooleanResponse((boolean)true);
    }

    private void askAdminPassword() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Please enter the admin password you wish to use for " + this.serverName);
        String password = SetupHelperMethods.getConfirmedPassword();
        if (Strings.isEmpty((String)password)) {
            System.out.println("Using default admin password.");
            this.configuration.setAdminPassword("admin");
        } else {
            this.configuration.setAdminPassword(password);
        }
    }

    private void askWebContextRoot() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the web context root where " + this.serverName + " will run");
        Object contextRoot = SetupHelperMethods.getStringResponse((String)"/");
        if (!((String)contextRoot).startsWith("/")) {
            contextRoot = "/" + (String)contextRoot;
        }
        this.configuration.setWebContextRoot((String)contextRoot);
    }

    private void askServerUrl() {
        if (!this.askServerUrl) {
            return;
        }
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the public URL to access " + this.serverName);
        String derivedUrl = this.configuration.getDerivedServerUrl();
        String serverUrl = SetupHelperMethods.getStringResponse((String)derivedUrl);
        if (!derivedUrl.equals(serverUrl)) {
            this.configuration.setServerUrl(serverUrl);
        }
    }

    private boolean askToEnableSsl() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedSsl = this.configuration.isNewConfiguration() || this.configuration.isSsl();
        this.configuration.setSsl(SetupHelperMethods.getBooleanResponse((boolean)suppliedSsl));
        return this.configuration.isSsl();
    }

    private boolean askToGenerateKeys() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Would you like to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean suppliedGenerateKeys = this.configuration.isNewConfiguration() || this.generateKeyStore;
        this.generateKeyStore = SetupHelperMethods.getBooleanResponse((boolean)suppliedGenerateKeys);
        return this.generateKeyStore;
    }

    private void setDefaultKeyStoreSettings() {
        this.configuration.setKeyStorePath("conf/keystore.p12");
        this.configuration.setKeyStorePassword("keystoresecret");
        this.configuration.setKeyStoreKeyPassword("keystoresecret");
    }

    private void askKeyStoreSettings() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the path to the keystore?");
        String suppliedKeyStorePath = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStorePath();
        this.configuration.setKeyStorePath(SetupHelperMethods.getStringResponse((String)suppliedKeyStorePath));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        String suppliedKeyStorePassword = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStorePassword();
        this.configuration.setKeyStorePassword(SetupHelperMethods.getStringResponse((String)suppliedKeyStorePassword));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        String suppliedKeyStoreKeyPassword = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStoreKeyPassword();
        this.configuration.setKeyStoreKeyPassword(SetupHelperMethods.getStringResponse((String)suppliedKeyStoreKeyPassword));
    }

    private boolean askToEnableMutualSsl() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Would you like to enable mutual SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedMutualSsl = this.configuration.isNewConfiguration() || this.configuration.isMutualSsl();
        this.configuration.setMutualSsl(SetupHelperMethods.getBooleanResponse((boolean)suppliedMutualSsl));
        return this.configuration.isMutualSsl();
    }

    private void askTrustStoreSettings() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the path to the truststore?");
        String suppliedTrustStorePath = this.configuration.isNewConfiguration() ? "" : this.configuration.getTrustStorePath();
        this.configuration.setTrustStorePath(SetupHelperMethods.getStringResponse((String)suppliedTrustStorePath));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the password to the truststore?");
        String suppliedTrustStorePassword = this.configuration.isNewConfiguration() ? "" : this.configuration.getTrustStorePassword();
        this.configuration.setTrustStorePassword(SetupHelperMethods.getStringResponse((String)suppliedTrustStorePassword));
    }

    private void askHttpBindAddressForJetty() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("What http bind address would you like the server to listen on?");
        String defaultAddress = Strings.isEmpty((String)this.configuration.getHttpBindAddress()) ? "0.0.0.0" : this.configuration.getHttpBindAddress();
        this.configuration.setHttpBindAddress(SetupHelperMethods.getStringResponse((String)defaultAddress));
    }

    private void askHttpPortForJetty() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int defaultPort = this.configuration.isSsl() ? 4517 : 4516;
        int suppliedPort = this.configuration.getHttpPort() == 0 ? defaultPort : this.configuration.getHttpPort();
        this.configuration.setHttpPort(SetupHelperMethods.getValidIntegerResponse((int)suppliedPort));
    }

    private void askMinumAmountOfThreads() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 30 for 10 concurrent users)");
        int minThreads = 30;
        int suppliedMinThreads = this.configuration.getMinThreads() == 0 ? minThreads : this.configuration.getMinThreads();
        this.configuration.setMinThreads(SetupHelperMethods.getValidIntegerResponse((int)suppliedMinThreads));
    }

    private void askMaximumAmountOfThreads() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 150 for 50 concurrent users)");
        int maxThreads = 150;
        int suppliedMaxThreads = this.configuration.getMaxThreads() == 0 ? maxThreads : this.configuration.getMaxThreads();
        this.configuration.setMaxThreads(SetupHelperMethods.getValidIntegerResponse((int)suppliedMaxThreads));
    }

    private void generateKeyStore() {
        String keyAlgorithm = "RSA";
        String keyStoreKeyAlias = "jetty";
        String dname = "CN=localhost,O=" + this.serverName + ",C=NL";
        try {
            int exitValue;
            File keyStoreFile = new File(this.configuration.getKeyStorePath());
            if (keyStoreFile.exists()) {
                System.out.println("Existing keystore " + this.configuration.getKeyStorePath() + " deleted.");
                keyStoreFile.delete();
            }
            System.out.println("Generating keystore...");
            String[] keytoolArgs = new String[]{"keytool", "-genkey", "-keyalg", keyAlgorithm, "-keystore", this.configuration.getKeyStorePath(), "-storepass", this.configuration.getKeyStorePassword(), "-alias", keyStoreKeyAlias, "-keypass", this.configuration.getKeyStoreKeyPassword(), "-validity", "366", "-dname", dname, "-deststoretype", "pkcs12"};
            Process p = Runtime.getRuntime().exec(keytoolArgs);
            Thread outputThread = new Thread(new InputStreamToOutputStream(p.getInputStream(), System.out));
            outputThread.start();
            Thread errorThread = new Thread(new InputStreamToOutputStream(p.getErrorStream(), System.err));
            errorThread.start();
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException exc) {
                throw new IOException(exc.toString());
            }
            if (exitValue != 0) {
                throw new IOException("keytool exited with status code " + exitValue);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not generate keystore " + this.configuration.getKeyStorePath() + ": " + exc.toString());
        }
    }

    private void initializeRepository() {
        this.deleteDatabase("repository");
        this.deleteDatabase("archive");
    }

    private void deleteDatabase(String database) {
        Path repositoryDbPath = Paths.get(database, new String[0]);
        if (Files.exists(repositoryDbPath, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(repositoryDbPath, new FileVisitOption[0]);){
                walk.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
            catch (IOException e) {
                System.err.println("ERROR: Could not delete " + database + " database. " + e.getMessage());
            }
        }
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public InputStreamToOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            OverthereUtils.write((InputStream)this.in, (OutputStream)this.out);
        }
    }
}

