/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.rest.mappers.UnhandledExceptionMapper;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UnhandledExceptionMapperProvider
extends UnhandledExceptionMapper
implements ExceptionMapper<RuntimeException> {
    @Autowired
    public UnhandledExceptionMapperProvider(ServerConfiguration config) {
        super(config);
    }

    protected Response handleException(RuntimeException runtimeException) {
        Response response = super.handleException(runtimeException);
        response.getMetadata().add((Object)"Date", (Object)new Date());
        if (runtimeException instanceof NotFoundException) {
            return Response.fromResponse((Response)response).status(Response.Status.NOT_FOUND).build();
        }
        if (runtimeException instanceof IllegalArgumentException) {
            return Response.fromResponse((Response)response).status(Response.Status.BAD_REQUEST).entity((Object)runtimeException.getMessage()).build();
        }
        if (runtimeException instanceof NotAllowedException) {
            return Response.fromResponse((Response)response).status(Response.Status.METHOD_NOT_ALLOWED).entity((Object)runtimeException.getMessage()).build();
        }
        return response;
    }
}

