package com.xebialabs.xlrelease.actors.utils

import com.xebialabs.xlplatform.cluster.ClusterMode.Full
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.repository.IdMatchers.TriggerId
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport
import org.apache.pekko.actor.{ActorSystem, PoisonPill}
import org.springframework.context.{ApplicationContext, ApplicationContextAware}
import org.springframework.stereotype.Component

import scala.beans.BeanProperty
import scala.concurrent.Await

@Component
class TriggerActorLifecycleUtils extends ActorLifecycleUtils with ApplicationContextAware with ScalaSpringSupport {
  import scala.concurrent.duration._
  @BeanProperty
  var applicationContext: ApplicationContext = _

  private lazy val actorSystemHolder = springBean[ActorSystemHolder]

  def terminateAllTriggerActors(): Unit = {
    terminateActors("*")
  }

  // returns terminated actor id
  def terminateTriggerActor(trigger: Trigger): String = {
    terminateActors(TriggerId.actorName(trigger.getId))
  }

  private def terminateActors(actorPath: String): String = {
    lazy implicit val system: ActorSystem = actorSystemHolder.getInstance()
    val terminationResult = findAndTerminate(toActorPath(actorPath), terminationMsg = Some(PoisonPill))
    Await.result(terminationResult, 5.seconds)
  }

  private def toActorPath(path: String): String = {
    if (path.startsWith("/")) {
      path
    } else if (XlrConfig.getInstance.clusterMode == Full) {
      s"/system/sharding/trigger-processing-actor/*/${path}"
    } else {
      s"/user/trigger-processing-actor/${path}"
    }
  }

}
