/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.metrics.MetricsConfiguration$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\tUb\u0001B\u0011#\u0001-B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\"\u00020\u0001\t\u0003y\u0006\u0002\u00034\u0001\u0011\u000b\u0007I\u0011B4\t\u000f-\u0004\u0001\u0019!C\u0005Y\"9q\u000f\u0001a\u0001\n\u0013A\bB\u0002@\u0001A\u0003&Q\u000e\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0015BA\u0002\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\t\u0001C\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0003\u0002\u0016!A\u0011\u0011\u0004\u0001!B\u0013\t\u0019\u0001C\u0004\u0002\u001c\u0001!\t!!\u0001\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003'\u0002A\u0011CA+\u0011%\tI\bAI\u0001\n#\tY\bC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0005\u0002|!9\u0011\u0011\u0013\u0001\u0005\u0012\u0005}\u0001bBAJ\u0001\u0011%\u0011Q\u0013\u0005\n\u0003K\u0003\u0011\u0013!C\u0005\u0003OCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002N\u0002!I!a4\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\n\u0001\u0011\u0005\u0011q\u0004\u0005\u0007\u0005+\u0001A\u0011\u00027\u0003#A\u0013X-\u0011:dQ&4XmU3sm&\u001cWM\u0003\u0002$I\u000591/\u001a:wS\u000e,'BA\u0013'\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002(Q\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002S\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003tY\u001a$$NC\u00018\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001d5\u0005\u001daunZ4j]\u001e\f\u0011\u0002\u001f7s\u0007>tg-[4\u0011\u0005qzT\"A\u001f\u000b\u0005y\"\u0013AB2p]\u001aLw-\u0003\u0002A{\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"a\u0011#\u000e\u0003\tJ!!\u0012\u0012\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nJ\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001'J\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0010CJ\u001c\u0007.\u001b<j]\u001e\u001cuN\u001c4jOB\u0011AhT\u0005\u0003!v\u0012\u0001$\u0011:dQ&4\u0018N\\4TKR$\u0018N\\4t\u001b\u0006t\u0017mZ3s\u00035iW\r^3s%\u0016<\u0017n\u001d;ssB\u00111\u000bX\u0007\u0002)*\u0011QKV\u0001\u000bS:\u001cHO];nK:$(BA,Y\u0003\u0011\u0019wN]3\u000b\u0005eS\u0016AC7jGJ|W.\u001a;fe*\t1,\u0001\u0002j_&\u0011Q\f\u0016\u0002\u000e\u001b\u0016$XM\u001d*fO&\u001cHO]=\u0002\rqJg.\u001b;?)\u0019\u0001\u0017MY2eKB\u00111\t\u0001\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u0006\r\u001a\u0001\ra\u0012\u0005\u0006\u001b\u001a\u0001\rA\u0014\u0005\u0006#\u001a\u0001\rAU\u0001\u000f[\u0006DH\u000b\u001b:fC\u0012\u001cu.\u001e8u+\u0005A\u0007CA\u0017j\u0013\tQgFA\u0002J]R\fA\u0001]8pYV\tQ\u000e\u0005\u0002ok6\tqN\u0003\u0002qc\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005I\u001c\u0018\u0001B;uS2T\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002w_\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0011A|w\u000e\\0%KF$\"!\u001f?\u0011\u00055R\u0018BA>/\u0005\u0011)f.\u001b;\t\u000fuL\u0011\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002\u000bA|w\u000e\u001c\u0011\u0002\u000f\u0015t\u0017M\u00197fIV\u0011\u00111\u0001\t\u0004[\u0005\u0015\u0011bAA\u0004]\t9!i\\8mK\u0006t\u0017aC3oC\ndW\rZ0%KF$2!_A\u0007\u0011!iH\"!AA\u0002\u0005\r\u0011\u0001C3oC\ndW\r\u001a\u0011\u0002\u0015\r\fGo\u00195j]\u001e,\u0006/\u0001\bdCR\u001c\u0007.\u001b8h+B|F%Z9\u0015\u0007e\f9\u0002\u0003\u0005~\u001f\u0005\u0005\t\u0019AA\u0002\u0003-\u0019\u0017\r^2iS:<W\u000b\u001d\u0011\u0002\u0013%\u001cXI\\1cY\u0016$\u0017!B:uCJ$H#A=\u00025A\u0014X-\u0011:dQ&4XmQ8na2,G/\u001a3SK2,\u0017m]3\u0015\u0007e\f)\u0003C\u0004\u0002(M\u0001\r!!\u000b\u0002\u000b\u00154XM\u001c;\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u00051QM^3oiNT1!a\r%\u0003\u0019!w.\\1j]&!\u0011qGA\u0017\u0005U\u0011V\r\\3bg\u0016\u001cu.\u001c9mKR,G-\u0012<f]RD3aEA\u001e!\u0011\ti$!\u0011\u000e\u0005\u0005}\"bAA\u0018I%!\u00111IA \u0005%\u0019VOY:de&\u0014W-\u0001\rqe\u0016\f%o\u00195jm\u0016\f%m\u001c:uK\u0012\u0014V\r\\3bg\u0016$2!_A%\u0011\u001d\t9\u0003\u0006a\u0001\u0003\u0017\u0002B!a\u000b\u0002N%!\u0011qJA\u0017\u0005M\u0011V\r\\3bg\u0016\f%m\u001c:uK\u0012,e/\u001a8uQ\r!\u00121H\u0001\u000baJ,\u0017I]2iSZ,GcB=\u0002X\u0005\r\u0014q\r\u0005\b\u00033*\u0002\u0019AA.\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!!\u0018\u0002`5\u0011\u0011\u0011G\u0005\u0005\u0003C\n\tDA\u0004SK2,\u0017m]3\t\u0013\u0005\u0015T\u0003%AA\u0002\u0005\r\u0011\u0001D2iK\u000e\\WI\\1cY\u0016$\u0007\"CA5+A\u0005\t\u0019AA\u0002\u0003=\u0011XmY8wKJLe-\u0012=jgR\u001c\bfA\u000b\u0002nA!\u0011qNA;\u001b\t\t\tHC\u0002\u0002tY\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001d\u0003\u000bQKW.\u001a3\u0002)A\u0014X-\u0011:dQ&4X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tiH\u000b\u0003\u0002\u0004\u0005}4FAAA!\u0011\t\u0019)a#\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Md&\u0003\u0003\u0002\u000e\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!\u0002O]3Be\u000eD\u0017N^3%I\u00164\u0017-\u001e7uIM\na\u0005\u001d:f\u0003J\u001c\u0007.\u001b<f\u0013:\f7\r^5wKJ+G.Z1tKNLeNQ1dW\u001e\u0014x.\u001e8e\u0003i\u0001(/Z!sG\"Lg/Z%oC\u000e$\u0018N^3SK2,\u0017m]3t)\rI\u0018q\u0013\u0005\t\u00033K\u0002\u0013!a\u0001Q\u0006!\u0001/Y4fQ\rI\u0012Q\u0014\t\u0005\u0003?\u000b\t+\u0004\u0002\u0002\n&!\u00111UAE\u0005\u001d!\u0018-\u001b7sK\u000e\fA\u0005\u001d:f\u0003J\u001c\u0007.\u001b<f\u0013:\f7\r^5wKJ+G.Z1tKN$C-\u001a4bk2$H%M\u000b\u0003\u0003SS3\u0001[A@\u0003=\u0019XOY7ji^KG\u000f\u001b#fY\u0006LH\u0003BAX\u0003w#2!_AY\u0011\u001d\t\u0019l\u0007a\u0001\u0003k\u000b1A[8c!\u0011i\u0013qW=\n\u0007\u0005efFA\u0005Gk:\u001cG/[8oa!9\u0011QX\u000eA\u0002\u0005}\u0016!\u00023fY\u0006L\b\u0003BAa\u0003\u0013l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0001OL\u0005\u0005\u0003\u0017\f\u0019M\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\rM,(-\\5u+\u0011\t\t.a7\u0015\u0007e\f\u0019\u000eC\u0004\u00024r\u0001\r!!6\u0011\u000b5\n9,a6\u0011\t\u0005e\u00171\u001c\u0007\u0001\t\u001d\ti\u000e\bb\u0001\u0003?\u0014\u0011!V\t\u0005\u0003C\f9\u000fE\u0002.\u0003GL1!!:/\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!LAu\u0013\r\tYO\f\u0002\u0004\u0003:L\u0018\u0001\u0003:v]:\f'\r\\3\u0016\t\u0005E(q\u0001\u000b\u0005\u0003g\fy\u0010\u0005\u0003\u0002v\u0006mXBAA|\u0015\r\tIp]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002~\u0006](\u0001\u0003*v]:\f'\r\\3\t\u000f\t\u0005Q\u00041\u0001\u0003\u0004\u0005!!m\u001c3z!\u0015i\u0013q\u0017B\u0003!\u0011\tINa\u0002\u0005\u000f\u0005uWD1\u0001\u0002`\u00069A-[:bE2,GC\u0001B\u0007!\ri#qB\u0005\u0004\u0005#q#AB!osZ\u000bG.\u0001\u0004f]\u0006\u0014G.Z\u0001\u000bGJ,\u0017\r^3Q_>d\u0007f\u0001\u0001\u0003\u001aA!!1\u0004B\u0015\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012AC:uKJ,w\u000e^=qK*!!1\u0005B\u0013\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'B\u0001B\u0014\u0003\ry'oZ\u0005\u0005\u0005W\u0011iBA\u0004TKJ4\u0018nY3)\u0007\u0001\u0011y\u0003\u0005\u0003\u0002>\tE\u0012\u0002\u0002B\u001a\u0003\u007f\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\b")
public class PreArchiveService
implements Logging {
    private int maxThreadCount;
    private final XlrConfig xlrConfig;
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private final MeterRegistry meterRegistry;
    private ScheduledExecutorService pool;
    private boolean enabled;
    private boolean catchingUp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private int maxThreadCount$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$0) {
                this.maxThreadCount = this.xlrConfig.executors().preArchivingExecutor().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        return this.maxThreadCount;
    }

    private int maxThreadCount() {
        if (!this.bitmap$0) {
            return this.maxThreadCount$lzycompute();
        }
        return this.maxThreadCount;
    }

    private ScheduledExecutorService pool() {
        return this.pool;
    }

    private void pool_$eq(ScheduledExecutorService x$1) {
        this.pool = x$1;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> "Starting PreArchiveService");
        this.logger().trace((Function0 & Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().debug((Function0 & Serializable)() -> "PreArchiveService started.");
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled, boolean recoverIfExists) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    this.logger().info((Function0 & Serializable)() -> "Pre-archiving " + release);
                    $this.archivingService.preArchiveRelease(release);
                    this.logger().debug((Function0 & Serializable)() -> "Pre-archived " + release);
                }
                catch (Exception e) {
                    this.logger().warn((Function0 & Serializable)() -> "Something went wrong while pre-archiving", (Function0 & Serializable)() -> e);
                    if (!recoverIfExists) {
                        throw e;
                    }
                    if ($this.archivingService.exists(release.getId())) {
                        this.logger().debug((Function0 & Serializable)() -> "Removing " + release + " from Archive Database");
                        if ($this.archivingService.deletePreArchiveRelease(release.getId())) {
                            this.logger().debug((Function0 & Serializable)() -> "Pre-archiving again " + release);
                            this.preArchive(release, checkEnabled, false);
                        } else {
                            this.logger().debug((Function0 & Serializable)() -> "Removing failed " + release + " from Archive Database");
                        }
                    }
                    this.logger().debug((Function0 & Serializable)() -> "Release " + release + " does not exist in Archive Database", (Function0 & Serializable)() -> e);
                    throw e;
                }
            });
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Pre-archiving is disabled");
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public boolean preArchive$default$3() {
        return true;
    }

    public synchronized void preArchiveInactiveReleasesInBackground() {
        if (!this.catchingUp()) {
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
            return;
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable)() -> "Fetching page " + page + " (" + pageSize + " releases) for pre-archiving...");
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            ((IterableOnceOps)found.filter((Function1 & Serializable)release -> BoxesRunTime.boxToBoolean((boolean)this.archivingService.shouldArchive(release)))).foreach((Function1 & Serializable)x$1 -> {
                this.preArchive(x$1, false, this.preArchive$default$3());
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private void submitWithDelay(FiniteDuration delay, Function0<BoxedUnit> job) {
        this.pool().schedule(this.runnable(job), delay.toSeconds(), TimeUnit.SECONDS);
    }

    private <U> void submit(Function0<U> job) {
        this.pool().submit(this.runnable(job));
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public Object disable() {
        Object object;
        try {
            this.pool().shutdown();
            object = BoxesRunTime.boxToBoolean((boolean)this.pool().awaitTermination(10L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> "Unable to disable pre-archive service");
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public void enable() {
        if (this.pool().isShutdown() || this.pool().isTerminated()) {
            this.pool_$eq(this.createPool());
            return;
        }
    }

    private ScheduledExecutorService createPool() {
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(this.maxThreadCount(), new PrefixedThreadFactory("pre-archiving", Predef$.MODULE$.boolean2Boolean(true)));
        if (this.xlrConfig.metrics().enabled()) {
            return ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ScheduledExecutorService)threadPool, (String)"pre-archiving", (Tag[])new Tag[]{MetricsConfiguration$.MODULE$.TAG_EXECUTOR()});
        }
        return threadPool;
    }

    public PreArchiveService(XlrConfig xlrConfig, ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig, MeterRegistry meterRegistry) {
        this.xlrConfig = xlrConfig;
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        this.meterRegistry = meterRegistry;
        Logging.$init$((Logging)this);
        this.pool = this.createPool();
        this.enabled = false;
        this.catchingUp = false;
    }
}

