package com.xebialabs.xlrelease.security

import com.xebialabs.deployit.security.Role
import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Team
import com.xebialabs.xlrelease.repository.ReleaseInformation
import com.xebialabs.xlrelease.repository.query.TaskBasicData

trait PermissionContextEnv {
  def hasGlobalPermission(permission: Permission): Boolean

  def getReleaseInformation(releaseId: String): Option[ReleaseInformation]

  def hasArchivedReleasePermission(permission: Permission, containerId: String): Boolean

  def isCurrentUserAdmin(): Boolean

  def hasEffectiveSecuredCiPermission(permission: Permission, containerId: String): Boolean

  def getTaskData(taskId: String): TaskBasicData

  def isMemberOrRoleOf(releaseId: String, teamName: String): Boolean

  def findTeamByName(containerId: String, teamName: String): Option[Team]

  def getRolesFor(principal: String): java.util.List[Role]

  def isExternalUserPrincipalIsFromTheGroupAssigned(user: String, team: Team): Boolean

  def xlrConfig: XlrConfig
}
