package com.xebialabs.xlrelease.features

import com.xebialabs.xlrelease.features.distributed.BaseDistributedFeature
import com.xebialabs.xlrelease.features.settings.TaskExecutionLogSettings

trait TaskExecutionLogsFeature {
  def isLogTruncationEnabled: Boolean

  def getMaxSizeInBytes: Long
}

object TaskExecutionLogsFeature extends BaseDistributedFeature[TaskExecutionLogSettings] with TaskExecutionLogsFeature {

  def isLogTruncationEnabled: Boolean = featureSettings.logTruncationEnabled

  def getMaxSizeInBytes: Long = featureSettings.maxSize * 1024 * 1024
}
