package com.xebialabs.xlrelease.scheduler.logs

import com.xebialabs.xlrelease.storage.domain.LogEntry
import com.xebialabs.xlrelease.utils.{HashUtils, InstantUtils}

import java.time.Instant


case class TaskExecutionEntry(taskIdHash: String,
                              executionId: String,
                              lastJob: Int,
                              lastChunk: Int,
                              lastModifiedDate: Instant,
                              endDate: Option[Instant],
                              logSize: Long,
                              truncated: Boolean = false) {

  def mergeMax(other: TaskExecutionEntry): TaskExecutionEntry = {
    TaskExecutionEntry(
      taskIdHash,
      executionId,
      Integer.max(lastJob, other.lastJob),
      Integer.max(lastChunk, other.lastChunk),
      if (lastModifiedDate.isAfter(other.lastModifiedDate)) lastModifiedDate else other.lastModifiedDate,
      endDate = InstantUtils.maxInstant(endDate, other.endDate),
      logSize = logSize + other.logSize,
      truncated = truncated || other.truncated
    )
  }

}

object TaskExecutionEntry {

  def from(logEntry: LogEntry, endDate: Instant = Instant.now()): TaskExecutionEntry = {
    TaskExecutionEntry(
      HashUtils.hash(logEntry.taskId),
      logEntry.executionId,
      logEntry.jobId.toInt,
      logEntry.chunk.toInt,
      Instant.parse(logEntry.lastEntryTimestamp),
      Option(endDate),
      logEntry.payload.length
    )
  }
}
