package com.xebialabs.xlrelease.views;

import java.util.Map;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.variable.VariableHelper;

import static com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator.EFFECTIVE_SECURITY;

/**
 * Release details available to users who have access to the task.
 */
public class TaskReleaseView {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id; // release ID
    private ReleaseStatus status;
    private boolean archived;
    private EffectiveSecurity security;
    private Map<String, String> variables;

    public TaskReleaseView(Task task, Release release) {
        id = release.getId();
        status = release.getStatus();
        archived = release.isArchived();
        security = (EffectiveSecurity) release.get$metadata().get(EFFECTIVE_SECURITY());
        variables = VariableHelper.getVariableValuesAsStrings(task.getInputVariables());
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public ReleaseStatus getStatus() {
        return status;
    }

    public boolean isArchived() {
        return archived;
    }

    public EffectiveSecurity getSecurity() {
        return security;
    }

    public Map<String, String> getVariables() {
        return variables;
    }

    public void setVariables(final Map<String, String> variables) {
        this.variables = variables;
    }
}
