/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.CalendarEntry;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.events.BlackoutCreatedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000bq\u0003A\u0011A/\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00020\u0001!\t!a\u0010\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!a\u001f\u0001\t\u0003\t)\tC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\ny1)\u00197f]\u0012\f'oU3sm&\u001cWM\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9C&D\u0001)\u0015\tI#&A\u0003tY\u001a$$NC\u0001,\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0017)\u0005\u001daunZ4j]\u001e\fqcY1mK:$\u0017M]#oiJL(+\u001a9pg&$xN]=\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!a\r\r\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00026e\t92)\u00197f]\u0012\f'/\u00128uef\u0014V\r]8tSR|'/_\u0001\u0019G\u0006dWM\u001c3be\u0016sGO]=SKB|7/\u001b;pef\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012!\u000f\t\u0003umj\u0011AF\u0005\u0003yY\u00111bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u0005AQM^3oi\n+8/F\u0001A!\t\tE)D\u0001C\u0015\t\u0019\u0005$\u0001\u0004fm\u0016tGo]\u0005\u0003\u000b\n\u0013\u0001\"\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtD\u0003B%K\u00172\u0003\"A\u000f\u0001\t\u000b9:\u0001\u0019\u0001\u0019\t\u000b]:\u0001\u0019A\u001d\t\u000by:\u0001\u0019\u0001!)\u0005\u001dq\u0005CA([\u001b\u0005\u0001&BA)S\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003'R\u000bqAZ1di>\u0014\u0018P\u0003\u0002V-\u0006)!-Z1og*\u0011q\u000bW\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011,A\u0002pe\u001eL!a\u0017)\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!D4fiN\u0003XmY5bY\u0012\u000b\u0017\u0010\u0006\u0002_MB\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\tG\u0006dWM\u001c3be*\u00111\rG\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0015\u0004'AC*qK\u000eL\u0017\r\u001c#bs\")q\r\u0003a\u0001Q\u0006a1\u000f]3dS\u0006dG)Y=JIB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a\u001b\u0012\u000e\u00031T!!\u001c\u0010\u0002\rq\u0012xn\u001c;?\u0013\ty'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8#Q\tAA\u000f\u0005\u0002v{6\taO\u0003\u0002Ro*\u0011\u00010_\u0001\u0005G>\u0014XM\u0003\u0002{w\u0006QQ.[2s_6,G/\u001a:\u000b\u0003q\f!![8\n\u0005y4(!\u0002+j[\u0016$\u0017!D:fiN\u0003XmY5bY\u0012\u000b\u0017\u0010F\u0003_\u0003\u0007\t)\u0001C\u0003h\u0013\u0001\u0007\u0001\u000e\u0003\u0004\u0002\b%\u0001\rAX\u0001\u000bgB,7-[1m\t\u0006L\bFA\u0005u\u000399W\r^*qK\u000eL\u0017\r\u001c#bsN$b!a\u0004\u0002 \u0005%\u0002#BA\t\u00037qVBAA\n\u0015\u0011\t)\"a\u0006\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\n\u0005\u0011a\u0015n\u001d;\t\u000f\u0005\u0005\"\u00021\u0001\u0002$\u0005!aM]8n!\u0011\t\t\"!\n\n\t\u0005\u001d\u00121\u0003\u0002\u0005\t\u0006$X\rC\u0004\u0002,)\u0001\r!a\t\u0002\u0005Q|\u0007F\u0001\u0006u\u0003-\tG\r\u001a\"mC\u000e\\w.\u001e;\u0015\t\u0005M\u0012\u0011\b\t\u0004?\u0006U\u0012bAA\u001cA\nA!\t\\1dW>,H\u000fC\u0004\u0002<-\u0001\r!a\r\u0002\u0011\td\u0017mY6pkRD#a\u0003;\u0015\r\u0005M\u0012\u0011IA#\u0011\u0019\t\u0019\u0005\u0004a\u0001Q\u0006A\u0001/\u0019:f]RLE\rC\u0004\u0002<1\u0001\r!a\r)\u00051!\u0018AD;qI\u0006$XM\u00117bG.|W\u000f\u001e\u000b\u0005\u0003g\ti\u0005C\u0004\u0002P5\u0001\r!a\r\u0002\u000fU\u0004H-\u0019;fI\"\u0012Q\u0002^\u0001\u000fI\u0016dW\r^3CY\u0006\u001c7n\\;u)\u0011\t9&!\u0018\u0011\u0007\u0005\nI&C\u0002\u0002\\\t\u0012A!\u00168ji\"1\u0011q\f\bA\u0002!\f!B\u00197bG.|W\u000f^%eQ\tqA/A\u0006hKR\u0014E.Y2l_V$H\u0003BA\u001a\u0003OBa!a\u0018\u0010\u0001\u0004A\u0007FA\bu\u00031I7/\u00138CY\u0006\u001c7n\\;u)\u0011\ty'!\u001e\u0011\u0007\u0005\n\t(C\u0002\u0002t\t\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002xA\u0001\r!a\t\u0002\u00079|w\u000f\u000b\u0002\u0011i\u0006aq-\u001a;CY\u0006\u001c7n\\;ugR!\u0011qPAA!\u0019\t\t\"a\u0007\u00024!9\u0011qO\tA\u0002\u0005\r\u0002FA\tu)\u0019\ty(a\"\u0002\n\"9\u0011\u0011\u0005\nA\u0002\u0005\r\u0002bBA\u0016%\u0001\u0007\u00111\u0005\u0015\u0003%Q\f\u0001b]3u\t\u0006$Xm\u001d\u000b\u0007\u0003/\n\t*!&\t\r\u0005M5\u00031\u0001i\u0003\tIG\r\u0003\u0004\u0002\bM\u0001\rAX\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qKAN\u0011\u001d\tY\u0004\u0006a\u0001\u0003gA3\u0001AAP!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS-\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005%\u00161\u0015\u0002\b'\u0016\u0014h/[2f\u0001")
public class CalendarService
implements Logging {
    private final CalendarEntryRepository calendarEntryRepository;
    private final CiIdService ciIdService;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CalendarService calendarService = this;
        synchronized (calendarService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public CalendarEntryRepository calendarEntryRepository() {
        return this.calendarEntryRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public SpecialDay getSpecialDay(String specialDayId) {
        if (!this.calendarEntryRepository().exists(specialDayId)) {
            SpecialDay result = new SpecialDay();
            result.setId(specialDayId);
            this.setDates(specialDayId, result);
            return result;
        }
        return (SpecialDay)this.calendarEntryRepository().findById(specialDayId);
    }

    @Timed
    public SpecialDay setSpecialDay(String specialDayId, SpecialDay specialDay) {
        if (specialDay.isBlank()) {
            this.logger().debug((Function0 & Serializable)() -> "Removing special day [" + specialDayId + "]");
            if (this.calendarEntryRepository().exists(specialDayId)) {
                this.calendarEntryRepository().delete(specialDayId);
            }
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Saving special day [" + specialDayId + "] with label [" + specialDay.getLabel() + "] and color [" + specialDay.getColor() + "]");
            specialDay.setId(specialDayId);
            this.setDates(specialDayId, specialDay);
            this.calendarEntryRepository().createOrUpdate((CalendarEntry)specialDay);
        }
        return specialDay;
    }

    @Timed
    public List<SpecialDay> getSpecialDays(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(SpecialDay.class), from, to);
    }

    @Timed
    public Blackout addBlackout(Blackout blackout) {
        return this.addBlackout(Ids.CALENDAR_ROOT, blackout);
    }

    @Timed
    public Blackout addBlackout(String parentId, Blackout blackout) {
        this.logger().debug((Function0 & Serializable)() -> "Adding new blackout [" + blackout.getLabel() + " for period [" + blackout.getStartDate() + "] - [" + blackout.getEndDate() + "] to parent [" + parentId + "]");
        this.validate(blackout);
        blackout.setId(this.ciIdService().getUniqueId(Type.valueOf(Blackout.class), parentId));
        this.calendarEntryRepository().create((CalendarEntry)blackout);
        this.eventBus().publish((XLReleaseEvent)new BlackoutCreatedEvent(blackout));
        return blackout;
    }

    @Timed
    public Blackout updateBlackout(Blackout updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating blackout [" + updated.getId() + "]");
        this.validate(updated);
        Blackout original = (Blackout)this.calendarEntryRepository().findById(updated.getId());
        this.calendarEntryRepository().update((CalendarEntry)updated);
        this.eventBus().publish((XLReleaseEvent)new BlackoutUpdatedEvent(original, updated));
        return updated;
    }

    @Timed
    public void deleteBlackout(String blackoutId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting blackout [" + blackoutId + "]");
        Blackout blackout = (Blackout)this.calendarEntryRepository().findById(blackoutId);
        this.calendarEntryRepository().delete(blackoutId);
        this.eventBus().publish((XLReleaseEvent)new BlackoutDeletedEvent(blackout));
    }

    @Timed
    public Blackout getBlackout(String blackoutId) {
        return (Blackout)this.calendarEntryRepository().findById(blackoutId);
    }

    @Timed
    public boolean isInBlackout(Date now) {
        return this.calendarEntryRepository().existsByTypeInRange(Type.valueOf(Blackout.class), now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date now) {
        return this.getBlackouts(now, now);
    }

    @Timed
    public List<Blackout> getBlackouts(Date from, Date to) {
        return this.calendarEntryRepository().findAllByTypeInRange(Type.valueOf(Blackout.class), from, to);
    }

    private void setDates(String id, SpecialDay specialDay) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            dateFormat.setLenient(false);
            DateTime specialDayDate = new DateTime((Object)dateFormat.parse(Ids.getName((String)id)));
            specialDay.setStartDate(specialDayDate.withTimeAtStartOfDay().toDate());
            specialDay.setEndDate(specialDayDate.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Special day ID [" + id + "] does not have a valid format - Configuration/Calendar/yyyyMMdd.", e);
        }
    }

    private void validate(Blackout blackout) {
        int blackoutLabelCharLength = 1024;
        Checks.checkNotNull((Object)blackout.getLabel(), (String)"Blackout label");
        Checks.checkArgument((blackout.getLabel().length() <= blackoutLabelCharLength ? 1 : 0) != 0, (String)"Blackout Label must be less than 1024 characters", (Object[])new Object[0]);
        Checks.checkNotNull((Object)blackout.getStartDate(), (String)"Blackout start date");
        Checks.checkNotNull((Object)blackout.getEndDate(), (String)"Blackout end date");
        Checks.checkArgument((boolean)blackout.getStartDate().before(blackout.getEndDate()), (String)"Blackout end date must be after start date.", (Object[])new Object[0]);
    }

    @Autowired
    public CalendarService(CalendarEntryRepository calendarEntryRepository, CiIdService ciIdService, EventBus eventBus) {
        this.calendarEntryRepository = calendarEntryRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

