/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.authentication.InternalUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.authentication.OwnerAuthenticationToken;
import com.xebialabs.xlrelease.security.authentication.TokenExpiredException;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\n\u0015\u0001}A\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000b\u0001\u0004A\u0011A1\t\u000f)\u0004\u0001\u0019!C\u0005W\"9a\u000f\u0001a\u0001\n\u00139\bbBA\u0001\u0001\u0001\u0006K\u0001\u001c\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u00111\u0016\u0001\u0005B\u00055\u0006BBAg\u0001\u0011\u00051\u000eC\u0004\u0002P\u0002!\t!!5\u0003;I+G.Z1tK\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJT!!\u0006\f\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011q\u0003G\u0001\tg\u0016\u001cWO]5us*\u0011\u0011DG\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0007\u000f\u0002\u0013a,'-[1mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001\u0001\u0003F\r\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011\u0006M\u0007\u0002U)\u0011Qc\u000b\u0006\u0003/1R!!\f\u0018\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aL\u0001\u0004_J<\u0017BA\u0019+\u0005Y\tU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0014\u0001C4sSjTH.\u001a3\n\u0005e\"$a\u0002'pO\u001eLgnZ\u0001\fkN,'oU3sm&\u001cW\r\u0005\u0002=\u00016\tQH\u0003\u0002\u0018})\u0011qHG\u0001\tI\u0016\u0004Hn\\=ji&\u0011\u0011)\u0010\u0002\f+N,'oU3sm&\u001cW-\u0001\tvg\u0016\u0014Hk\\6f]N+'O^5dKB\u0011AiR\u0007\u0002\u000b*\u0011a\tG\u0001\bg\u0016\u0014h/[2f\u0013\tAUI\u0001\tVg\u0016\u0014Hk\\6f]N+'O^5dK\u0006QRo]3s\u0019\u0006\u001cH/Q2uSZ,\u0017i\u0019;peN+'O^5dKB\u0011AiS\u0005\u0003\u0019\u0016\u0013!$V:fe2\u000b7\u000f^!di&4X-Q2u_J\u001cVM\u001d<jG\u0016\f\u0001#^:fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0011\u0005=\u0003V\"\u0001\f\n\u0005E3\"\u0001E+tKJ<%o\\;q'\u0016\u0014h/[2f\u0003U\u0001(/\u001b8dSB\fG\u000eR1uCB\u0013xN^5eKJ\u0004\"\u0001V,\u000e\u0003US!A\u0016\r\u0002\u001bA\u0014\u0018N\\2ja\u0006dG-\u0019;b\u0013\tAVKA\u000bQe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u00025A,'o]8oC2\f5mY3tgR{7.\u001a8GK\u0006$XO]3\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0012\u0001\u00034fCR,(/Z:\n\u0005}c&A\u0007)feN|g.\u00197BG\u000e,7o\u001d+pW\u0016tg)Z1ukJ,\u0017A\u0002\u001fj]&$h\bF\u0004cI\u00164w\r[5\u0011\u0005\r\u0004Q\"\u0001\u000b\t\u000bi:\u0001\u0019A\u001e\t\u000b\t;\u0001\u0019A\"\t\u000b%;\u0001\u0019\u0001&\t\u000b5;\u0001\u0019\u0001(\t\u000bI;\u0001\u0019A*\t\u000be;\u0001\u0019\u0001.\u0002#\u0005,H\u000f[8sSRLWm]'baB,'/F\u0001m!\tiG/D\u0001o\u0015\ty\u0007/A\u0004nCB\u0004\u0018N\\4\u000b\u0005E\u0014\u0018!C1vi\"|'/\u001b;z\u0015\t\u00198&\u0001\u0003d_J,\u0017BA;o\u0005a9%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM]\u0001\u0016CV$\bn\u001c:ji&,7/T1qa\u0016\u0014x\fJ3r)\tAh\u0010\u0005\u0002zy6\t!PC\u0001|\u0003\u0015\u00198-\u00197b\u0013\ti(P\u0001\u0003V]&$\bbB@\n\u0003\u0003\u0005\r\u0001\\\u0001\u0004q\u0012\n\u0014AE1vi\"|'/\u001b;jKNl\u0015\r\u001d9fe\u0002\nA\"Y;uQ\u0016tG/[2bi\u0016$B!a\u0002\u0002\u0010A!\u0011\u0011BA\u0006\u001b\u0005\u0011\u0018bAA\u0007e\nq\u0011)\u001e;iK:$\u0018nY1uS>t\u0007bBA\t\u0017\u0001\u0007\u0011qA\u0001\u0006i>\\WM\u001c\u0015\u0006\u0017\u0005U\u0011\u0011\u0005\t\u0006s\u0006]\u00111D\u0005\u0004\u00033Q(A\u0002;ie><8\u000f\u0005\u0003\u0002\n\u0005u\u0011bAA\u0010e\n9\u0012)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\\\u0019\b=\u0005\r\u0012\u0011HA6!\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003SQXBAA\u0016\u0015\r\tiCH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E\"0\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003cQ\u0018'C\u0012\u0002<\u0005\r\u0013\u0011MA#+\u0011\ti$a\u0010\u0016\u0005\u0005\rBaBA!=\t\u0007\u00111\n\u0002\u0002)&!\u0011QIA$\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011\u0011\n>\u0002\rQD'o\\<t#\u0011\ti%a\u0015\u0011\u0007e\fy%C\u0002\u0002Ri\u0014qAT8uQ&tw\r\u0005\u0003\u0002V\u0005mcbA=\u0002X%\u0019\u0011\u0011\f>\u0002\u000fA\f7m[1hK&!\u0011QLA0\u0005%!\u0006N]8xC\ndWMC\u0002\u0002Zi\f\u0014bIA2\u0003K\n9'!\u0013\u000f\u0007e\f)'C\u0002\u0002Ji\fTAI={\u0003S\u0012Qa]2bY\u0006\f4AJA\u000e\u0003e\tW\u000f\u001e5f]RL7-\u0019;f\rJ|W.V:feR{7.\u001a8\u0015\t\u0005\u001d\u0011\u0011\u000f\u0005\b\u0003#a\u0001\u0019AA\u0012\u0003m\tW\u000f\u001e5f]RL7-\u0019;f\rJ|Wn\u0011:fI\u0016tG/[1mgR1\u0011qAA<\u0003wBq!!\u001f\u000e\u0001\u0004\t\u0019#\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u001d\ti(\u0004a\u0001\u0003G\t\u0001\u0002]1tg^|'\u000fZ\u0001\u001dCV$\b.\u001a8uS\u000e\fG/\u001a$s_6\u0014V\r\\3bg\u0016|uO\\3s)\u0011\t9!a!\t\u000f\u0005\u0015e\u00021\u0001\u0002$\u0005)qn\u001e8fe\u0006\u0019RM^1mk\u0006$X-Q;uQ>\u0014\u0018\u000e^5fgR!\u00111RAUa\u0011\ti)!(\u0011\r\u0005=\u0015QSAM\u001b\t\t\tJC\u0002\u0002\u0014\u0012\nA!\u001e;jY&!\u0011qSAI\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0005\u00037\u000bi\n\u0004\u0001\u0005\u0017\u0005}u\"!A\u0001\u0002\u000b\u0005\u0011\u0011\u0015\u0002\u0004?\u0012\"\u0014\u0003BA'\u0003G\u0003B!!\u0003\u0002&&\u0019\u0011q\u0015:\u0003!\u001d\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRL\bbBA=\u001f\u0001\u0007\u00111E\u0001\tgV\u0004\bo\u001c:ugR!\u0011qVA[!\rI\u0018\u0011W\u0005\u0004\u0003gS(a\u0002\"p_2,\u0017M\u001c\u0005\u0007+A\u0001\r!a.1\t\u0005e\u0016\u0011\u0019\t\u0007\u0003K\tY,a0\n\t\u0005u\u0016q\u0007\u0002\u0006\u00072\f7o\u001d\t\u0005\u00037\u000b\t\r\u0002\u0007\u0002D\u0006U\u0016\u0011!A\u0001\u0006\u0003\t)MA\u0002`IU\nB!!\u0014\u0002HB\u0019\u00110!3\n\u0007\u0005-'PA\u0002B]f\fAcZ3u\u0003V$\bn\u001c:ji&,7/T1qa\u0016\u0014\u0018\u0001F:fi\u0006+H\u000f[8sSRLWm]'baB,'\u000fF\u0002y\u0003'DQA\u001b\nA\u00021Ds\u0001AAl\u0003G\f)\u000f\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\ti\u000eL\u0001\u000bgR,'/Z8usB,\u0017\u0002BAq\u00037\u0014\u0011bQ8na>tWM\u001c;\u0002\u000bY\fG.^3\"\u0005\u0005\u001d\u0018\u0001\u0007=m\u0003V$\b.\u001a8uS\u000e\fG/[8o!J|g/\u001b3fe\u0002")
public class ReleaseAuthenticationProvider
implements AuthenticationProvider,
Logging {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final UserLastActiveActorService userLastActiveActorService;
    private final UserGroupService userGroupService;
    private final PrincipalDataProvider principalDataProvider;
    private final PersonalAccessTokenFeature personalAccessTokenFeature;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        Authentication authentication;
        this.logger().debug((Function0 & Serializable)() -> "Authenticating for Digital.ai Release");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : (authentication2 instanceof OwnerAuthenticationToken ? this.authenticateFromReleaseOwner(token.getPrincipal().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        UserToken userToken = (UserToken)this.userTokenService.findByUserToken(tokenHash).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        });
        if (userToken.isExpired()) {
            throw new TokenExpiredException("The token expired on " + DateVariableUtils.printDate((Date)userToken.expiryDate()));
        }
        this.userLastActiveActorService.updateTokenLastUsed(userToken.ciUid());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)new InternalUser(userToken.username()), token, userToken.expiryDate(), mappedAuthorities, (Set)Option$.MODULE$.apply((Object)userToken.userTokenPermission()).map((Function1 & Serializable)x$1 -> x$1.globalPermissions()).getOrElse((Function0 & Serializable)() -> Collections.emptySet()), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)new InternalUser(username), (Object)password, mappedAuthorities);
    }

    private Authentication authenticateFromReleaseOwner(String owner) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating release owner: [" + owner + "]");
        if (Strings.isBlank((String)owner)) {
            throw new BadCredentialsException("Cannot authenticate with empty release owner");
        }
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(owner);
        return new OwnerAuthenticationToken(new InternalUser(owner), mappedAuthorities);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        ArrayList<SimpleGrantedAuthority> arrayList;
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider.getAuthorities(username));
        }
        try {
            User user = this.userService.read(username);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
            arrayList = grantedAuthorities;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && this.personalAccessTokenFeature.enabled()) {
                scala.collection.immutable.Set<String> userGroups = this.userGroupService.findGroupsForUser(username);
                ArrayList grantedAuthorities = new ArrayList();
                userGroups.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority(group))));
                arrayList = grantedAuthorities;
            }
            throw throwable;
        }
        ArrayList<SimpleGrantedAuthority> authorities = arrayList;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class) || authentication.isAssignableFrom(OwnerAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public ReleaseAuthenticationProvider(UserService userService, UserTokenService userTokenService, UserLastActiveActorService userLastActiveActorService, UserGroupService userGroupService, PrincipalDataProvider principalDataProvider, PersonalAccessTokenFeature personalAccessTokenFeature) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.userLastActiveActorService = userLastActiveActorService;
        this.userGroupService = userGroupService;
        this.principalDataProvider = principalDataProvider;
        this.personalAccessTokenFeature = personalAccessTokenFeature;
        Logging.$init$((Logging)this);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

