/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.features.TaskExecutionLogsFeature$;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntryDebounceActor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.LogSizeLimitExceededException;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001B\u000e\u001d\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\n\u0001B\u0001B\u0003%1\nC\u0003P\u0001\u0011\u0005\u0001\u000b\u0003\u0005V\u0001!\u0015\r\u0011\"\u0003W\u0011!\u0011\u0007\u0001#b\u0001\n\u00131\u0006\"B2\u0001\t\u0003!\u0007\"B<\u0001\t\u0003A\b\"\u0002>\u0001\t\u0003Y\bbBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a \u0001\t\u0013\t\t\tC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAe\u0001\u0011\u0005\u00111Z\u0004\b\u0003od\u0002\u0012AA}\r\u0019YB\u0004#\u0001\u0002|\"1qj\u0005C\u0001\u0003{D\u0011\"a@\u0014\u0005\u0004%\tA!\u0001\t\u0011\t%1\u0003)A\u0005\u0005\u0007A\u0011Ba\u0003\u0014\u0005\u0004%\tA!\u0004\t\u0011\te1\u0003)A\u0005\u0005\u001fA\u0011Ba\u0007\u0014\u0005\u0004%IA!\b\t\u0011\t}1\u0003)A\u0005\u0003\u0007\u0012q\u0003V1tW\u0016CXmY;uS>tGj\\4TKJ4\u0018nY3\u000b\u0005uq\u0012\u0001\u00027pONT!a\b\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0011#\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002$I\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tyC'D\u00011\u0015\t\t$'A\u0003tY\u001a$$NC\u00014\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001b1\u0005\u001daunZ4j]\u001e\fqb\u001d9sS:<W\t\u001f;f]NLwN\u001c\t\u0003q}j\u0011!\u000f\u0006\u0003um\naa\u001d9sS:<'B\u0001\u001f>\u0003\u0015\u0001Xm[6p\u0015\tq\u0004%A\u0004tkB\u0004xN\u001d;\n\u0005\u0001K$aD*qe&tw-\u0012=uK:\u001c\u0018n\u001c8\u0002\u001dM$xN]1hKN+'O^5dKB\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\bg\u0016\u0014h/[2f\u0015\t9\u0005%A\u0004ti>\u0014\u0018mZ3\n\u0005%#%AD*u_J\fw-Z*feZL7-Z\u0001\u0018i\u0006\u001c8.\u0012=fGV$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001T'\u000e\u0003qI!A\u0014\u000f\u0003/Q\u000b7o[#yK\u000e,H/[8o%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0003R%N#\u0006C\u0001'\u0001\u0011\u00151D\u00011\u00018\u0011\u0015\tE\u00011\u0001C\u0011\u0015QE\u00011\u0001L\u0003m)\u00070Z2vi&|g\u000eT8h/\u0006$8\r[3s\u0003\u000e$xN\u001d*fMV\tq\u000b\u0005\u0002YA6\t\u0011L\u0003\u0002[7\u0006)\u0011m\u0019;pe*\u0011A\b\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b3\nA\u0011i\u0019;peJ+g-\u0001\u0012uCN\\W\t_3dkRLwN\\#oiJLH)\u001a2pk:\u001cW-Q2u_J\u0014VMZ\u0001\u0006o\u0006$8\r\u001b\u000b\u0004K\",\bCA\u0015g\u0013\t9'F\u0001\u0003V]&$\b\"B5\b\u0001\u0004Q\u0017A\u0002;bg.LE\r\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[*j\u0011A\u001c\u0006\u0003_\u001a\na\u0001\u0010:p_Rt\u0014BA9+\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ET\u0003\"\u0002<\b\u0001\u0004Q\u0017aC3yK\u000e,H/[8o\u0013\u0012\f\u0011b\u001d;pa^\u000bGo\u00195\u0015\u0005\u0015L\b\"\u0002<\t\u0001\u0004Q\u0017!\u00024fi\u000eDG\u0003C3}{z\f\t\"a\u0010\t\u000b%L\u0001\u0019\u00016\t\u000bYL\u0001\u0019\u00016\t\r}L\u0001\u0019AA\u0001\u00031yW\u000f\u001e9viN#(/Z1n!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t!![8\u000b\u0005\u0005-\u0011\u0001\u00026bm\u0006LA!a\u0004\u0002\u0006\taq*\u001e;qkR\u001cFO]3b[\"9\u00111C\u0005A\u0002\u0005U\u0011a\u00027bgRTuN\u0019\t\u0005\u0003/\tID\u0004\u0003\u0002\u001a\u0005Mb\u0002BA\u000e\u0003[qA!!\b\u0002*9!\u0011qDA\u0014\u001d\u0011\t\t#!\n\u000f\u00075\f\u0019#C\u0001&\u0013\t\u0019C%\u0003\u0002\"E%\u0019\u00111\u0006\u0011\u0002\rI,hN\\3s\u0013\u0011\ty#!\r\u0002\r\u0011|W.Y5o\u0015\r\tY\u0003I\u0005\u0005\u0003k\t9$A\u0004qC\u000e\\\u0017mZ3\u000b\t\u0005=\u0012\u0011G\u0005\u0005\u0003w\tiDA\u0003K_\nLEM\u0003\u0003\u00026\u0005]\u0002bBA!\u0013\u0001\u0007\u00111I\u0001\nY\u0006\u001cHo\u00115v].\u00042!KA#\u0013\r\t9E\u000b\u0002\u0005\u0019>tw-\u0001\u0003q_:<GcA3\u0002N!)aO\u0003a\u0001U\u0006\u0011b-\u001a;dQ\u0006cG.\u0012=fGV$\u0018n\u001c8t)\u0011\t\u0019&a\u001b\u0011\r\u0005U\u00131LA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005%\u0011\u0001B;uS2LA!!\u0018\u0002X\t!A*[:u!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3A\u0005)a/[3xg&!\u0011\u0011NA2\u0005Q!\u0016m]6Fq\u0016\u001cW\u000f^5p]2{wMV5fo\")\u0011n\u0003a\u0001U\u0006\u0019An\\4\u0015\u0007\u0015\f\t\bC\u0004\u0002t1\u0001\r!!\u001e\u0002\u00111|w-\u00128uef\u0004B!a\u001e\u0002|5\u0011\u0011\u0011\u0010\u0006\u0004\u0003_1\u0015\u0002BA?\u0003s\u0012\u0001\u0002T8h\u000b:$(/_\u0001\u0010iJLHK];oG\u0006$X\rT8hgR!\u0011QOAB\u0011\u001d\t\u0019(\u0004a\u0001\u0003k\nQcZ3u)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]R\u0014\u0018\u0010\u0006\u0004\u0002\n\u0006U\u0015q\u0013\t\u0006S\u0005-\u0015qR\u0005\u0004\u0003\u001bS#AB(qi&|g\u000eE\u0002M\u0003#K1!a%\u001d\u0005I!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sGO]=\t\u000b%t\u0001\u0019\u00016\t\u000bYt\u0001\u0019\u00016\u0002\u001b=t'j\u001c2GS:L7\u000f[3e)\r)\u0017Q\u0014\u0005\b\u0003?{\u0001\u0019AAQ\u0003\u0015)g/\u001a8u!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAAT=\u00051QM^3oiNLA!a+\u0002&\n\u0001\"j\u001c2GS:L7\u000f[3e\u000bZ,g\u000e\u001e\u0015\u0004\u001f\u0005=\u0006\u0003BAY\u0003kk!!a-\u000b\u0007\u0005\u001d\u0006%\u0003\u0003\u00028\u0006M&!C*vEN\u001c'/\u001b2f\u0003Ayg\u000eV1tW2{wm\u0011:fCR,G\rF\u0002f\u0003{Cq!a0\u0011\u0001\u0004\t\t-\u0001\u0007uCN\\Gj\\4Fm\u0016tG\u000fE\u0002M\u0003\u0007L1!!2\u001d\u00059!\u0016m]6M_\u001e\u001c%/Z1uK\u0012D3\u0001EAX\u0003Myg\u000eV1tW\u0016CXmY;uS>tGi\u001c8f)\r)\u0017Q\u001a\u0005\b\u0003?\u000b\u0002\u0019AAh!\u0011\t\t.a6\u000e\u0005\u0005M'\u0002BAT\u0003+T1!a\f!\u0013\u0011\tI.a5\u0003)Q\u000b7o\u001b&pE\u0016CXmY;uK\u0012,e/\u001a8uQ\r\t\u0012q\u0016\u0015\u0004\u0001\u0005}\u0007\u0003BAq\u0003Wl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\u000bgR,'/Z8usB,'bAAu=\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002n\u0006\r(aB*feZL7-\u001a\u0015\u0004\u0001\u0005E\b\u0003BAY\u0003gLA!!>\u00024\niQI^3oi2K7\u000f^3oKJ\fq\u0003V1tW\u0016CXmY;uS>tGj\\4TKJ4\u0018nY3\u0011\u00051\u001b2CA\n))\t\tI0A\rE\u000b\u001a\u000bU\u000b\u0014+`\u0007\"+fjS0C+\u001a3UIU0T\u0013j+UC\u0001B\u0002!\rI#QA\u0005\u0004\u0005\u000fQ#aA%oi\u0006QB)\u0012$B+2#vl\u0011%V\u001d.{&)\u0016$G\u000bJ{6+\u0013.FA\u0005!BjT$`)J+fjQ!U\u000b~kUiU*B\u000f\u0016+\"Aa\u0004\u0011\t\tE!qC\u0007\u0003\u0005'QAA!\u0006\u0002\n\u0005!A.\u00198h\u0013\r\u0019(1C\u0001\u0016\u0019>;u\f\u0016*V\u001d\u000e\u000bE+R0N\u000bN\u001b\u0016iR#!\u0003eaujR0U%Vs5)\u0011+F?6+5kU!H\u000b~\u001b\u0016JW#\u0016\u0005\u0005\r\u0013A\u0007'P\u000f~#&+\u0016(D\u0003R+u,T#T'\u0006;UiX*J5\u0016\u0003\u0003")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private ActorRef taskExecutionEntryDebounceActorRef;
    private final SpringExtension springExtension;
    private final StorageService storageService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static String LOG_TRUNCATE_MESSAGE() {
        return TaskExecutionLogService$.MODULE$.LOG_TRUNCATE_MESSAGE();
    }

    public static int DEFAULT_CHUNK_BUFFER_SIZE() {
        return TaskExecutionLogService$.MODULE$.DEFAULT_CHUNK_BUFFER_SIZE();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef taskExecutionEntryDebounceActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.taskExecutionEntryDebounceActorRef = this.springExtension.actorOf(TaskExecutionEntryDebounceActor.class, "task-execution-entry-debounce-actor", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.taskExecutionEntryDebounceActorRef;
    }

    private ActorRef taskExecutionEntryDebounceActorRef() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.taskExecutionEntryDebounceActorRef$lzycompute();
        }
        return this.taskExecutionEntryDebounceActorRef;
    }

    public void watch(String taskId, String executionId) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, User.AUTHENTICATED_USER.getName());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void stopWatch(String executionId) {
        ExecutionLogWatchActor.StopWatching x$1 = new ExecutionLogWatchActor.StopWatching(executionId, (Option<String>)new Some((Object)User.AUTHENTICATED_USER.getName()));
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public void pong(String executionId) {
        ExecutionLogWatchActor.Pong x$1 = new ExecutionLogWatchActor.Pong(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public java.util.List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                row.endDate().foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        Option x$1 = Option$.MODULE$.apply((Object)this.storageService.defaultStorageType());
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1);
        workerLogEntry = TaskExecutionLogsFeature$.MODULE$.isLogTruncationEnabled() ? this.tryTruncateLogs(workerLogEntry) : workerLogEntry;
        URI uri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskExecutionEntryDebounceActor.DebounceTaskExecutionEntry x$8 = new TaskExecutionEntryDebounceActor.DebounceTaskExecutionEntry(new TaskExecutionEntryDebounceActor.TaskExecutionKey(logEntry.taskId(), logEntry.executionId()), TaskExecutionEntry$.MODULE$.from(workerLogEntry, TaskExecutionEntry$.MODULE$.from$default$2()), (List<URI>)new .colon.colon((Object)uri, (List)Nil$.MODULE$));
        ActorRef x$9 = this.taskExecutionEntryDebounceActorRef().$bang$default$2((Object)x$8);
        this.taskExecutionEntryDebounceActorRef().$bang((Object)x$8, x$9);
    }

    private LogEntry tryTruncateLogs(LogEntry logEntry) {
        long maxSize = TaskExecutionLogsFeature$.MODULE$.getMaxSizeInBytes();
        return (LogEntry)this.taskExecutionRepository.read(logEntry.taskId(), logEntry.executionId()).map((Function1 & Serializable)taskExecutionEntry -> {
            Tuple2 tuple2;
            if (taskExecutionEntry.truncated()) {
                throw new LogSizeLimitExceededException("Log size limit exceeded for task " + logEntry.taskId() + " and execution " + logEntry.executionId());
            }
            long currentSize = taskExecutionEntry.logSize();
            if (currentSize > maxSize) {
                byte[] payload = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(logEntry.payload()), (Object)TaskExecutionLogService$.MODULE$.LOG_TRUNCATE_MESSAGE().getBytes(StandardCharsets.UTF_8), (ClassTag)ClassTag$.MODULE$.Byte());
                v0 = new Tuple2((Object)payload, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else if (currentSize + (long)logEntry.payload().length > maxSize) {
                long bytesLeft = maxSize - currentSize - TaskExecutionLogService$.MODULE$.com$xebialabs$xlrelease$scheduler$logs$TaskExecutionLogService$$LOG_TRUNCATE_MESSAGE_SIZE();
                byte[] payload = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(logEntry.payload()), (int)bytesLeft)), (Object)TaskExecutionLogService$.MODULE$.LOG_TRUNCATE_MESSAGE().getBytes(StandardCharsets.UTF_8), (ClassTag)ClassTag$.MODULE$.Byte());
                v0 = new Tuple2((Object)payload, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                v0 = tuple2 = new Tuple2((Object)logEntry.payload(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] payload = (byte[])tuple2._1();
            boolean truncate = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)payload, (Object)BoxesRunTime.boxToBoolean((boolean)truncate));
            byte[] payload2 = (byte[])tuple22._1();
            boolean truncate2 = tuple22._2$mcZ$sp();
            if (truncate2) {
                $this.taskExecutionRepository.markAsTruncated(logEntry.taskId(), logEntry.executionId());
            }
            byte[] x$1 = payload2;
            String x$2 = logEntry.copy$default$1();
            String x$3 = logEntry.copy$default$2();
            long x$4 = logEntry.copy$default$3();
            long x$5 = logEntry.copy$default$4();
            String x$6 = logEntry.copy$default$5();
            Option x$7 = logEntry.copy$default$7();
            return logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
        }).getOrElse((Function0 & Serializable)() -> logEntry);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uris());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        this.taskExecutionRepository.finishExecution(event.taskId(), event.executionId(), Instant.now());
    }

    public TaskExecutionLogService(SpringExtension springExtension, StorageService storageService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.storageService = storageService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

