package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.variables._
import com.xebialabs.xlrelease.features.settings.ReferenceVariablesFeatureSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import org.springframework.stereotype.Component

import java.util.Optional
import scala.jdk.CollectionConverters._

@Component
class CustomConfigurationValueProvider(val configurationRepository: ConfigurationRepository) extends ConfigurationValueProvider[BaseConfiguration] {

  override def getSupportedTypes(): Seq[ReferencedType] = {
    val settingsOptional: Optional[ReferenceVariablesFeatureSettings] =
      configurationRepository.findFirstByType(Type.valueOf(classOf[ReferenceVariablesFeatureSettings]))
    if (settingsOptional.isEmpty) {
      Seq.empty
    } else {
      val settings = settingsOptional.get()
      settings.typeList.asScala.map(t => {
        new ReferencedType(t, Type.valueOf(t).getDescriptor.getLabel)
      }).toSeq
    }
  }

}
