package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Release load options",
  description = "Flag related to release read operations.")
class ReleaseLoadingFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable batch load for Gate task Dependencies (performance tuning)", category = "input", defaultValue = "true")
  var batchLoadDependencies: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "release", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "50", hidden = true)
  var weight: Integer = _
}
