/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.ExecutionOutputWriter;
import com.xebialabs.deployit.plumbing.PollingExecutionOutputHandler;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.platform.script.jython.JythonSupport$;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.AwaitFacetCheckResult;
import com.xebialabs.xlrelease.script.CustomScriptTaskResult;
import com.xebialabs.xlrelease.script.ExceptionPreconditionResult;
import com.xebialabs.xlrelease.script.FacetCheckResult;
import com.xebialabs.xlrelease.script.FailureCustomScriptTaskResult;
import com.xebialabs.xlrelease.script.FailureFacetCheckResult;
import com.xebialabs.xlrelease.script.FailureFailureHandlerResult;
import com.xebialabs.xlrelease.script.FailureHandlerResult;
import com.xebialabs.xlrelease.script.FailureScriptTaskResult;
import com.xebialabs.xlrelease.script.GenericTaskScriptLogic;
import com.xebialabs.xlrelease.script.InvalidPreconditionResult;
import com.xebialabs.xlrelease.script.OutputHandler;
import com.xebialabs.xlrelease.script.PreconditionResult;
import com.xebialabs.xlrelease.script.RestartCustomScriptTaskResult;
import com.xebialabs.xlrelease.script.RestartScriptTaskResult;
import com.xebialabs.xlrelease.script.RingWriter;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.ScriptServiceHelper;
import com.xebialabs.xlrelease.script.ScriptTaskResult;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.script.SuccessFacetCheckResult;
import com.xebialabs.xlrelease.script.SuccessFailureHandlerResult;
import com.xebialabs.xlrelease.script.SuccessScriptTaskResult;
import com.xebialabs.xlrelease.script.TruncatingCommentUpdater;
import com.xebialabs.xlrelease.script.ValidPreconditionResult;
import com.xebialabs.xlrelease.script.VariablesHolderForScriptContext;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.XlrScriptVariables;
import com.xebialabs.xlrelease.script.builder.ScriptContextBuilder;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import scala.Option;
import scala.Product;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public abstract class DefaultScriptService
implements ScriptService,
GenericTaskScriptLogic {
    public static final String MDC_KEY_TASK = "task";
    public static final String RESULT_ATTRIBUTE = "result";
    public static final String MATCHED_EVENT_MSG = "Task completed by matching event";
    public static final String TYPE_CUSTOM_SCRIPT_TASK = "xlrelease.CustomScriptTaskSettings";
    public static final String PRESERVE_OUTPUT_ON_ERROR = "preserveOutputVariables";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScriptVariables scriptVariables;
    protected ScriptLifeCycle scriptLifeCycle;
    protected ScriptExecutor scriptExecutor;
    protected final ThreadLocalWriterDecorator executionLog = JythonSupport$.MODULE$.outWriterDecorator();
    protected AuthenticationService authenticationService;
    private ReleaseService releaseService;
    protected PermissionChecker permissions;
    protected CommentService commentService;
    protected XlrConfig xlrConfig;
    private AttachmentService attachmentService;
    private ConfigurationVariableService configurationVariableService;
    private ConfigurationService configurationService;

    protected DefaultScriptService(ScriptLifeCycle scriptLifeCycle, ScriptExecutor scriptExecutor, AuthenticationService authenticationService, ReleaseService releaseService, ScriptVariables scriptVariables, PermissionChecker permissions, CommentService commentService, XlrConfig xlrConfig, AttachmentService attachmentService, ConfigurationVariableService configurationVariableService, ConfigurationService configurationService) {
        this.scriptLifeCycle = scriptLifeCycle;
        this.scriptExecutor = scriptExecutor;
        this.authenticationService = authenticationService;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.commentService = commentService;
        this.xlrConfig = xlrConfig;
        this.scriptVariables = scriptVariables;
        this.attachmentService = attachmentService;
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
    }

    @Override
    public Object executeScript(XlrScriptContext scriptContext) throws Exception {
        return this.scriptExecutor.evalScript(scriptContext);
    }

    protected Object executeScriptWithLifecycle(XlrScriptContext scriptContext) throws Exception {
        try {
            this.scriptLifeCycle.start(scriptContext.getExecutionId());
            Object object = this.executeScript(scriptContext);
            return object;
        }
        finally {
            this.scriptLifeCycle.end(scriptContext.getExecutionId());
        }
    }

    protected void registerScriptExecution(String ciId, String executionId) {
        if (executionId == null) {
            String msg = String.format("executionId was not provided for %s", ciId);
            throw new IllegalStateException(msg);
        }
        this.scriptLifeCycle.register(executionId);
    }

    private SensitiveValueScrubber makeScrubber(Release release, Task task) {
        SensitiveValueScrubber scrubber;
        if (release == null || !release.isAllowPasswordsInAllFields()) {
            scrubber = SensitiveValueScrubber.disabled();
        } else {
            Map passwordVariables = release.getPasswordVariableValues();
            passwordVariables.forEach((key, value) -> {
                String decryptedValue = PasswordEncrypter.getInstance().ensureDecrypted(value);
                passwordVariables.put(key, decryptedValue);
            });
            Map<String, ValueWithInterpolation> passwordVariablesWithInterpolationInfo = passwordVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ValueWithInterpolation((String)entry.getValue(), true)));
            Changes changes = new Changes();
            if (task instanceof BaseScriptTask) {
                task.freezeVariablesInCustomFields(passwordVariablesWithInterpolationInfo, passwordVariables, changes, true);
            }
            scrubber = new SensitiveValueScrubber(changes.getVariablesUsed(), passwordVariables);
        }
        return scrubber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ResolvableScriptTask> ScriptTaskResult executeScriptTask(T task) {
        Release release = task.getRelease();
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        String folderId = release.findFolderId();
        VariablesHolderForScriptContext variablesHolderForScriptContext = this.scriptVariables.createVariablesHolderForScriptContext(release, folderId, this.variablesSynchronizationCallback((Task)task));
        try {
            SensitiveValueScrubber scrubber = this.makeScrubber(release, (Task)task);
            this.registerScriptExecution(taskId, executionId);
            this.registerWriterForTask((Task)task, scrubber);
            this.authenticationService.loginScriptUser((Task)task, variablesHolderForScriptContext);
            XlrScriptContext scriptContext = ScriptContextBuilder.scriptTaskContext(this.xlrConfig, (Writer)this.executionLog, task, this.scriptVariables.asXlrScriptVariables(variablesHolderForScriptContext), this.xlrConfig.isScriptSandboxDecryptPasswords());
            variablesHolderForScriptContext.setScriptContext(scriptContext);
            this.executeScriptWithLifecycle(scriptContext);
            ScriptTaskResults scriptTaskResults2 = variablesHolderForScriptContext.createScriptTaskResults();
            SuccessScriptTaskResult successScriptTaskResult = new SuccessScriptTaskResult(taskId, executionId, this.executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)this.executionLog), scriptTaskResults2, this.getCurrentAuthentication());
            return successScriptTaskResult;
        }
        catch (ScriptException exception) {
            ScriptTaskResults scriptTaskResults = variablesHolderForScriptContext.createScriptTaskResults();
            try {
                if (ScriptServiceHelper.isSystemExit0(exception)) {
                    SuccessScriptTaskResult scriptTaskResults2 = new SuccessScriptTaskResult(taskId, executionId, this.executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)this.executionLog), scriptTaskResults, this.getCurrentAuthentication());
                    return scriptTaskResults2;
                }
                if (this.isRestartPhasesException(exception)) {
                    ScriptTaskResult scriptTaskResults2 = this.onRestartPhasesException((RestartPhasesException)((Object)ExceptionUtils.getRootCause((Throwable)exception)), this.executionLog, (BaseScriptTask)task, scriptTaskResults);
                    return scriptTaskResults2;
                }
                FailureScriptTaskResult scriptTaskResults2 = this.onScriptTaskException(exception.getMessage(), exception, executionId, this.executionLog, scriptTaskResults, taskId);
                return scriptTaskResults2;
            }
            catch (Exception resultsException) {
                FailureScriptTaskResult failureScriptTaskResult = this.onScriptTaskException("Exception saving script results of script task '{}':", resultsException, executionId, this.executionLog, scriptTaskResults, taskId);
                return failureScriptTaskResult;
            }
        }
        catch (Exception exception) {
            FailureScriptTaskResult failureScriptTaskResult = this.onScriptTaskException("Unexpected exception during execution of script task '{}':", exception, executionId, this.executionLog, null, taskId);
            return failureScriptTaskResult;
        }
        finally {
            this.closeWriter();
            this.finishScript(executionId);
            this.authenticationService.logoutScriptUser();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T extends CustomScriptTask> CustomScriptTaskResult executeCustomScriptTask(T task) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CustomScriptTaskResults createCustomScriptTaskResults(CustomScriptTask task, SensitiveValueScrubber scrubber, XlrScriptContext scriptContext) {
        return new CustomScriptTaskResults(ScriptServiceHelper.extractTransitionalAndOutputPropertyValues(task, (ScriptContext)scriptContext, scrubber), task.getExecutionId(), task.getStatusLine(), task.getNextScriptPath(), task.getInterval());
    }

    protected void finishScript(String executionId) {
        this.scriptLifeCycle.unregister(executionId);
        this.removeWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreconditionResult executePrecondition(Task task) {
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        try {
            this.registerScriptExecution(taskId, executionId);
            this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
            this.authenticationService.loginScriptUser(task);
            Release release = task.getRelease();
            String folderId = release.findFolderId();
            VariablesHolderForScriptContext variablesHolderForScriptContext = this.scriptVariables.createVariablesHolderForScriptContext(release, folderId);
            XlrScriptVariables xlrScriptVariables = this.scriptVariables.asXlrScriptVariables(variablesHolderForScriptContext);
            XlrScriptContext scriptContext = ScriptContextBuilder.preconditionScriptContext(this.xlrConfig, (Writer)this.executionLog, task, xlrScriptVariables, this.xlrConfig.isScriptSandboxDecryptPasswords());
            Object statementResult = this.executeScriptWithLifecycle(scriptContext);
            Object resultVariable = scriptContext.getAttribute(RESULT_ATTRIBUTE);
            if (statementResult == null && resultVariable == null) {
                this.executionLog.append((CharSequence)"Precondition did not return anything\n");
                ExceptionPreconditionResult exceptionPreconditionResult = new ExceptionPreconditionResult(taskId, executionId, this.executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)this.executionLog), this.getCurrentAuthentication());
                return exceptionPreconditionResult;
            }
            if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                this.executionLog.append((CharSequence)"Precondition is valid (returned True)\n");
                ValidPreconditionResult validPreconditionResult = new ValidPreconditionResult(taskId, executionId, this.executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)this.executionLog), this.getCurrentAuthentication());
                return validPreconditionResult;
            }
            this.executionLog.append((CharSequence)"Precondition is invalid (returned a value that is not True)\n");
            InvalidPreconditionResult invalidPreconditionResult = new InvalidPreconditionResult(taskId, executionId, this.executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)this.executionLog), this.getCurrentAuthentication());
            return invalidPreconditionResult;
        }
        catch (Exception exception) {
            ScriptServiceHelper.addExceptionToExecutionLog(exception, (Writer)this.executionLog, "Unexpected exception during precondition check of script task '{}':", taskId);
            ExceptionPreconditionResult exceptionPreconditionResult = new ExceptionPreconditionResult(taskId, executionId, this.executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)this.executionLog), this.getCurrentAuthentication());
            return exceptionPreconditionResult;
        }
        finally {
            this.closeWriter();
            this.authenticationService.logoutScriptUser();
            this.finishScript(executionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacetCheckResult executeFacetCheck(Task task) {
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        try {
            Object object;
            this.registerScriptExecution(taskId, executionId);
            this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
            List facetsWithScript = task.getFacets().stream().filter(f -> f.hasProperty("scriptLocation")).collect(Collectors.toList());
            boolean executeSuccessful = false;
            Date nextDate = null;
            boolean needLifecycleReset = false;
            for (Facet facetWithScript : facetsWithScript) {
                this.authenticationService.loginScriptUser(task);
                if (needLifecycleReset) {
                    this.scriptLifeCycle.reset(executionId);
                }
                Release release = task.getRelease();
                String folderId = release.findFolderId();
                VariablesHolderForScriptContext variablesHolderForScriptContext = this.scriptVariables.createVariablesHolderForScriptContext(release, folderId);
                XlrScriptVariables xlrScriptVariables = this.scriptVariables.asXlrScriptVariables(variablesHolderForScriptContext);
                XlrScriptContext scriptContext = ScriptContextBuilder.facetCheckScriptContext((Writer)this.executionLog, task, facetWithScript, xlrScriptVariables, this.xlrConfig.isScriptSandboxDecryptPasswords());
                Object statementResult = this.executeScriptWithLifecycle(scriptContext);
                Object resultVariable = scriptContext.getAttribute(RESULT_ATTRIBUTE);
                if (statementResult == null && resultVariable == null) {
                    this.executionLog.append((CharSequence)"Environment is not available: script did not return anything\n");
                    executeSuccessful = false;
                    break;
                }
                if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                    executeSuccessful = true;
                } else if (this.isDate(statementResult) || this.isDate(resultVariable)) {
                    executeSuccessful = true;
                    nextDate = this.pickNearestDate(nextDate, statementResult, resultVariable);
                } else {
                    this.executionLog.append((CharSequence)"Environment is not available: script returned a value that is not True\n");
                    executeSuccessful = false;
                    break;
                }
                needLifecycleReset = true;
            }
            if (executeSuccessful) {
                if (nextDate == null || nextDate.before(new Date())) {
                    this.executionLog.append((CharSequence)"Environment is available: script is valid (returned True or date that is in the past)\n");
                    object = new SuccessFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
                    return object;
                }
                this.executionLog.append((CharSequence)String.format("Environment(s) are going to be available at %s%n", nextDate.toString()));
                object = new AwaitFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), nextDate, this.getCurrentAuthentication());
                return object;
            }
            object = new FailureFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
            return object;
        }
        catch (Exception exception) {
            ScriptServiceHelper.addExceptionToExecutionLog(exception, (Writer)this.executionLog, "Unexpected exception during attribute check of task '{}':", taskId);
            FailureFacetCheckResult failureFacetCheckResult = new FailureFacetCheckResult(taskId, executionId, this.executionLog.toString(), (Option<String>)Option.empty(), this.getCurrentAuthentication());
            return failureFacetCheckResult;
        }
        finally {
            this.closeWriter();
            this.authenticationService.logoutScriptUser();
            this.finishScript(executionId);
        }
    }

    @Override
    public Collection<Object> executeScriptValueProvider(ScriptValueProviderConfiguration valueProviderConfiguration) {
        Variable variable = valueProviderConfiguration.getVariable();
        String releaseId = Ids.releaseIdFrom((String)variable.getId());
        Release release = this.releaseService.findById(releaseId);
        CompletableFuture future = new CompletableFuture();
        this.xlrConfig.auxiliaryExecutor().submit(() -> {
            this.authenticationService.loginScriptUser(release);
            this.configurationVariableService.resolveFromCi(valueProviderConfiguration, release.getGlobalVariables(), svpc -> CollectionConverters.asScala((Collection)svpc.getType().getDescriptor().getPropertyDescriptors()));
            try {
                String folderId = release.findFolderId();
                VariablesHolderForScriptContext variablesHolderForScriptContext = this.scriptVariables.createVariablesHolderForScriptContext(release, folderId);
                XlrScriptVariables xlrScriptVariables = this.scriptVariables.asXlrScriptVariables(variablesHolderForScriptContext);
                XlrScriptContext scriptContext = ScriptContextBuilder.valueProviderScriptContext(release, valueProviderConfiguration, xlrScriptVariables);
                OutputHandler logHandler = OutputHandler.info(this.logger);
                ExecutionOutputWriter executionWriter = new ExecutionOutputWriter(SensitiveValueScrubber.disabled(), new StringWriter(), logHandler);
                this.executionLog.registerWriter((Writer)executionWriter);
                scriptContext.setWriter((Writer)this.executionLog);
                this.executeScript(scriptContext);
                Collection res = scriptContext.getValueProviderResult();
                future.complete(res);
            }
            catch (Exception e) {
                this.logger.error("unknown exception: ", (Throwable)e);
                future.complete(null);
            }
            finally {
                this.authenticationService.logoutScriptUser();
                this.closeWriter();
            }
        });
        long releaseActionTimeoutSeconds = this.xlrConfig.timeoutSettings().releaseActionResponse().toSeconds();
        try {
            return (Collection)future.get(releaseActionTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(true);
            String message = String.format("Execution of value provider for variable [%s] with release id [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.releaseActionResponse' property", variable.getKey(), release.getId(), releaseActionTimeoutSeconds);
            this.logger.warn(message);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailureHandlerResult executeFailureHandler(Task task) {
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        VariablesHolderForScriptContext variablesHolderForScriptContext = this.scriptVariables.createVariablesHolderForScriptContext(task.getRelease(), task.getRelease().findFolderId(), this.variablesSynchronizationCallback(task));
        try {
            this.registerScriptExecution(taskId, executionId);
            this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
            this.authenticationService.loginScriptUser(task, variablesHolderForScriptContext);
            XlrScriptVariables xlrScriptVariables = this.scriptVariables.asXlrScriptVariables(variablesHolderForScriptContext);
            XlrScriptContext scriptContext = ScriptContextBuilder.failureHandlerScriptContext(this.xlrConfig, (Writer)this.executionLog, task, xlrScriptVariables, this.xlrConfig.isScriptSandboxDecryptPasswords());
            variablesHolderForScriptContext.setScriptContext(scriptContext);
            String failureHandlerScript = task.getFailureHandler();
            if (this.isFailureHandlerScriptRunnable(task, failureHandlerScript)) {
                this.executeScriptWithLifecycle(scriptContext);
            }
            if (task.isFailureHandlerEnabled()) {
                SuccessFailureHandlerResult successFailureHandlerResult = new SuccessFailureHandlerResult(taskId, variablesHolderForScriptContext.createScriptTaskResults());
                return successFailureHandlerResult;
            }
            try {
                throw new IllegalStateException(String.format("task failure for task [%s] is not enabled", taskId));
            }
            catch (ScriptException exception) {
                Product product;
                this.logger.warn("ScriptException: ", (Throwable)exception);
                try {
                    ScriptTaskResults scriptTasksResults = variablesHolderForScriptContext.createScriptTaskResults();
                    if (ScriptServiceHelper.isSystemExit0(exception)) {
                        product = new SuccessFailureHandlerResult(taskId, scriptTasksResults);
                        return product;
                    }
                    product = new FailureFailureHandlerResult(taskId, scriptTasksResults, exception);
                    return product;
                }
                catch (Exception resultsException) {
                    product = new FailureFailureHandlerResult(taskId, null, exception);
                    return product;
                }
            }
            catch (Exception exception) {
                this.logger.warn("unknown exception: ", (Throwable)exception);
                FailureFailureHandlerResult failureFailureHandlerResult = new FailureFailureHandlerResult(taskId, variablesHolderForScriptContext.createScriptTaskResults(), exception);
                return failureFailureHandlerResult;
            }
        }
        finally {
            this.closeWriter();
            this.authenticationService.logoutScriptUser();
            this.finishScript(executionId);
        }
    }

    private boolean isFailureHandlerScriptRunnable(Task task, String script) {
        return Strings.isNotBlank((String)script) && task.isTaskFailureHandlerEnabled() && task.isFailureHandlerEnabled() && TaskRecoverOp.RUN_SCRIPT == task.getTaskRecoverOp();
    }

    protected ExecutionOutputWriter registerWriterForTask(Task task, SensitiveValueScrubber scrubber) {
        String taskId = task.getId();
        MDC.put((String)MDC_KEY_TASK, (String)taskId);
        int maxCommentSize = task.getMaxCommentSize();
        TruncatingCommentUpdater commentUpdater = new TruncatingCommentUpdater(this.commentService, task, maxCommentSize);
        long pollingInterval = this.xlrConfig.durations_scriptOutputPollingInterval().toMillis();
        PollingExecutionOutputHandler pollingHandler = PollingExecutionOutputHandler.pollingHandler(this.xlrConfig.pollingExecutor(), commentUpdater, true, pollingInterval, pollingInterval);
        ScriptTaskOutputWriter scriptOutputWriter = new ScriptTaskOutputWriter(this.attachmentService, task, this.commentService, this.logger);
        ExecutionOutputWriter executionOutputWriter = new ExecutionOutputWriter(scrubber, scriptOutputWriter, OutputHandler.debug(this.logger), pollingHandler);
        this.executionLog.registerWriter((Writer)executionOutputWriter);
        return executionOutputWriter;
    }

    protected void closeWriter() {
        ScriptServiceHelper.closeWriter((Writer)this.executionLog);
    }

    private void removeWriter() {
        this.closeWriter();
        this.executionLog.removeWriter();
        MDC.remove((String)MDC_KEY_TASK);
    }

    private boolean isRestartPhasesException(ScriptException exception) {
        return ExceptionUtils.getRootCause((Throwable)exception) instanceof RestartPhasesException;
    }

    private ScriptTaskResult onRestartPhasesException(RestartPhasesException ex, ThreadLocalWriterDecorator executionLog, BaseScriptTask task, ScriptTaskResults scriptTaskResults) {
        List<String> runningAutomatedTaskIds = this.getRunningAutomatedTasks(ex);
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        if (!runningAutomatedTaskIds.contains(taskId)) {
            return this.onScriptTaskException("You can not restart phases in another release when an automated task is running", (Exception)((Object)ex), executionId, executionLog, scriptTaskResults, taskId);
        }
        if (runningAutomatedTaskIds.size() > 1) {
            return this.onScriptTaskException("You can not restart phases when there are other automated task running", (Exception)((Object)ex), executionId, executionLog, scriptTaskResults, taskId);
        }
        return new RestartScriptTaskResult(taskId, executionId, "", (Option<String>)Option.empty(), scriptTaskResults, ex, this.getCurrentAuthentication());
    }

    private FailureScriptTaskResult onScriptTaskException(String message, Exception ex, String executionId, ThreadLocalWriterDecorator executionLog, ScriptTaskResults scriptTaskResults, String taskId) {
        ScriptServiceHelper.addExceptionToExecutionLog(ex, (Writer)executionLog, message, taskId);
        return new FailureScriptTaskResult(taskId, executionId, executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)executionLog), scriptTaskResults, this.getCurrentAuthentication());
    }

    private CustomScriptTaskResult onRestartPhasesExceptionCustomScript(RestartPhasesException ex, ThreadLocalWriterDecorator executionLog, BaseScriptTask task, CustomScriptTaskResults results) {
        List<String> runningAutomatedTaskIds = this.getRunningAutomatedTasks(ex);
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        if (!runningAutomatedTaskIds.contains(taskId)) {
            return this.onCustomScriptException("You can not restart phases in another release when an automated task is running", (Exception)((Object)ex), executionId, executionLog, taskId, results);
        }
        if (runningAutomatedTaskIds.size() > 1) {
            return this.onCustomScriptException("You can not restart phases when there are other automated task running", (Exception)((Object)ex), executionId, executionLog, taskId, results);
        }
        return new RestartCustomScriptTaskResult(taskId, executionId, "", (Option<String>)Option.empty(), ex, this.getCurrentAuthentication(), (Option<CustomScriptTaskResults>)OptionConverters.toScala(this.getCustomScriptTaskResultsOnFailure(results)));
    }

    private List<String> getRunningAutomatedTasks(RestartPhasesException ex) {
        Release release = this.releaseService.findById(ex.getReleaseId());
        return release.getActiveTasks().stream().filter(Task::isAutomated).map(BaseConfigurationItem::getId).collect(Collectors.toList());
    }

    private FailureCustomScriptTaskResult onCustomScriptException(String message, Exception ex, String executionId, ThreadLocalWriterDecorator executionLog, String taskId, CustomScriptTaskResults results) {
        ScriptServiceHelper.addExceptionToExecutionLog(ex, (Writer)executionLog, message, taskId);
        return new FailureCustomScriptTaskResult(taskId, executionId, executionLog.toString(), ScriptServiceHelper.getAttachmentIdFromExecutionLog((Writer)executionLog), this.getCurrentAuthentication(), (Option<CustomScriptTaskResults>)OptionConverters.toScala(this.getCustomScriptTaskResultsOnFailure(results)));
    }

    private Function<VariablesUpdateHolder, ScriptTaskResults> variablesSynchronizationCallback(Task task) {
        return v -> {
            this.logger.debug("Synchronizing variables from script execution of task '{}'", (Object)task.getTitle());
            return new ScriptTaskResults(this.scriptVariables.detectReleaseVariablesChanges(task, (VariablesUpdateHolder)v), this.scriptVariables.detectGlobalVariablesChanges(task, (VariablesUpdateHolder)v), this.scriptVariables.detectFolderVariablesChanges(task, (VariablesUpdateHolder)v));
        };
    }

    private Authentication getCurrentAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isTrue(Object result) {
        return result instanceof Boolean && (Boolean)result != false;
    }

    private boolean isDate(Object result) {
        return result instanceof Date;
    }

    private Date pickNearestDate(Object ... dates) {
        Date result = null;
        for (int i = 0; i < dates.length; ++i) {
            if (dates[i] == null || !(dates[i] instanceof Date) || result != null && !result.before((Date)dates[i])) continue;
            result = (Date)dates[i];
        }
        return result;
    }

    private Optional<CustomScriptTaskResults> getCustomScriptTaskResultsOnFailure(CustomScriptTaskResults results) {
        if (this.preserveCustomScriptTaskResultsOnFailure().booleanValue()) {
            return Optional.ofNullable(results);
        }
        return Optional.empty();
    }

    private Boolean preserveCustomScriptTaskResultsOnFailure() {
        return (Boolean)this.configurationService.getFeatureSettings(TYPE_CUSTOM_SCRIPT_TASK).getProperty(PRESERVE_OUTPUT_ON_ERROR);
    }

    private static /* synthetic */ Iterable lambda$executeCustomScriptTask$2(PythonScript ci) {
        return CollectionConverters.asScala((Collection)ci.getInputProperties());
    }

    public static class ScriptTaskResults
    implements BaseScriptTaskResults {
        private Changes.VariablesChanges releaseVariablesChanges;
        private Changes.VariablesChanges globalVariablesChanges;
        private Changes.VariablesChanges folderVariablesChanges;

        public ScriptTaskResults(Changes.VariablesChanges releaseVariablesChanges, Changes.VariablesChanges globalVariablesChanges, Changes.VariablesChanges folderVariablesChanges) {
            this.releaseVariablesChanges = releaseVariablesChanges;
            this.globalVariablesChanges = globalVariablesChanges;
            this.folderVariablesChanges = folderVariablesChanges;
        }

        public Changes.VariablesChanges getReleaseVariablesChanges() {
            return this.releaseVariablesChanges;
        }

        public Changes.VariablesChanges getGlobalVariablesChanges() {
            return this.globalVariablesChanges;
        }

        public Changes.VariablesChanges getFolderVariablesChanges() {
            return this.folderVariablesChanges;
        }
    }

    public static class CustomScriptTaskResults
    implements BaseScriptTaskResults {
        private HashMap<String, Object> outputVariables = new HashMap();
        private String scriptExecutionId;
        private String statusLine;
        private String nextScriptPath;
        private Integer interval;

        public CustomScriptTaskResults(Map<String, Object> outputVariables, String scriptExecutionId, String statusLine, String nextScriptPath, Integer interval) {
            if (null != outputVariables) {
                this.outputVariables.putAll(outputVariables);
            }
            this.scriptExecutionId = scriptExecutionId;
            this.statusLine = statusLine;
            this.nextScriptPath = nextScriptPath;
            this.interval = interval;
        }

        public Map<String, Object> getOutputVariables() {
            return this.outputVariables;
        }

        public String getScriptExecutionId() {
            return this.scriptExecutionId;
        }

        public String getStatusLine() {
            return this.statusLine;
        }

        public String getNextScriptPath() {
            return this.nextScriptPath;
        }

        public Integer getInterval() {
            return this.interval;
        }
    }

    public static class ScriptTaskOutputWriter
    extends Writer {
        boolean closed = false;
        private final AttachmentService attachmentService;
        private final DeferredFileOutputStream dfos;
        private final OutputStreamWriter writer;
        private final RingWriter ringWriter;
        private final Task task;
        private final WorkDir workDir;
        private String attachmentId;
        private final CommentService commentService;
        private final Logger logger;
        private WorkDir previousWorkdir;

        public ScriptTaskOutputWriter(AttachmentService attachmentService, Task task, CommentService commentService, Logger logger) {
            this.attachmentService = attachmentService;
            int maxCommentSize = task.getMaxCommentSize();
            this.task = task;
            this.ringWriter = new RingWriter(maxCommentSize);
            this.previousWorkdir = WorkDirContext.get();
            WorkDirContext.initWorkdir();
            this.workDir = WorkDirContext.get();
            File workDirFile = new File(this.workDir.getPath());
            this.dfos = new DeferredFileOutputStream(maxCommentSize, task.getName(), ".log", workDirFile);
            this.writer = new OutputStreamWriter((OutputStream)this.dfos, StandardCharsets.UTF_8);
            this.commentService = commentService;
            this.logger = logger;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.write(cbuf, off, len);
            this.ringWriter.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            if (!this.closed) {
                this.saveArtifact();
            }
            this.workDir.delete();
            WorkDirContext.clear();
            if (null != this.previousWorkdir) {
                WorkDirContext.setWorkDir((WorkDir)this.previousWorkdir);
            }
            this.closed = true;
        }

        private void saveArtifact() {
            if (this.contentLength() > 0L) {
                try {
                    InputStream content = this.getContent();
                    String artifactName = new SimpleDateFormat("'script_output_'yyyyMMddHHmmss'.log'").format(new Date());
                    this.attachmentId = this.attachmentService.insertArtifact(this.task.getRelease(), artifactName, content);
                }
                catch (FileNotFoundException e) {
                    String msg = String.format("Unable to fetch script log file of a task '%s'", this.task.getId());
                    this.logger.warn(msg, (Throwable)e);
                    this.commentService.appendComment(this.task, null, msg);
                }
                catch (Exception e) {
                    this.logger.error("Unable to save attachment of a task '{}'.", (Object)this.task.getId(), (Object)e);
                    this.commentService.appendComment(this.task, null, "Unable to save attachment. Please check `xl-release.log`");
                }
            }
        }

        private long contentLength() {
            return this.dfos.getByteCount();
        }

        private InputStream getContent() throws FileNotFoundException {
            InputStream content = this.dfos.isInMemory() ? new ByteArrayInputStream(this.dfos.getData()) : new FileInputStream(this.dfos.getFile());
            return content;
        }

        public String toString() {
            return this.ringWriter.toString();
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }
    }

    public static class VariablesUpdateHolder {
        private Map<String, Object> releaseVariables;
        private Map<String, Object> globalVariables;
        private Map<String, Object> folderVariables;
        private Map<String, Variable> initialReleaseVariables;
        private Map<String, Variable> initialGlobalVariables;
        private Map<String, Variable> initialFolderVariables;

        public VariablesUpdateHolder(Map<String, Object> releaseVariables, Map<String, Object> globalVariables, Map<String, Object> folderVariables2, Map<String, Variable> initialReleaseVariables, Map<String, Variable> initialGlobalVariables, Map<String, Variable> initialFolderVariables) {
            this.releaseVariables = releaseVariables;
            this.globalVariables = globalVariables;
            this.folderVariables = folderVariables2;
            this.initialReleaseVariables = initialReleaseVariables;
            this.initialGlobalVariables = initialGlobalVariables;
            this.initialFolderVariables = initialFolderVariables;
        }

        public Map<String, Object> getReleaseVariables() {
            return this.releaseVariables;
        }

        public Map<String, Object> getGlobalVariables() {
            return this.globalVariables;
        }

        public Map<String, Variable> getInitialReleaseVariables() {
            return this.initialReleaseVariables;
        }

        public Map<String, Variable> getInitialGlobalVariables() {
            return this.initialGlobalVariables;
        }

        public Map<String, Object> getFolderVariables() {
            return this.folderVariables;
        }

        public Map<String, Variable> getInitialFolderVariables() {
            return this.initialFolderVariables;
        }
    }

    public static interface BaseScriptTaskResults
    extends Serializable {
    }
}

