/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.repository.CustomSseEvent;
import com.xebialabs.xlrelease.repository.FakeSseEventSink;
import com.xebialabs.xlrelease.repository.SSERepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;
import org.slf4j.Marker;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.Map;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@Repository
@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\n\u0014\u0001qA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006m\u0001!\ta\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u00191\u0005\u0001)A\u0005y!9q\t\u0001b\u0001\n\u0013A\u0005B\u00028\u0001A\u0003%\u0011\nC\u0004p\u0001\t\u0007I\u0011\u00029\t\rM\u0004\u0001\u0015!\u0003r\u0011\u0015!\b\u0001\"\u0003v\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u00111\b\u0001\u0005B\u0005u\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\u0012A\u0003R3gCVdGoU*F%\u0016\u0004xn]5u_JL(B\u0001\u000b\u0016\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003-]\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005aI\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Q\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001eG\u001d\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013&\u001b\u0005\u0019\u0012B\u0001\u0014\u0014\u00055\u00196+\u0012*fa>\u001c\u0018\u000e^8ssB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006g24GG\u001b\u0006\u0002Y\u0005AqM]5{u2,G-\u0003\u0002/S\t9Aj\\4hS:<\u0017!\u0003=me\u000e{gNZ5h!\t\tD'D\u00013\u0015\t\u0019T#\u0001\u0004d_:4\u0017nZ\u0005\u0003kI\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002\rqJg.\u001b;?)\tA\u0014\b\u0005\u0002%\u0001!)qF\u0001a\u0001a\u00051Q.\u00199qKJ,\u0012\u0001\u0010\t\u0003{\u0011k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003\u0003\n\u000bqA[1dWN|gN\u0003\u0002D3\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003\u000bz\u0012Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%A\u0005vg\u0016\u00148+\u001b8lgV\t\u0011\n\u0005\u0003K\u001fFcV\"A&\u000b\u00051k\u0015AC2p]\u000e,(O]3oi*\u0011ajH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001)L\u0005\ri\u0015\r\u001d\t\u0003%fs!aU,\u0011\u0005Q{R\"A+\u000b\u0005Y[\u0012A\u0002\u001fs_>$h(\u0003\u0002Y?\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv\u0004E\u0002^A\nl\u0011A\u0018\u0006\u0003?6\u000bq!\\;uC\ndW-\u0003\u0002b=\n\u00191+\u001a;\u0011\u0005\rdW\"\u00013\u000b\u0005\u00154\u0017aA:tK*\u0011q\r[\u0001\u0003eNT!!\u001b6\u0002\u0005]\u001c(\"A6\u0002\u000f)\f7.\u0019:uC&\u0011Q\u000e\u001a\u0002\r'N,WI^3oiNKgn[\u0001\u000bkN,'oU5oWN\u0004\u0013A\u0003;pa&\u001cWk]3sgV\t\u0011\u000f\u0005\u0003K\u001fF\u0013\bcA/a#\u0006YAo\u001c9jGV\u001bXM]:!\u0003M\u0019'/Z1uK\u000e{gnY;se\u0016tGoU3u+\t1(\u0010F\u0001x!\ri\u0006\r\u001f\t\u0003sjd\u0001\u0001B\u0003|\u0013\t\u0007APA\u0001U#\ri\u0018\u0011\u0001\t\u0003=yL!a`\u0010\u0003\u000f9{G\u000f[5oOB\u0019a$a\u0001\n\u0007\u0005\u0015qDA\u0002B]f\f\u0001bZ3u'&t7n\u001d\u000b\u0005\u0003\u0017\ty\u0001\u0005\u0003S\u0003\u001b\u0011\u0017BA1\\\u0011\u0019\t\tB\u0003a\u0001#\u0006AQo]3s]\u0006lW-\u0001\u0005hKR,6/\u001a:t)\u0011\t9\"!\u0007\u0011\tI\u000bi!\u0015\u0005\u0007\u00037Y\u0001\u0019A)\u0002\u000bQ|\u0007/[2\u0002\u001fM,g\u000eZ#wK:$Hk\\*j].$\u0002\"!\t\u0002(\u0005%\u0012Q\u0006\t\u0004=\u0005\r\u0012bAA\u0013?\t!QK\\5u\u0011\u0019\tY\u0002\u0004a\u0001#\"1\u00111\u0006\u0007A\u0002E\u000b\u0011\"\u001a<f]Rt\u0015-\\3\t\r\u0005=B\u00021\u0001R\u0003\u001d\u0001\u0018-\u001f7pC\u0012\fQ\"\u00193e+N,'\u000fV8TS:\\GCBA\u0011\u0003k\t9\u0004\u0003\u0004\u0002\u00125\u0001\r!\u0015\u0005\u0007\u0003si\u0001\u0019\u00012\u0002\tMLgn[\u0001\u000fC\u0012$Gk\u001c9jGR{Wk]3s)\u0019\t\t#a\u0010\u0002B!1\u00111\u0004\bA\u0002ECa!!\u0005\u000f\u0001\u0004\t\u0016!\u0005:f[>4X\rV8qS\u000e$v.V:feR1\u0011\u0011EA$\u0003\u0013Ba!a\u0007\u0010\u0001\u0004\t\u0006BBA\t\u001f\u0001\u0007\u0011+A\fsK6|g/Z!mYV\u001bXM]:Ge>lGk\u001c9jGR!\u0011\u0011EA(\u0011\u0019\tY\u0002\u0005a\u0001#\u0006\t\"/Z7pm\u0016\u001cEn\\:fINKgn[:\u0015\u0005\u0005\u0005\u0002f\u0001\u0001\u0002XA!\u0011\u0011LA4\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013AC:uKJ,w\u000e^=qK*!\u0011\u0011MA2\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA3\u0003\ry'oZ\u0005\u0005\u0003S\nYF\u0001\u0006SKB|7/\u001b;pef\u0004")
public class DefaultSSERepository
implements SSERepository,
Logging {
    private final XlrConfig xlrConfig;
    private final ObjectMapper mapper;
    private final Map<String, Set<SseEventSink>> userSinks;
    private final Map<String, Set<String>> topicUsers;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public OutboundSseEventImpl.BuilderImpl newEventBuilder() {
        return SSERepository.newEventBuilder$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultSSERepository defaultSSERepository = this;
        synchronized (defaultSSERepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private Map<String, Set<SseEventSink>> userSinks() {
        return this.userSinks;
    }

    private Map<String, Set<String>> topicUsers() {
        return this.topicUsers;
    }

    private <T> Set<T> createConcurrentSet() {
        return CollectionConverters$.MODULE$.SetHasAsScala(Collections.newSetFromMap(new ConcurrentHashMap())).asScala();
    }

    @Override
    public scala.collection.immutable.Set<SseEventSink> getSinks(String username) {
        this.removeClosedSinks();
        return ((IterableOnceOps)this.userSinks().getOrElse((Object)username, (Function0 & Serializable)() -> this.createConcurrentSet())).toSet();
    }

    @Override
    public scala.collection.immutable.Set<String> getUsers(String topic) {
        return ((IterableOnceOps)this.topicUsers().getOrElse((Object)topic, (Function0 & Serializable)() -> this.createConcurrentSet())).toSet();
    }

    @Override
    public void sendEventToSink(String topic, String eventName, String payload) {
        Object object = new Object();
        try {
            Runnable task = () -> {
                CustomSseEvent xlrSseEvent = new CustomSseEvent(eventName, topic, payload);
                OutboundSseEvent event = this.newEventBuilder().data((Object)this.mapper().writeValueAsString((Object)xlrSseEvent)).mediaType(MediaType.APPLICATION_JSON_TYPE).build();
                scala.collection.immutable.Set<String> users = this.getUsers(topic);
                users.foreach((Function1 & Serializable)user -> {
                    DefaultSSERepository.$anonfun$sendEventToSink$2(this, event, object, user);
                    return BoxedUnit.UNIT;
                });
            };
            this.xlrConfig.executors().sseExecutor().pool().submit(task);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void addUserToSink(String username, SseEventSink sink) {
        this.removeClosedSinks();
        Set userSink = (Set)this.userSinks().getOrElse((Object)username, (Function0 & Serializable)() -> this.createConcurrentSet());
        this.userSinks().put((Object)username, (Object)userSink.$plus$eq((Object)sink));
    }

    @Override
    public void addTopicToUser(String topic, String username) {
        if (!this.userSinks().contains((Object)username)) {
            this.logger().debug((Function0 & Serializable)() -> "Trying to subscribe user [" + username + "] for topic [" + topic + "] but user has no SSE sink");
            this.addUserToSink(username, new FakeSseEventSink());
        }
        Set topicsByUser = (Set)this.topicUsers().getOrElse((Object)topic, (Function0 & Serializable)() -> this.createConcurrentSet());
        this.topicUsers().put((Object)topic, (Object)topicsByUser.$plus$eq((Object)username));
    }

    @Override
    public void removeTopicToUser(String topic, String username) {
        Set topicsByUser = (Set)this.topicUsers().getOrElse((Object)topic, (Function0 & Serializable)() -> this.createConcurrentSet());
        this.topicUsers().put((Object)topic, (Object)topicsByUser.$minus$eq((Object)username));
    }

    @Override
    public void removeAllUsersFromTopic(String topic) {
        if (this.topicUsers().contains((Object)topic)) {
            this.topicUsers().remove((Object)topic);
            return;
        }
    }

    private void removeClosedSinks() {
        this.userSinks().values().foreach((Function1 & Serializable)set -> (Set)set.filterInPlace((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultSSERepository.$anonfun$removeClosedSinks$2(x$1))));
        this.userSinks().filterInPlace((Function2 & Serializable)(x$2, set) -> BoxesRunTime.boxToBoolean((boolean)set.nonEmpty()));
    }

    public static final /* synthetic */ void $anonfun$sendEventToSink$2(DefaultSSERepository $this, OutboundSseEvent event$1, Object nonLocalReturnKey1$1, String user) {
        $this.getSinks(user).foreach((Function1 & Serializable)sink -> {
            if (!sink.isClosed()) {
                return sink.send(event$1).exceptionally(x0$1 -> {
                    Throwable throwable = x0$1;
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        $this.logger().debug((Function0 & Serializable)() -> "can't send SSE event", (Function0 & Serializable)() -> throwable2);
                        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                    }
                    throw new MatchError((Object)throwable);
                });
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeClosedSinks$2(SseEventSink x$1) {
        return !x$1.isClosed();
    }

    public DefaultSSERepository(XlrConfig xlrConfig) {
        this.xlrConfig = xlrConfig;
        SSERepository.$init$(this);
        Logging.$init$((Logging)this);
        this.mapper = new ObjectMapper();
        this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.mapper().registerModule((Module)new JodaModule());
        this.userSinks = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.topicUsers = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }
}

