/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.utils;

public class WordUtils {
    public static String convertToTitleCase(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        value = value.toLowerCase().stripLeading();
        int valueLen = value.length();
        int[] charPoints = new int[valueLen];
        int outOffset = 0;
        Integer delimiter = Character.codePointAt(new char[]{' '}, 0);
        boolean capitalizeNext = true;
        int index = 0;
        while (index < valueLen) {
            int codePoint = value.codePointAt(index);
            if (delimiter == codePoint) {
                capitalizeNext = outOffset != 0;
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                charPoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            charPoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        if (outOffset != 0) {
            return new String(charPoints, 0, outOffset);
        }
        return value;
    }
}

