/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.GlobalVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableReplacedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseVariablesUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UserInputTaskUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseVariableRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u000f\u001f\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011I\u0003!\u0011!Q\u0001\nMCQ!\u0017\u0001\u0005\u0002iCQA\u001d\u0001\u0005\u0002MDq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003{Bq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017Dq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002v\u0002!I!a>\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!\u0011\u0005\u0001\u0005\n\t\r\u0002b\u0002B+\u0001\u0011%!q\u000b\u0002\u0010-\u0006\u0014\u0018.\u00192mKN+'O^5dK*\u0011q\u0004I\u0001\bg\u0016\u0014h/[2f\u0015\t\t#%A\u0005yYJ,G.Z1tK*\u00111\u0005J\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!J\u0001\u0004G>l7\u0001A\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005)1\u000f\u001c45U*\t1'\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0004GA\u0004M_\u001e<\u0017N\\4\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e!\u0003)\u0011X\r]8tSR|'/_\u0005\u0003ye\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00029\u007f%\u0011\u0001)\u000f\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005<be&\f'\r\\3SKB|7/\u001b;pef\u0004\"\u0001O\"\n\u0005\u0011K$!\u0007*fY\u0016\f7/\u001a,be&\f'\r\\3SKB|7/\u001b;pef\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u0005\u001dCU\"\u0001\u0010\n\u0005%s\"\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005\u001dc\u0015BA'\u001f\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0015Q\f7o\u001b\"bG.,\b\u000f\u0005\u0002H!&\u0011\u0011K\b\u0002\u000b)\u0006\u001c8NQ1dWV\u0004\u0018\u0001C3wK:$()^:\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0013AB3wK:$8/\u0003\u0002Y+\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\rqJg.\u001b;?)!YF,\u00180`A\u0006\u0014\u0007CA$\u0001\u0011\u00151\u0004\u00021\u00018\u0011\u0015i\u0004\u00021\u0001?\u0011\u0015\t\u0005\u00021\u0001C\u0011\u0015)\u0005\u00021\u0001G\u0011\u0015Q\u0005\u00021\u0001L\u0011\u0015q\u0005\u00021\u0001P\u0011\u0015\u0011\u0006\u00021\u0001TQ\tAA\r\u0005\u0002fa6\taM\u0003\u0002hQ\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005%T\u0017a\u00024bGR|'/\u001f\u0006\u0003W2\fQAY3b]NT!!\u001c8\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011a\\\u0001\u0004_J<\u0017BA9g\u0005%\tU\u000f^8xSJ,G-A\rgS:$')_%e\u0013:\u001cG.\u001e3j]\u001e\f%o\u00195jm\u0016$GC\u0001;}!\t)(0D\u0001w\u0015\t9\b0A\u0005wCJL\u0017M\u00197fg*\u0011\u0011\u0010I\u0001\u0007I>l\u0017-\u001b8\n\u0005m4(\u0001\u0003,be&\f'\r\\3\t\u000buL\u0001\u0019\u0001@\u0002\u0015Y\f'/[1cY\u0016LE\rE\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001\u0016\u000e\u0005\u0005\u0015!bAA\u0004M\u00051AH]8pizJ1!a\u0003+\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0002\u0016)\u0007%\t)\u0002\u0005\u0003\u0002\u0018\u0005\u001dRBAA\r\u0015\r9\u00171\u0004\u0006\u0005\u0003;\ty\"\u0001\u0003d_J,'\u0002BA\u0011\u0003G\t!\"\\5de>lW\r^3s\u0015\t\t)#\u0001\u0002j_&!\u0011\u0011FA\r\u0005\u0015!\u0016.\\3e\u0003!1\u0017N\u001c3Cs&#Gc\u0001;\u00020!)QP\u0003a\u0001}\"\u001a!\"!\u0006\u0002/\u0019Lg\u000e\u001a*fY\u0016\f7/\u001a,be&\f'\r\\3Cs&#Gc\u0001;\u00028!)Qp\u0003a\u0001}\u00061b-\u001b8e\u000f2|'-\u00197WCJL\u0017M\u00197f\u0005fLE\rF\u0002u\u0003{AQ! \u0007A\u0002y\f\u0011BZ5oI\nK8*Z=\u0015\u000bQ\f\u0019%a\u0012\t\r\u0005\u0015S\u00021\u0001\u007f\u000311\u0018M]5bE2,g*Y7f\u0011\u0019\tI%\u0004a\u0001}\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004\u001b\u0005U\u0011aC1eIZ\u000b'/[1cY\u0016$R\u0001^A)\u0003;Bq!a\u0015\u000f\u0001\u0004\t)&A\u0004sK2,\u0017m]3\u0011\t\u0005]\u0013\u0011L\u0007\u0002q&\u0019\u00111\f=\u0003\u000fI+G.Z1tK\"1\u0011q\f\bA\u0002Q\f\u0001B^1sS\u0006\u0014G.\u001a\u0015\u0004\u001d\u0005U\u0011AF;qI\u0006$XMU3mK\u0006\u001cXMV1sS\u0006\u0014G.Z:\u0015\r\u0005U\u0013qMA5\u0011\u001d\t\u0019f\u0004a\u0001\u0003+Baa^\bA\u0002\u0005-\u0004#BA7\u0003o\"XBAA8\u0015\u0011\t\t(a\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003k\nAA[1wC&!\u0011\u0011PA8\u0005\u0011a\u0015n\u001d;)\u0007=\t)\u0002\u0006\u0005\u0002V\u0005}\u0014\u0011QAB\u0011\u001d\t\u0019\u0006\u0005a\u0001\u0003+Baa\u001e\tA\u0002\u0005-\u0004bBAC!\u0001\u0007\u0011qQ\u0001\tm\u0006d\u0017\u000eZ1uKB\u0019\u0011&!#\n\u0007\u0005-%FA\u0004C_>dW-\u00198)\u0007A\t)\"\u0001\bva\u0012\fG/\u001a,be&\f'\r\\3\u0015\u000bQ\f\u0019*!&\t\u000f\u0005M\u0013\u00031\u0001\u0002V!1\u0011qS\tA\u0002Q\fq!\u001e9eCR,G\rK\u0002\u0012\u0003+\t!DZ5oI\u001ecwNY1m-\u0006\u0014\u0018.\u00192mKN|%/R7qif$\"!a(\u0011\u0007U\f\t+C\u0002\u0002$Z\u0014qb\u00127pE\u0006dg+\u0019:jC\ndWm\u001d\u0015\u0004%\u0005U\u0011a\u00054j]\u0012<En\u001c2bYZ\u000b'/[1cY\u0016\u001c\u0018!E1eI\u001ecwNY1m-\u0006\u0014\u0018.\u00192mKR\u0019A/!,\t\r\u0005=F\u00031\u0001u\u0003\u00051\bf\u0001\u000b\u0002\u0016\u0005!R\u000f\u001d3bi\u0016<En\u001c2bYZ\u000b'/[1cY\u0016$2\u0001^A\\\u0011\u0019\t9*\u0006a\u0001i\"\u001aQ#!\u0006\u0002)\u0011,G.\u001a;f\u000f2|'-\u00197WCJL\u0017M\u00197f)\u0011\ty,!2\u0011\u0007%\n\t-C\u0002\u0002D*\u0012A!\u00168ji\")QP\u0006a\u0001}\"\u001aa#!\u0006\u0002\u001d\u0011,G.\u001a;f-\u0006\u0014\u0018.\u00192mKR1\u0011qXAg\u0003\u001fDq!a\u0015\u0018\u0001\u0004\t)\u0006C\u0003~/\u0001\u0007a\u0010K\u0002\u0018\u0003+\tqB]3qY\u0006\u001cWMV1sS\u0006\u0014G.\u001a\u000b\t\u0003\u007f\u000b9.!7\u0002\\\"9\u00111\u000b\rA\u0002\u0005U\u0003BBA01\u0001\u0007A\u000fC\u0004\u0002^b\u0001\r!a8\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e\u001e\t\u0005\u0003C\fy/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u00151wN]7t\u0015\u0011\tI/a;\u0002\u0005Y\f$bAAwA\u0005\u0019\u0011\r]5\n\t\u0005E\u00181\u001d\u0002\u0010-\u0006\u0014\u0018.\u00192mK>\u0013h+\u00197vK\"\u001a\u0001$!\u0006\u0002'\rDWmY6SK:\fW.\u001a,bY&$\u0017\u000e^=\u0015\u0011\u0005}\u0016\u0011 B\u0007\u0005#Aaa^\rA\u0002\u0005m\b#BA\u007f\u0005\u000f!h\u0002BA\u0000\u0005\u0007qA!a\u0001\u0003\u0002%\t1&C\u0002\u0003\u0006)\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003\n\t-!aA*fc*\u0019!Q\u0001\u0016\t\r\t=\u0011\u00041\u0001u\u0003\u001d\u0019WO\u001d:f]RDa!a&\u001a\u0001\u0004!\u0018!G;qI\u0006$XMV1sS\u0006\u0014G.Z!oIB\u0013xN^5eKJ$\u0012\u0002\u001eB\f\u00057\u0011iBa\b\t\r\te!\u00041\u0001\u007f\u0003!\u0001\u0018M]3oi&#\u0007B\u0002B\b5\u0001\u0007A\u000f\u0003\u0004\u0002\u0018j\u0001\r\u0001\u001e\u0005\b\u0003'R\u0002\u0019AA+\u0003A)\b\u000fZ1uKV\u001b\u0018mZ3Q_&tG\u000f\u0006\u0005\u0003&\t\u0005#\u0011\u000bB*!\u0015y(q\u0005B\u0016\u0013\u0011\u0011I#!\u0005\u0003\u0007M+G\u000f\u0005\u0003\u0003.\tuRB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\u0007U$WN\u0003\u0003\u0002n\nU\"\u0002\u0002B\u001c\u0005s\ta\u0001\u001d7vO&t'b\u0001B\u001eE\u0005AA-\u001a9m_fLG/\u0003\u0003\u0003@\t=\"!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"9!1I\u000eA\u0002\t\u0015\u0013AA;q!\u0011\u00119E!\u0014\u000e\u0005\t%#b\u0001B&m\u0006I!/\u001a4fe\u0016t7-Z\u0005\u0005\u0005\u001f\u0012IE\u0001\u0006Vg\u0006<W\rU8j]RDa!a\u0018\u001c\u0001\u0004!\bbBAo7\u0001\u0007\u0011q\\\u0001\u0010gft7\r\u0016:jO\u001e,'OV1sgR!\u0011q\u0018B-\u0011\u001d\t\u0019\u0006\ba\u0001\u0003+B3\u0001\u0001B/!\u0011\u0011yF!\u001a\u000e\u0005\t\u0005$b\u0001B2Y\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\u001d$\u0011\r\u0002\b'\u0016\u0014h/[2f\u0001")
public class VariableService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseVariableRepository variableRepository;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final TaskBackup taskBackup;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        VariableService variableService = this;
        synchronized (variableService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Variable findByIdIncludingArchived(String variableId) {
        if (VariableHelper$.MODULE$.isGlobalVariableId(variableId)) {
            return this.findGlobalVariableById(variableId);
        }
        if (this.variableRepository.exists(variableId)) {
            return this.findById(variableId);
        }
        if (this.archivingService.exists(variableId)) {
            return this.archivingService.getVariable(variableId);
        }
        throw new NotFoundException("Variable [" + variableId + "] does not exist in the repository or archive", new Object[0]);
    }

    @Timed
    public Variable findById(String variableId) {
        if (VariableHelper$.MODULE$.isGlobalVariableId(variableId)) {
            return this.findGlobalVariableById(variableId);
        }
        return this.findReleaseVariableById(variableId);
    }

    private Variable findReleaseVariableById(String variableId) {
        return this.variableRepository.findById(variableId);
    }

    private Variable findGlobalVariableById(String variableId) {
        return (Variable)this.configurationRepository.read(variableId);
    }

    @Timed
    public Variable findByKey(String variableName, String releaseId) {
        String string = variableName;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Strings.isNotBlank((String)string)) {
            return this.variableRepository.findByKey(string, releaseId);
        }
        return null;
    }

    @Timed
    public Variable addVariable(Release release, Variable variable) {
        this.logger().debug((Function0 & Serializable)() -> "Adding new variable with key [" + variable.getKey() + "] to release [" + release.getId() + "]");
        variable.setId(null);
        ValueProviderConfiguration variableValueProvider = variable.getValueProvider();
        if (variableValueProvider != null) {
            variableValueProvider.setId(null);
            variableValueProvider.setVariable(variable);
        }
        if (variable.isPassword()) {
            ((PasswordStringVariable)variable).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)None$.MODULE$, (ConfigurationItem)variable);
        release.addVariable(variable);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        Object object = !release.getVariableById(variable.getId()).isPresent() ? release.addVariable(variable) : BoxedUnit.UNIT;
        this.syncTriggerVars(release);
        Variable created = this.variableRepository.create(variable, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableCreatedEvent(variable));
        return created;
    }

    @Timed
    public Release updateReleaseVariables(Release release, java.util.List<Variable> variables) {
        return this.updateReleaseVariables(release, variables, true);
    }

    @Timed
    public Release updateReleaseVariables(Release release, java.util.List<Variable> variables, boolean validate) {
        Buffer newVariableKeys;
        Buffer deletedVariables;
        Buffer usedVariables;
        String usedVariablesTxt;
        variables.forEach(variable -> Checks.checkArgument((!com.google.common.base.Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]));
        java.util.List originalVariables = release.getVariables();
        Buffer originalVariablesList = CollectionConverters$.MODULE$.ListHasAsScala(originalVariables).asScala();
        if (validate) {
            CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().foreach((Function1 & Serializable)v -> {
                VariableService.$anonfun$updateReleaseVariables$2(originalVariablesList, v);
                return BoxedUnit.UNIT;
            });
        }
        if (StringUtils.hasText((String)(usedVariablesTxt = ((IterableOnceOps)(usedVariables = (Buffer)(deletedVariables = (Buffer)originalVariablesList.filterNot(arg_0 -> VariableService.$anonfun$updateReleaseVariables$5$adapted(newVariableKeys = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().map((Function1 & Serializable)x$2 -> x$2.getKey()), arg_0))).flatMap((Function1 & Serializable)variable -> {
            String variableKey = VariableHelper$.MODULE$.withVariableSyntax(variable.getKey());
            boolean isVariableUsedOutsideUserInputTask = CollectionConverters$.MODULE$.SetHasAsScala(release.collectVariableReferences()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$updateReleaseVariables$7(variableKey, x$3))).exists((Function1 & Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$updateReleaseVariables$8(ref)));
            if (isVariableUsedOutsideUserInputTask) {
                return new Some(variable);
            }
            return None$.MODULE$;
        })).map((Function1 & Serializable)v -> "'" + v.getKey() + "'")).mkString(", ")))) {
            throw new Checks.IncorrectArgumentException("The following variable(s) are still used: " + usedVariablesTxt + ". Replace them before you try to delete them.", new Object[0]);
        }
        release.setVariables(variables);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        this.syncTriggerVars(release);
        this.variableRepository.update((scala.collection.immutable.Seq<Variable>)originalVariablesList.toSeq(), (scala.collection.immutable.Seq<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().toSeq(), release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariablesUpdatedEvent(originalVariables, variables));
        return release;
    }

    @Timed
    public Variable updateVariable(Release release, Variable updated) {
        Variable updatedVariable;
        block3: {
            this.logger().debug((Function0 & Serializable)() -> "Updating variable [" + updated.getId() + "]");
            updated.checkValidity();
            Variable current = (Variable)release.getVariableById(updated.getId()).get();
            VariablePersistenceHelper$.MODULE$.checkSameType(current, updated);
            String string = current.getKey();
            String string2 = updated.getKey();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ReleaseStatus releaseStatus = release.getStatus();
                ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
                if (releaseStatus == null ? releaseStatus2 != null : !releaseStatus.equals(releaseStatus2)) {
                    ReleaseStatus releaseStatus3 = release.getStatus();
                    ReleaseStatus releaseStatus4 = ReleaseStatus.PLANNED;
                    if (releaseStatus3 == null ? releaseStatus4 != null : !releaseStatus3.equals(releaseStatus4)) {
                        throw new IllegalStateException("Cannot rename variable " + updated.getId() + " of an already started release");
                    }
                }
                this.checkRenameValidity((scala.collection.immutable.Seq<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().toSeq(), current, updated);
            }
            updatedVariable = this.updateVariableAndProvider(release.getId(), current, updated, release);
            this.eventBus.publish((XLReleaseEvent)new ReleaseVariableUpdatedEvent(current, updated));
            String string3 = current.getKey();
            String string4 = updated.getKey();
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block3;
            this.replaceVariableUsages$1(current, updatedVariable, release);
        }
        return updatedVariable;
    }

    @Timed
    public GlobalVariables findGlobalVariablesOrEmpty() {
        return this.findGlobalVariables();
    }

    private GlobalVariables findGlobalVariables() {
        GlobalVariables globalVariables = new GlobalVariables();
        globalVariables.setVariables(this.configurationRepository.findAllByType(Type.valueOf(Variable.class)));
        return globalVariables;
    }

    @Timed
    public Variable addGlobalVariable(Variable v) {
        this.logger().debug((Function0 & Serializable)() -> "Adding new global variable with key [" + v.getKey() + "]");
        if (v.isPassword()) {
            ((PasswordStringVariable)v).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)None$.MODULE$, (ConfigurationItem)v);
        GlobalVariables globalVars = this.findGlobalVariables();
        Variable newVariable = globalVars.addVariable(v);
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(globalVars.getId(), globalVars.getVariables(), this.ciIdService);
        this.configurationRepository.create(newVariable);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableCreatedEvent(newVariable, null));
        return newVariable;
    }

    @Timed
    public Variable updateGlobalVariable(Variable updated) {
        this.logger().debug((Function0 & Serializable)() -> "Updating global variable [" + updated.getId() + "]");
        updated.checkGlobalVariableValidity();
        Variable current = this.findGlobalVariableById(updated.getId());
        VariablePersistenceHelper$.MODULE$.checkSameType(current, updated);
        GlobalVariables globalVars = this.findGlobalVariables();
        String string = current.getKey();
        String string2 = updated.getKey();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkRenameValidity((scala.collection.immutable.Seq<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(globalVars.getVariables()).asScala().toSeq(), current, updated);
        }
        Variable variable = this.updateVariableAndProvider(globalVars.getId(), current, updated, null);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableUpdatedEvent(current, variable, null));
        return variable;
    }

    @Timed
    public void deleteGlobalVariable(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting global variable [" + variableId + "]");
        Variable variable = this.findGlobalVariableById(variableId);
        this.configurationRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new GlobalVariableDeletedEvent(variable, null));
    }

    @Timed
    public void deleteVariable(Release release, String variableId) {
        Variable variable = (Variable)release.getVariableById(variableId).orElseThrow(() -> new NotFoundException("Repository entity [" + variableId + "] not found", new Object[0]));
        String variableKey = VariableHelper$.MODULE$.withVariableSyntax(variable.getKey());
        boolean isVariableUsedOutsideUserInputTask = CollectionConverters$.MODULE$.SetHasAsScala(release.collectVariableReferences()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$deleteVariable$2(variableKey, x$5))).exists((Function1 & Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$deleteVariable$3(ref)));
        if (isVariableUsedOutsideUserInputTask) {
            throw new Checks.IncorrectArgumentException("The following variable is still used: " + variable.getKey() + ". Replace it before you try to delete it.", new Object[0]);
        }
        release.removeVariable(variableId);
        release.getAllUserInputTasks().forEach(task -> $this.taskBackup.removeVariable((UserInputTask)task, variableId));
        this.syncTriggerVars(release);
        this.variableRepository.delete(variableId, release);
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableDeletedEvent(variable));
    }

    @Timed
    public void replaceVariable(Release release, Variable variable, VariableOrValue replacement) {
        if (replacement.getVariable() == null && replacement.getValue() == null) {
            replacement.setValue(variable.getEmptyValue());
        } else if (variable.isPassword()) {
            replacement.setValue((Object)PasswordVerificationUtils$.MODULE$.replacePasswordIfNeeded(variable.getValue(), replacement.getValue()));
        }
        if (replacement.getVariable() != null) {
            replacement.setVariable(VariableHelper$.MODULE$.formatVariableIfNeeded(replacement.getVariable()));
        }
        Set cis = (Set)CollectionConverters$.MODULE$.SetHasAsScala(release.collectVariableReferences()).asScala().withFilter((Function1 & Serializable)varRef -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$replaceVariable$1(variable, varRef))).flatMap((Function1 & Serializable)varRef -> (Set)CollectionConverters$.MODULE$.SetHasAsScala(varRef.getUsagePoints()).asScala().flatMap((Function1 & Serializable)up -> (scala.collection.immutable.Set)this.updateUsagePoint((UsagePoint)up, variable, replacement).map((Function1 & Serializable)u -> u)));
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.syncTriggerVars(release);
        this.variableRepository.replace(release, (scala.collection.immutable.Seq<ConfigurationItem>)cis.toSeq());
        this.eventBus.publish((XLReleaseEvent)new ReleaseVariableReplacedEvent(variable, replacement));
    }

    private void checkRenameValidity(scala.collection.immutable.Seq<Variable> variables, Variable current, Variable updated) {
        if (((SeqOps)variables.map((Function1 & Serializable)x$7 -> x$7.getKey())).contains((Object)updated.getKey())) {
            throw new IllegalArgumentException("Cannot rename variable " + updated.getId() + " from " + current.getKey() + " to " + updated.getKey() + " because " + updated.getKey() + " already exists");
        }
    }

    private Variable updateVariableAndProvider(String parentId, Variable current, Variable updated, Release release) {
        PropertyDescriptor currentValueType = current.getType().getDescriptor().getPropertyDescriptor("value");
        PropertyDescriptor updatedValueType = updated.getType().getDescriptor().getPropertyDescriptor("value");
        if (!currentValueType.getKind().equals((Object)updatedValueType.getKind())) {
            throw new IllegalArgumentException("Cannot change type of variable from " + current.getType() + " to " + updated.getType());
        }
        if (updated.isPassword()) {
            ((PasswordStringVariable)updated).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some((Object)current), (ConfigurationItem)updated);
        if (updated.getValueProvider() != null) {
            updated.getValueProvider().setId("");
            updated.getValueProvider().setVariable(updated);
        }
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(parentId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)updated, (List)Nil$.MODULE$)).asJava(), this.ciIdService);
        if (Ids.isReleaseId((String)parentId)) {
            release.replaceVariable(current, updated);
            this.syncTriggerVars(release);
            this.variableRepository.update(current, updated, release);
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = this.configurationRepository.update(updated);
        }
        return updated;
    }

    private scala.collection.immutable.Set<ConfigurationItem> updateUsagePoint(UsagePoint up, Variable variable, VariableOrValue replacement) {
        return CollectionConverters$.MODULE$.SetHasAsScala(up.replaceVariable(variable, replacement)).asScala().toSet();
    }

    private void syncTriggerVars(Release release) {
        String templateId = release.getId();
        java.util.List templateVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().withFilter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.getShowOnReleaseStart())).map((Function1 & Serializable)v -> CiCloneHelper.cloneCi(v))).asJava();
        ReleaseStatus releaseStatus = release.getStatus();
        ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
        if (!(releaseStatus != null ? !releaseStatus.equals(releaseStatus2) : releaseStatus2 != null)) {
            this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateVariablesChangedEvent(templateId, templateVars));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateReleaseVariables$3(Variable v$1, Variable x$1) {
        String string = x$1.getName();
        String string2 = v$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateReleaseVariables$2(Buffer originalVariablesList$1, Variable v) {
        if (v.isPassword()) {
            ((PasswordStringVariable)v).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)originalVariablesList$1.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$updateReleaseVariables$3(v, x$1))), (ConfigurationItem)v);
    }

    public static final /* synthetic */ boolean $anonfun$updateReleaseVariables$7(String variableKey$1, VariableReference x$3) {
        return x$3.getKey().equals(variableKey$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateReleaseVariables$9(UsagePoint x$4) {
        return !(x$4 instanceof UserInputTaskUsagePoint);
    }

    public static final /* synthetic */ boolean $anonfun$updateReleaseVariables$8(VariableReference ref) {
        return CollectionConverters$.MODULE$.SetHasAsScala(ref.getUsagePoints()).asScala().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$updateReleaseVariables$9(x$4)));
    }

    private final void replaceVariableUsages$1(Variable oldVariable, Variable updatedVariable, Release release$3) {
        VariableOrValue replacement = new VariableOrValue();
        replacement.setVariable(updatedVariable.getKey());
        Release updatedRelease = this.releaseRepository.findById(release$3.getId());
        this.replaceVariable(updatedRelease, oldVariable, replacement);
    }

    public static final /* synthetic */ boolean $anonfun$deleteVariable$2(String variableKey$2, VariableReference x$5) {
        return x$5.getKey().equals(variableKey$2);
    }

    public static final /* synthetic */ boolean $anonfun$deleteVariable$4(UsagePoint x$6) {
        return !(x$6 instanceof UserInputTaskUsagePoint);
    }

    public static final /* synthetic */ boolean $anonfun$deleteVariable$3(VariableReference ref) {
        return CollectionConverters$.MODULE$.SetHasAsScala(ref.getUsagePoints()).asScala().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)VariableService.$anonfun$deleteVariable$4(x$6)));
    }

    public static final /* synthetic */ boolean $anonfun$replaceVariable$1(Variable variable$2, VariableReference varRef) {
        String string = VariableHelper$.MODULE$.withoutVariableSyntax(varRef.getKey());
        String string2 = VariableHelper$.MODULE$.withoutVariableSyntax(variable$2.getKey());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public VariableService(ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, ReleaseVariableRepository variableRepository, ArchivingService archivingService, CiIdService ciIdService, TaskBackup taskBackup, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.releaseRepository = releaseRepository;
        this.variableRepository = variableRepository;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.taskBackup = taskBackup;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$updateReleaseVariables$5$adapted(Buffer newVariableKeys$1, Variable variable) {
        return BoxesRunTime.boxToBoolean((boolean)newVariableKeys$1.contains((Object)variable.getKey()));
    }
}

