/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.analytics.service;

import com.xebialabs.xlrelease.analytics.service.AnalyticsService$;
import com.xebialabs.xlrelease.api.utils.WordUtils;
import com.xebialabs.xlrelease.domain.metadata.MetadataEntry;
import com.xebialabs.xlrelease.json.JsonUtils$;
import com.xebialabs.xlrelease.repository.MetadataRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055s!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007i\u0005\u0001\u000b\u0011\u0002\u0017\t\u000fU\n!\u0019!C\u0001W!1a'\u0001Q\u0001\n12A\u0001I\n\u0001o!A\u0001i\u0002B\u0001B\u0003%\u0011\tC\u0003)\u000f\u0011\u0005q\tC\u0003Z\u000f\u0011\u0005!\fC\u0003j\u000f\u0011\u0005!\u000eC\u0003n\u000f\u0011\u0005a\u000eC\u0003r\u000f\u0011\u0005!\u000f\u0003\u0004\u0000\u000f\u0011%\u0011\u0011\u0001\u0005\b\u0003/9A\u0011AA\r\u0011\u001d\tyc\u0002C\u0005\u0003cAq!a\u000e\b\t\u0013\tI$\u0001\tB]\u0006d\u0017\u0010^5dgN+'O^5dK*\u0011A#F\u0001\bg\u0016\u0014h/[2f\u0015\t1r#A\u0005b]\u0006d\u0017\u0010^5dg*\u0011\u0001$G\u0001\nq2\u0014X\r\\3bg\u0016T!AG\u000e\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000f\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005}\tQ\"A\n\u0003!\u0005s\u0017\r\\=uS\u000e\u001c8+\u001a:wS\u000e,7CA\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AH\u0001\r\u0003:\u000bE*\u0017+J\u0007N{\u0016\nR\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005Y\u0006twMC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#AB*ue&tw-A\u0007B\u001d\u0006c\u0015\fV%D'~KE\tI\u0001\u0018\u0003:\u000bE*\u0017+J\u0007N{V*\u0012+S\u0013\u000e{&+\u0012)P%R\u000b\u0001$\u0011(B\u0019f#\u0016jQ*`\u001b\u0016#&+S\"`%\u0016\u0003vJ\u0015+!'\r9!\u0005\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\nQa\u001d7gi)T\u0011!P\u0001\tOJL'P\u001f7fI&\u0011qH\u000f\u0002\b\u0019><w-\u001b8h\u0003IiW\r^1eCR\f'+\u001a9pg&$xN]=\u0011\u0005\t+U\"A\"\u000b\u0005\u0011;\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011ai\u0011\u0002\u0013\u001b\u0016$\u0018\rZ1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0006\u0002I\u0013B\u0011qd\u0002\u0005\u0006\u0001&\u0001\r!\u0011\u0015\u0003\u0013-\u0003\"\u0001T,\u000e\u00035S!AT(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002Q#\u00069a-Y2u_JL(B\u0001*T\u0003\u0015\u0011W-\u00198t\u0015\t!V+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00051\u0016aA8sO&\u0011\u0001,\u0014\u0002\n\u0003V$xn^5sK\u0012\f\u0011cZ3oKJ\fG/Z!dG>,h\u000e^%e)\rYVm\u001a\t\u00039\u000et!!X1\u0011\u0005y#S\"A0\u000b\u0005\u0001l\u0012A\u0002\u001fs_>$h(\u0003\u0002cI\u00051\u0001K]3eK\u001aL!a\r3\u000b\u0005\t$\u0003\"\u00024\u000b\u0001\u0004Y\u0016\u0001\u00047jG\u0016t7/\u001a3OC6,\u0007\"\u00025\u000b\u0001\u0004Y\u0016!C:feZ,'/\u0016:m\u000319W\r^!dG>,h\u000e^%e)\rY6\u000e\u001c\u0005\u0006M.\u0001\ra\u0017\u0005\u0006Q.\u0001\raW\u0001\u0010kB$\u0017\r^3BG\u000e|WO\u001c;JIR\u00191l\u001c9\t\u000b\u0019d\u0001\u0019A.\t\u000b!d\u0001\u0019A.\u0002%\u001d,G/\u00118bYf$\u0018nY:SKB|'\u000f\u001e\u000b\u0002gB\u0019Ao^=\u000e\u0003UT!A\u001e\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003qV\u0014\u0001b\u00149uS>t\u0017\r\u001c\t\u0005ij\\F0\u0003\u0002|k\n\u0019Q*\u00199\u0011\u00055j\u0018B\u0001@/\u0005\u0019y%M[3di\u00069\"/Z1e%\u0016\u0004xN\u001d;Ge>l'j]8o\u000b:$(/\u001f\u000b\u0004s\u0006\r\u0001bBA\u0003\u001d\u0001\u0007\u0011qA\u0001\u0006K:$(/\u001f\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003!iW\r^1eCR\f'bAA\t/\u00051Am\\7bS:LA!!\u0006\u0002\f\tiQ*\u001a;bI\u0006$\u0018-\u00128uef\fqcZ3oKJ\fG/Z!oC2LH/[2t%\u0016\u0004xN\u001d;\u0015\t\u0005m\u0011\u0011\u0005\t\u0004G\u0005u\u0011bAA\u0010I\t!QK\\5u\u0011\u001d\t\u0019c\u0004a\u0001\u0003K\t!b]=ti\u0016l\u0017J\u001c4p!\u0019a\u0016qE.\u0002*%\u00111\u0010\u001a\t\u0004G\u0005-\u0012bAA\u0017I\t\u0019\u0011I\\=\u0002\u001fQ\u0014\u0018M\\:g_Jl'+\u001a9peR$B!!\n\u00024!9\u0011Q\u0007\tA\u0002\u0005\u0015\u0012aA7ba\u0006aAO]1og\u001a|'/\\&fsR\u00191,a\u000f\t\r\u0005u\u0012\u00031\u0001\\\u0003\rYW-\u001f\u0015\u0004\u000f\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d3+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u0013\u0002F\t91+\u001a:wS\u000e,\u0007")
public class AnalyticsService
implements Logging {
    private final MetadataRepository metadataRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String ANALYTICS_METRIC_REPORT() {
        return AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT();
    }

    public static String ANALYTICS_ID() {
        return AnalyticsService$.MODULE$.ANALYTICS_ID();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        AnalyticsService analyticsService = this;
        synchronized (analyticsService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String generateAccountId(String licensedName, String serverUrl) {
        String accountName = WordUtils.convertToTitleCase(StringUtils.stripAccents((String)((String)Option$.MODULE$.apply((Object)licensedName).getOrElse((Function0 & Serializable)() -> ""))).replaceAll("[^a-zA-Z0-9]", " ").replaceAll("(\\d)([A-Za-z])", "$1 $2"));
        String accountEnvironment = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(DigestUtils.md5Hex((String)((String)Option$.MODULE$.apply((Object)serverUrl).getOrElse((Function0 & Serializable)() -> "")))), 6);
        return accountName + "_" + accountEnvironment;
    }

    public String getAccountId(String licensedName, String serverUrl) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Option<MetadataEntry> option = $this.metadataRepository.getEntry(AnalyticsService$.MODULE$.ANALYTICS_ID());
            if (option instanceof Some) {
                Some some = (Some)option;
                MetadataEntry entry = (MetadataEntry)some.value();
                return entry.value();
            }
            if (None$.MODULE$.equals(option)) {
                String accountId = this.generateAccountId(licensedName, serverUrl);
                $this.metadataRepository.create(AnalyticsService$.MODULE$.ANALYTICS_ID(), accountId);
                return accountId;
            }
            throw new MatchError(option);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String accountId = (String)success.value();
            return accountId;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Exception while creating Analytics Identifier", (Function0 & Serializable)() -> e);
            return "";
        }
        throw new MatchError((Object)try_);
    }

    public String updateAccountId(String licensedName, String serverUrl) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String accountId = this.generateAccountId(licensedName, serverUrl);
            if ($this.metadataRepository.exists(AnalyticsService$.MODULE$.ANALYTICS_ID())) {
                this.logger().debug((Function0 & Serializable)() -> "Updating Analytics Identifier");
                $this.metadataRepository.update(AnalyticsService$.MODULE$.ANALYTICS_ID(), accountId);
            } else {
                this.logger().debug((Function0 & Serializable)() -> "Creating Analytics Identifier");
                $this.metadataRepository.create(AnalyticsService$.MODULE$.ANALYTICS_ID(), accountId);
            }
            return accountId;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String accountId = (String)success.value();
            return accountId;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Exception while updating Analytics Identifier", (Function0 & Serializable)() -> e);
            return "";
        }
        throw new MatchError((Object)try_);
    }

    public Optional<java.util.Map<String, Object>> getAnalyticsReport() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.metadataRepository.getEntry(AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT()).map((Function1 & Serializable)reportEntry -> {
            this.logger().debug((Function0 & Serializable)() -> "Including analytics metric report " + reportEntry.value() + " into account properties");
            java.util.Map<String, Object> report = this.readReportFromJsonEntry((MetadataEntry)reportEntry);
            this.logger().debug((Function0 & Serializable)() -> "Deleting  analytics metric report " + reportEntry.value() + " from metadata repository");
            $this.metadataRepository.delete(AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT());
            return report;
        }));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option report = (Option)success.value();
            return Optional.ofNullable(report.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Exception while updating Analytics Identifier", (Function0 & Serializable)() -> e);
            return Optional.empty();
        }
        throw new MatchError((Object)try_);
    }

    private java.util.Map<String, Object> readReportFromJsonEntry(MetadataEntry entry) {
        scala.collection.immutable.Map report = (scala.collection.immutable.Map)JsonUtils$.MODULE$.objectMapper().readValue((String)Option$.MODULE$.apply((Object)entry.content()).getOrElse((Function0 & Serializable)() -> "{}"), scala.collection.immutable.Map.class);
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)report.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof List) {
                    List list = (List)value;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)list).asJava()));
                }
            }
            return tuple2;
        })).asJava();
    }

    public void generateAnalyticsReport(scala.collection.immutable.Map<String, Object> systemInfo) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.collection.immutable.Map systemInfoMap = (scala.collection.immutable.Map)JsonUtils$.MODULE$.objectMapper().convertValue((Object)systemInfo, scala.collection.immutable.Map.class);
            scala.collection.immutable.Map<String, Object> analyticsReport = this.transformReport((scala.collection.immutable.Map<String, Object>)systemInfoMap);
            if (analyticsReport.nonEmpty()) {
                MetadataEntry analyticsReportEntry = new MetadataEntry(AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT() + "_" + DateTimeFormatter.ISO_INSTANT.format(Instant.now()), JsonUtils$.MODULE$.objectMapper().writeValueAsString(analyticsReport));
                this.logger().debug((Function0 & Serializable)() -> "Generated analytics metrics report " + analyticsReportEntry.value() + ": " + analyticsReportEntry.content());
                if ($this.metadataRepository.exists(AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT())) {
                    this.logger().debug((Function0 & Serializable)() -> "Updating analytics metrics report");
                    $this.metadataRepository.update(AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT(), analyticsReportEntry);
                    return;
                }
                this.logger().debug((Function0 & Serializable)() -> "Creating analytics metrics report");
                $this.metadataRepository.create(AnalyticsService$.MODULE$.ANALYTICS_METRIC_REPORT(), analyticsReportEntry);
                return;
            }
        });
        if (try_ instanceof Success) {
            this.logger().debug((Function0 & Serializable)() -> "Analytics metrics report generated successfully");
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable to generate analytics metrics report, error: " + e.getMessage(), (Function0 & Serializable)() -> e);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private scala.collection.immutable.Map<String, Object> transformReport(scala.collection.immutable.Map<String, Object> map) {
        return (scala.collection.immutable.Map)map.flatMap((Function1 & Serializable)x0$1 -> {
            Object nestedMap;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (nestedMap = tuple2._2()) instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)nestedMap;
                return this.transformReport((scala.collection.immutable.Map<String, Object>)map);
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return (IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transformKey(key)), value)}));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String transformKey(String key) {
        return "Release_" + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(key));
    }

    @Autowired
    public AnalyticsService(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
        Logging.$init$((Logging)this);
    }
}

