package com.xebialabs.xlrelease.security

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.domain.{Release, ReleaseKind, Task, Team}
import com.xebialabs.xlrelease.features.PermissionCheckFeature
import com.xebialabs.xlrelease.service.TeamUpdateOperation
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Component

import java.util
import java.util.function.Consumer

//scalastyle:off number.of.methods
@Primary
@Component("permissionChecker")
class DefaultPermissionChecker(permissionCheckerWithoutCache: PermissionCheckerWithoutCache,
                               permissionCheckerWithCache: PermissionCheckerWithCache)
  extends PermissionChecker {

  private def delegate(): PermissionChecker = {
    if (PermissionCheckFeature.useCache) {
      permissionCheckerWithCache
    } else {
      permissionCheckerWithoutCache
    }
  }

  override def check(permission: Permission): Unit = delegate().check(permission)

  override def check(permission: Permission, ciId: String): Unit = delegate().check(permission, ciId)

  override def check(permission: Permission, release: Release): Unit = delegate().check(permission, release)

  override def checkAny(ciId: String, permissions: Permission*): Unit = delegate().checkAny(ciId, permissions: _*)

  override def checkAny(permissions: Permission*): Unit = delegate().checkAny(permissions: _*)

  override def checkView(releaseId: String): Unit = delegate().checkView(releaseId)

  override def checkView(release: Release): Unit = delegate().checkView(release)

  override def canViewRelease(releaseId: String): Boolean = delegate().canViewRelease(releaseId)

  override def checkEditAttachment(ciId: String): Unit = delegate().checkEditAttachment(ciId)

  override def checkEdit(releaseId: String): Unit = delegate().checkEdit(releaseId)

  override def checkAbort(releaseId: String): Unit = delegate().checkAbort(releaseId)

  override def checkEditTask(releaseId: String): Unit = delegate().checkEditTask(releaseId)

  override def checkEditDate(ciId: String): Unit = delegate().checkEditDate(ciId)

  override def canEditTask(releaseId: String): Boolean = delegate().canEditTask(releaseId)

  override def checkEditVariable(release: Release, variable: Variable): Unit = delegate().checkEditVariable(release, variable)

  override def checkEditVariable(release: Release, task: Task, variable: Variable): Unit = delegate().checkEditVariable(release, task, variable)

  override def checkEditTaskConfigurationFacet(releaseId: String): Unit = delegate().checkEditTaskConfigurationFacet(releaseId)

  override def checkDeleteTasks(ids: util.List[String]): Unit = delegate().checkDeleteTasks(ids)

  override def checkReassignTasks(ids: util.List[String], newUser: String): Unit = delegate().checkReassignTasks(ids, newUser)

  override def checkReassignTaskToUser(taskId: String, newUser: String): Unit = delegate().checkReassignTaskToUser(taskId, newUser)

  override def areUsersInTheSameTaskTeam(task: Task, newUser: String): Boolean = delegate().areUsersInTheSameTaskTeam(task, newUser)

  override def checkEditBlackoutPermission(release: Release): Unit = delegate().checkEditBlackoutPermission(release)

  override def checkEditBlackoutPermission(releaseId: String): Unit = delegate().checkEditBlackoutPermission(releaseId)

  override def checkEditFailureHandlerPermission(release: Release): Unit = delegate().checkEditFailureHandlerPermission(release)

  override def checkEditFailureHandlerPermission(releaseId: String): Unit = delegate().checkEditFailureHandlerPermission(releaseId)

  override def checkEditPreconditionPermission(release: Release): Unit = delegate().checkEditPreconditionPermission(release)

  override def checkEditPreconditionPermission(releaseId: String): Unit = delegate().checkEditPreconditionPermission(releaseId)

  override def checkReassignTaskPermission(releaseId: String): Unit = delegate().checkReassignTaskPermission(releaseId)

  override def checkReassignTaskPermission(release: Release): Unit = delegate().checkReassignTaskPermission(release)

  override def checkReopenTaskInRelease(releaseId: String): Unit = delegate().checkReopenTaskInRelease(releaseId)

  override def checkReopenTasksInRelease(taskIds: util.List[String]): Unit = delegate().checkReopenTasksInRelease(taskIds)

  override def checkForLockTaskPermissionForTransition(task: Task): Unit = delegate().checkForLockTaskPermissionForTransition(task)

  override def checkIsAllowedToCommentOnTask(taskId: String): Unit = delegate().checkIsAllowedToCommentOnTask(taskId)

  override def checkIsAllowedToEditAttachmentsOnTask(taskId: String): Unit = delegate().checkIsAllowedToEditAttachmentsOnTask(taskId)

  override def filterAllowedToCommentOnTasks(taskIds: util.List[String]): util.List[String] = delegate().filterAllowedToCommentOnTasks(taskIds)

  override def checkIsAllowedToStartTask(taskId: String): Unit = delegate().checkIsAllowedToStartTask(taskId)

  override def checkIsAllowedToWorkOnTask(taskId: String): Unit = delegate().checkIsAllowedToWorkOnTask(taskId)

  override def checkTaskTransitionPermission(taskId: String): Unit = delegate().checkTaskTransitionPermission(taskId)

  override def checkAdvanceTaskTransitionPermission(taskId: String): Unit = delegate().checkAdvanceTaskTransitionPermission(taskId)

  override def checkRelevantTaskTransitionPermission(taskId: String): Unit = delegate().checkRelevantTaskTransitionPermission(taskId)

  override def filterTasksWithTaskTransitionPermission(taskIds: util.List[String]): util.List[String] = {
    delegate().filterTasksWithTaskTransitionPermission(taskIds)
  }

  override def isAllowedToWorkOnTask(taskId: String): Boolean = delegate().isAllowedToWorkOnTask(taskId)

  override def filterStartableReleases(releaseIds: util.List[String]): util.List[String] = delegate().filterStartableReleases(releaseIds)

  override def filterAbortableReleases(releaseIds: util.List[String]): util.List[String] = delegate().filterAbortableReleases(releaseIds)

  override def filter(items: util.List[Release], permission: Permission): util.List[Release] = delegate().filter(items, permission)

  override def checkIsAllowedToCreateReleaseFromTemplate(templateId: String, targetFolderId: String): Unit = {
    delegate().checkIsAllowedToCreateReleaseFromTemplate(templateId, targetFolderId)
  }

  override def checkIsAllowedToCreateReleaseInFolder(folderId: String, releaseKind: ReleaseKind): Unit = {
    delegate().checkIsAllowedToCreateReleaseInFolder(folderId, releaseKind)
  }

  override def checkIsAllowedToRegisterRunner(): Unit = delegate().checkIsAllowedToRegisterRunner

  override def checkEditSecurity(releaseId: String): Unit = delegate().checkEditSecurity(releaseId)

  override def hasGlobalPermission(permission: Permission): Boolean = delegate().hasGlobalPermission(permission)

  override def hasPermission(permission: Permission, ciId: String): Boolean = delegate().hasPermission(permission, ciId)

  override def hasPermission(permission: Permission, release: Release): Boolean = delegate().hasPermission(permission, release)

  override def checkHasPermissionsToUpdateTask(task: Task): Unit = delegate().checkHasPermissionsToUpdateTask(task)

  override def checkViewTask(task: Task): Unit = delegate().checkViewTask(task)

  override def checkViewFolder(containerId: String): Unit = delegate().checkViewFolder(containerId)

  override def isMemberOrRoleOf(releaseId: String, teamName: String): Boolean = delegate().isMemberOrRoleOf(releaseId, teamName)

  override def isNotAuthenticated: Boolean = delegate().isNotAuthenticated

  override def isCurrentUserAdmin: Boolean = delegate().isCurrentUserAdmin

  override def filterSilently(ids: util.List[String], checker: Consumer[String]): util.List[String] = delegate().filterSilently(ids, checker)

  override def checkCopyTask(releaseId: String): Unit = delegate().checkCopyTask(releaseId)

  override def copyPhase(releaseId: String): Unit = delegate().copyPhase(releaseId)

  override def checkLockTaskPermission(releaseId: String): Unit = delegate().checkLockTaskPermission(releaseId)

  override def checkLockTaskPermissionForAssignment(): Unit = delegate().checkLockTaskPermissionForAssignment()

  override def checkViewTeams(teamContainerId: String): Unit = delegate().checkViewTeams(teamContainerId)

  override def getUserFolderTeams(folderId: String): util.List[Team] = delegate().getUserFolderTeams(folderId)

  override def checkDeleteOwnTeams(teamContainerId: String): Unit = delegate().checkDeleteOwnTeams(teamContainerId)

  override def checkEditNotification(folderId: String): Unit = delegate().checkEditNotification(folderId)

  override def context(): PermissionContext = {
    delegate().context()
  }

  override def checkEditTeams(teamContainerId: String, operations: Seq[_ <: TeamUpdateOperation]): Unit = delegate().checkEditTeams(teamContainerId, operations)

  override def checkEditTeamsAgainstExisting(teamContainerId: String, teams: util.Collection[Team]): Unit = {
    delegate().checkEditTeamsAgainstExisting(teamContainerId, teams)
  }

  override def checkEditTeamPermissions(teamContainerId: String, addedPermissions: Seq[String], removedPermissions: Seq[String]): Unit = {
    delegate().checkEditTeamPermissions(teamContainerId, addedPermissions, removedPermissions)
  }

  override def checkEditTeamMembers(teamContainerId: String, team: Team): Unit = {
    delegate().checkEditTeamMembers(teamContainerId, team)
  }

  override def checkDeleteTeam(teamContainerId: String, team: Team): Unit = {
    delegate().checkDeleteTeam(teamContainerId, team)
  }
}
