/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.CSPFilter;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.MaintenanceModeAccessControlFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.SseDisableBufferingFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.JettyEmbeddedErrorHandler;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jetty12.server.TimedHandler;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.SessionTrackingMode;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u0010!\u0001-B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003G\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011Y\u0003!\u0011!Q\u0001\n]CQa\u0019\u0001\u0005\u0002\u0011DQa\u001b\u0001\u0005B1DQa\u001d\u0001\u0005RQDq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u00033\u0002A\u0011BA.\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a$\u0001\t\u0013\t\t\nC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003\u001b\u0004A\u0011BAh\u0005\r\u0012V\r\\3bg\u0016TU\r\u001e;z'\u0016\u0014h\u000f\\3u/\u0016\u00147+\u001a:wKJ4\u0015m\u0019;pefT!!\t\u0012\u0002\u000b),G\u000f^=\u000b\u0005\r\"\u0013AB:feZ,'O\u0003\u0002&M\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003O!\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0017\u0011\u00055JT\"\u0001\u0018\u000b\u0005\u0005z#B\u0001\u00192\u0003!)WNY3eI\u0016$'B\u0001\u001a4\u0003\r9XM\u0019\u0006\u0003iU\nAAY8pi*\u0011agN\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001(A\u0002pe\u001eL!A\u000f\u0018\u00039)+G\u000f^=TKJ4H.\u001a;XK\n\u001cVM\u001d<fe\u001a\u000b7\r^8ss\u0006\u00192/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002AM\u0005AA-\u001a9m_fLG/\u0003\u0002C\u007f\t\u00192+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006!2/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002\n\u0011\u0002\u001f7s\u0007>tg-[4\u0016\u0003\u0019\u0003\"a\u0012&\u000e\u0003!S!!\u0013\u0013\u0002\r\r|gNZ5h\u0013\tY\u0005JA\u0005YYJ\u001cuN\u001c4jO\u0006Q\u0001\u0010\u001c:D_:4\u0017n\u001a\u0011\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!kP\u0001\tg\u0016\u001cWO]5us&\u0011A+\u0015\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/A\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\b%A\u0007nKR,'OU3hSN$(/\u001f\t\u00031\u0006l\u0011!\u0017\u0006\u00035n\u000b!\"\u001b8tiJ,X.\u001a8u\u0015\taV,\u0001\u0003d_J,'B\u00010`\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0002A\u0006\u0011\u0011n\\\u0005\u0003Ef\u0013Q\"T3uKJ\u0014VmZ5tiJL\u0018A\u0002\u001fj]&$h\bF\u0003fO\"L'\u000e\u0005\u0002g\u00015\t\u0001\u0005C\u0003<\u0011\u0001\u0007Q\bC\u0003E\u0011\u0001\u0007a\tC\u0003N\u0011\u0001\u0007q\nC\u0003W\u0011\u0001\u0007q+\u0001\rjgJ+w-[:uKJ$UMZ1vYR\u001cVM\u001d<mKR$\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0002a\u0006)1oY1mC&\u0011!o\u001c\u0002\b\u0005>|G.Z1o\u0003a\u0001xn\u001d;Qe>\u001cWm]:XK\n\f\u0005\u000f]\"p]R,\u0007\u0010\u001e\u000b\u0003kb\u0004\"A\u001c<\n\u0005]|'\u0001B+oSRDQ!\u001f\u0006A\u0002i\f1bY8oi\u0016DHOU8piB\u001910a\u0002\u000e\u0003qT!! @\u0002\r],'-\u00199q\u0015\ry\u0018\u0011A\u0001\u0005K\u0016\f\u0004GC\u0002\"\u0003\u0007Q1!!\u00028\u0003\u001d)7\r\\5qg\u0016L1!!\u0003}\u000559VMY!qa\u000e{g\u000e^3yi\u0006Q1/\u001a;va*+G\u000f^=\u0015\u0007U\fy\u0001C\u0003z\u0017\u0001\u0007!0A\rhKR,%O]8s!\u0006<WmQ8oM&<WO]1uS>tGCAA\u000b!\rY\u0018qC\u0005\u0004\u00033a(!D\"p]\u001aLw-\u001e:bi&|g.\u0001\nbI\u0012TU\r\u001e;z\u000bJ\u0014xN\u001d)bO\u0016\u001cH#B;\u0002 \u0005=\u0002bBA\u0011\u001b\u0001\u0007\u00111E\u0001\rKJ\u0014xN\u001d%b]\u0012dWM\u001d\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006@\u0002\u000fM,'O\u001e7fi&!\u0011QFA\u0014\u00051)%O]8s\u0011\u0006tG\r\\3s\u0011\u001d\t\t$\u0004a\u0001\u0003g\t!\"\u001a:s_J\u0004\u0016mZ3t!\u0019\t)$a\u0010\u0002D5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0003vi&d'BAA\u001f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0013q\u0007\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BA#\u0003\u0013j!!a\u0012\u000b\u0005\r\n\u0014\u0002BA&\u0003\u000f\u0012\u0011\"\u0012:s_J\u0004\u0016mZ3\u0002%M,G/\u001e9M_\u001e\u0014\u0017mY6GS2$XM\u001d\u000b\u0004k\u0006E\u0003\"B=\u000f\u0001\u0004Q\u0018aC:fiV\u00048\u000b\u001d:j]\u001e$2!^A,\u0011\u0015Ix\u00021\u0001{\u0003=\u0019X\r^;q\u0007>\u00148OR5mi\u0016\u0014HcA;\u0002^!)\u0011\u0010\u0005a\u0001u\u0006i2/\u001a;vab\u001b8oU3dkJLG/\u001f%fC\u0012,'o\u001d$jYR,'\u000fF\u0002v\u0003GBQ!_\tA\u0002i\fab]3ukB,&\u000f\u001c$jYR,'\u000fF\u0002v\u0003SBQ!\u001f\nA\u0002i\f1c]3ukB\u001cFn\\<e_^tg)\u001b7uKJ$2!^A8\u0011\u0015I8\u00031\u0001{\u00039\u0019X\r^;q\u0007N\u0003f)\u001b7uKJ$2!^A;\u0011\u0015IH\u00031\u0001{\u0003E\u0019X\r^;q\u000bb$XM\\:j_:\f\u0005/\u001b\u000b\u0004k\u0006m\u0004\"B=\u0016\u0001\u0004Q\u0018\u0001F:fiV\u0004h+\u001a:tS>tWI\u001c4pe\u000e,'\u000fF\u0002v\u0003\u0003CQ!\u001f\fA\u0002i\f\u0011c]3ukB\u0014V-];fgRdunY1m)\r)\u0018q\u0011\u0005\u0006s^\u0001\rA_\u0001\u0015K:\f'\r\\3SKN|WO]2fg\u000e\u000b7\r[3\u0015\u0007U\fi\tC\u0003z1\u0001\u0007!0A\tf]\u0006\u0014G.Z${SBD\u0015M\u001c3mKJ$2!^AJ\u0011\u0015I\u0018\u00041\u0001{\u0003EqWm^*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u00033\u0003B!!\n\u0002\u001c&!\u0011QTA\u0014\u00059\u0019Vm]:j_:D\u0015M\u001c3mKJ\f\u0011$\u001a8bE2,\u0017J\\:ueVlWM\u001c;fI\"\u000bg\u000e\u001a7feR\u0019Q/a)\t\u000be\\\u0002\u0019\u0001>\u0002#M,G\u000f\u0015:pa\u0016\u0014H/_%g\u001dVdG\u000eF\u0003v\u0003S\u000b\u0019\rC\u0004\u0002,r\u0001\r!!,\u0002\u0007-,\u0017\u0010\u0005\u0003\u00020\u0006uf\u0002BAY\u0003s\u00032!a-p\u001b\t\t)LC\u0002\u00028*\na\u0001\u0010:p_Rt\u0014bAA^_\u00061\u0001K]3eK\u001aLA!a0\u0002B\n11\u000b\u001e:j]\u001eT1!a/p\u0011\u001d\t)\r\ba\u0001\u0003[\u000bQA^1mk\u0016\fqe]3ukBl\u0015-\u001b8uK:\fgnY3N_\u0012,\u0017iY2fgN\u001cuN\u001c;s_24\u0015\u000e\u001c;feR\u0019Q/a3\t\u000bel\u0002\u0019\u0001>\u0002=M,G/\u001e9Tg\u0016$\u0015n]1cY\u0016\u0014UO\u001a4fe&twMR5mi\u0016\u0014HcA;\u0002R\")\u0011P\ba\u0001u\u0002")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;
    private final MeterRegistry meterRegistry;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupMaintenanceModeAccessControlFilter(contextRoot);
        this.setupSseDisableBufferingFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.setSessionHandler(this.newSessionHandler());
        contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
        contextRoot.addConfiguration(new Configuration[]{this.getErrorPageConfiguration()});
        if (this.xlrConfig().metrics().enabled()) {
            this.enableInstrumentedHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_gzip_enabled()) {
            this.enableGzipHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_cache_enabled() && Environment.isProduction()) {
            this.enableResourcesCache(contextRoot);
            return;
        }
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(this){
            private final /* synthetic */ ReleaseJettyServletWebServerFactory $outer;

            public void configure(WebAppContext context) {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                errorHandler.setShowServlet(false);
                errorHandler.setShowStacks(false);
                errorHandler.setShowMessageInTitle(false);
                context.setErrorHandler((Request.Handler)errorHandler);
                this.$outer.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages((ErrorHandler)errorHandler, this.$outer.getErrorPages());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new AbstractConfiguration.Builder());
            }
        };
    }

    public void com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        ErrorHandler errorHandler2 = errorHandler;
        if (errorHandler2 instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)errorHandler2;
            CollectionConverters$.MODULE$.CollectionHasAsScala(errorPages).asScala().foreach((Function1 & Serializable)errorPage -> {
                ReleaseJettyServletWebServerFactory.$anonfun$addJettyErrorPages$1(errorPageErrorHandler, errorPage);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        filter.setAsyncSupported(true);
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        encodingFilter.setAsyncSupported(true);
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        ResourceFactory resourceFactory = contextRoot.getResourceFactory();
        URI path = Path.of(".", new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toUri();
        Resource baseResource = resourceFactory.newResource(path);
        contextRoot.setBaseResource(baseResource);
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
            return;
        }
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "x-requested-with, accept, origin, content-type");
            holder.setInitParameter("Access-Control-Max-Age", "3600");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        if (Environment.isDevelopment()) {
            long slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis();
            if (slowDownInMs > 0L) {
                this.logger.warn((Object)("Configuring slow down filter with " + slowDownInMs + " milliseconds."));
                FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
                slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
                slowdownFilter.setAsyncSupported(true);
                contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                return;
            }
            return;
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().server_http_csp_enabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.xlrConfig().server_http_csp_policyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(PekkoStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        if (!Environment.isDevelopment()) {
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
            return;
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, this.xlrConfig().server_http_gzip_compression(), true));
        contextRoot.insertHandler((Handler.Singleton)gzipHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)("Setting up Secure Cookie Enabled to - " + this.serverConfiguration().isSecureCookieEnabled()));
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return sessionHandler;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        TimedHandler handler = new TimedHandler(this.meterRegistry, (Iterable)Tags.empty());
        contextRoot.insertHandler((Handler.Singleton)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting system property - " + key));
                }
                System.setProperty(key, value);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not overriding already specified system property - " + key));
                return;
            }
            return;
        }
    }

    private void setupMaintenanceModeAccessControlFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().maintenanceModeEnabled()) {
            boolean restrictApiAccess = this.xlrConfig().maintenanceModeRestrictApiAccess();
            FilterHolder filterHolder = new FilterHolder((Filter)new MaintenanceModeAccessControlFilter(this.permissionEnforcer(), restrictApiAccess));
            contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupSseDisableBufferingFilter(WebAppContext contextRoot) {
        FilterHolder filterHolder = new FilterHolder((Filter)new SseDisableBufferingFilter());
        contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public static final /* synthetic */ void $anonfun$addJettyErrorPages$1(ErrorPageErrorHandler x2$1, ErrorPage errorPage) {
        if (errorPage.isGlobal()) {
            x2$1.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
            return;
        }
        if (errorPage.getExceptionName() != null) {
            x2$1.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
            return;
        }
        x2$1.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer, MeterRegistry meterRegistry) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
        this.meterRegistry = meterRegistry;
    }
}

