/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.VariableOrPasswordView;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskViewBuilder {
    private String id;
    private String title;
    private String description;
    private String type;
    private TaskStatus status;
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private Date dueDate;
    private Date scheduledStartDate;
    private boolean delayDuringBlackout;
    private String owner;
    private String team;
    private String environment;
    private String deploymentPackage;
    private String server;
    private Set<String> addresses = new HashSet<String>();
    private String subject;
    private String body;
    private Map<String, Object> inputProperties = Maps.newHashMap();
    private Map<String, Object> outputProperties = Maps.newHashMap();
    private String scriptDefinitionType;
    private String ownerFullName;
    private Long duration;
    private List<Variable> variablesList = new ArrayList<Variable>();
    private String templateId;
    private String folderId;
    private String newReleaseTitle;
    private String createdReleaseId;
    private boolean startRelease;
    private Map<String, String> variableMapping = Maps.newHashMap();
    private List<String> tags = new ArrayList<String>();

    private TaskViewBuilder() {
    }

    public static TaskViewBuilder newTaskView() {
        return new TaskViewBuilder();
    }

    public TaskViewBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public TaskViewBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public TaskViewBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public TaskViewBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public TaskViewBuilder withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public TaskViewBuilder withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    public TaskViewBuilder withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this;
    }

    public TaskViewBuilder withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskViewBuilder withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this;
    }

    public TaskViewBuilder withDelayDuringBlackout(boolean delayDuringBlackout) {
        this.delayDuringBlackout = delayDuringBlackout;
        return this;
    }

    public TaskViewBuilder assignedTo(String owner) {
        this.owner = owner;
        this.ownerFullName = null;
        return this;
    }

    public TaskViewBuilder withTeam(String team) {
        this.team = team;
        return this;
    }

    public TaskViewBuilder withEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public TaskViewBuilder withServer(String server) {
        this.server = server;
        return this;
    }

    public TaskViewBuilder withDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
        return this;
    }

    public TaskViewBuilder withAddresses(Set<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public TaskViewBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public TaskViewBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public TaskViewBuilder withScriptDefinitionType(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
        return this;
    }

    public TaskViewBuilder withInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = Maps.newHashMap(inputProperties);
        return this;
    }

    public TaskViewBuilder withOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = Maps.newHashMap(outputProperties);
        return this;
    }

    public TaskViewBuilder withPlannedDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public TaskViewBuilder withVariables(List<Variable> variables) {
        this.variablesList = variables;
        return this;
    }

    public TaskViewBuilder withVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
        return this;
    }

    public TaskViewBuilder withNewReleaseTitle(String newReleaseTitle) {
        this.newReleaseTitle = newReleaseTitle;
        return this;
    }

    public TaskViewBuilder withTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public TaskViewBuilder withFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public TaskViewBuilder withCreatedReleaseId(String createdReleaseId) {
        this.createdReleaseId = createdReleaseId;
        return this;
    }

    public TaskViewBuilder withStartRelease(boolean startRelease) {
        this.startRelease = startRelease;
        return this;
    }

    public TaskViewBuilder withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public TaskFullView build() {
        TaskFullView taskView = new TaskFullView();
        taskView.setId(this.id);
        taskView.setTitle(this.title);
        taskView.setDescription(this.description);
        taskView.setType(this.type);
        taskView.setStatus(this.status);
        taskView.setFlag(new Flag(this.flagStatus, this.flagComment));
        taskView.setDueDate(this.dueDate);
        taskView.setScheduledStartDate(this.scheduledStartDate);
        taskView.setDelayDuringBlackout(this.delayDuringBlackout);
        if (null != this.owner) {
            taskView.setOwner(new UserView(this.owner, this.ownerFullName));
        }
        taskView.setPassword(new VariableOrPasswordView());
        taskView.setTeam(this.team);
        taskView.setEnvironment(this.environment);
        taskView.setServer(this.server);
        taskView.setDeploymentPackage(this.deploymentPackage);
        taskView.setAddresses(this.addresses);
        taskView.setSubject(this.subject);
        taskView.setBody(this.body);
        taskView.setScriptDefinitionType(this.scriptDefinitionType);
        taskView.setInputProperties(this.inputProperties);
        taskView.setOutputProperties(this.outputProperties);
        taskView.setPlannedDuration(this.duration);
        taskView.setVariables(this.variablesList);
        taskView.setVariableMapping(this.variableMapping);
        taskView.setNewReleaseTitle(this.newReleaseTitle);
        taskView.setTemplateId(this.templateId);
        taskView.setFolderId(this.folderId);
        taskView.setCreatedReleaseId(this.createdReleaseId);
        taskView.setStartRelease(this.startRelease);
        taskView.setTags(this.tags);
        return taskView;
    }
}

