package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Permission settings",
  description = "Flag to control permission checks."
)
class PermissionCheckFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable Permission caching (performance tuning)",
    description = "Use internal cache mechanism when checking permissions",
    category = "input",
    defaultValue = "true")
  var usePermissionChecksWithCache: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "30", hidden = true)
  var weight: Integer = _
}
