package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.variables._
import com.xebialabs.xlrelease.features.settings.ReferenceVariablesFeatureSettings
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, Ids}
import org.springframework.stereotype.Component

import java.util.Optional
import scala.jdk.CollectionConverters._
import scala.util.Try

@Component
class CustomConfigurationValueProvider(configurationRepository: ConfigurationRepository) extends ReferenceCiVariableProvider[BaseConfiguration] {

  override def getSupportedTypes(): Seq[ReferencedType] = {
    val settingsOptional: Optional[ReferenceVariablesFeatureSettings] =
      configurationRepository.findFirstByType(Type.valueOf(classOf[ReferenceVariablesFeatureSettings]))
    if (settingsOptional.isEmpty) {
      Seq.empty
    } else {
      val settings = settingsOptional.get()
      settings.typeList.asScala.map(t => {
        new ReferencedType(t, Type.valueOf(t).getDescriptor.getLabel)
      }).toSeq
    }
  }

  override def getRawValue(variable: ReferenceVariable): Option[BaseConfiguration] = {
    Try(configurationRepository.read[BaseConfiguration](variable.getValue)).toOption
  }

  override def possibleValues(valueProviderConfiguration: CiProvider): Seq[PossibleValue] = {
    val variable = valueProviderConfiguration.getVariable.asInstanceOf[ReferenceVariable]
    val folderId = Ids.findFolderId(variable.getId)
    configurationRepository
      .findAllByTypeAndTitle[BaseConfiguration](Type.valueOf(variable.getReferencedType), null, folderId, folderOnly = false)
      .asScala
      .map(customConfig => new PossibleValue(customConfig.getId, customConfig.getTitle))
      .toSeq
  }


}
