package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Cache settings",
  description = "Manage cache settings to optimize performance. " +
    "Enable or disable caching to control how data is temporarily stored and accessed, improving load times and overall efficiency when enabled.")
class CacheManagementFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable Releases caching",
    description = "Release cache is used to store releases data in memory to improve performance",
    category = "input",
    defaultValue = "true")
  var releaseCacheEnabled: Boolean = _

  @BeanProperty
  @XLProperty(label = "Enable Security caching",
    description = "Security cache is used to store security-related data, such as roles and permissions, in memory to improve performance.",
    category = "input",
    defaultValue = "true")
  var securityCacheEnabled: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "database", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "advanced-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/cache-settings.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "20", hidden = true)
  var weight: Integer = _
}
