/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.xebialabs.xlrelease.principaldata.LdapGroupEmailProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.principaldata.UserDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.GrantedAuthority;

@CacheConfig(cacheManager="externalPrincipalDataCacheManager")
public class PrincipalDataProviderImpl
implements PrincipalDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalDataProviderImpl.class);
    private final List<UserDataProvider> userProviders = new ArrayList<UserDataProvider>();
    private final List<LdapGroupEmailProvider> groupEmailProviders = new ArrayList<LdapGroupEmailProvider>();

    public void addUserProvider(UserDataProvider provider) {
        this.userProviders.add(provider);
    }

    public void addUserProvider(List<UserDataProvider> providers) {
        this.userProviders.addAll(providers);
    }

    public void addGroupProvider(LdapGroupEmailProvider provider) {
        this.groupEmailProviders.add(provider);
    }

    public void addGroupProvider(List<LdapGroupEmailProvider> providers) {
        this.groupEmailProviders.addAll(providers);
    }

    @Override
    @Cacheable(cacheNames={"external-users"}, unless="#result.found == false")
    public UserData getUserData(String username) {
        return this.userProviders.stream().filter(provider -> provider.getUserData(username) != UserData.NOT_FOUND).map(provider -> provider.getUserData(username)).findFirst().orElse(UserData.NOT_FOUND);
    }

    @Override
    @Cacheable(cacheNames={"external-group-emails"}, unless="#result == null")
    public String getGroupEmail(String groupName) {
        return this.groupEmailProviders.stream().filter(provider -> provider.getGroupEmail(groupName) != null).map(provider -> provider.getGroupEmail(groupName)).findFirst().orElse(null);
    }

    @Override
    @Cacheable(cacheNames={"external-authorities"}, unless="#result.empty")
    public Collection<? extends GrantedAuthority> getAuthorities(String username) {
        return this.userProviders.stream().filter(provider -> !provider.getAuthorities(username).isEmpty()).map(provider -> provider.getAuthorities(username)).findFirst().orElse(Collections.emptySet());
    }

    @Override
    @CacheEvict(cacheNames={"external-users", "external-authorities"})
    public void invalidate(String username) {
        logger.debug("Invalidating user data for user: {}", (Object)username);
    }
}

