package com.xebialabs.xlrelease.actors

import com.xebialabs.xlrelease.config.XlrConfig
import org.apache.pekko.actor.ActorRef
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.concurrent.{Await, Promise}
import scala.util.Try

@Component
class ReleasesActorHolder @Autowired()(xlrConfig: XlrConfig) {

  private val releasesPromise = Promise[ActorRef]()

  def awaitActorRef(): ActorRef = {
    Await.result(releasesPromise.future, xlrConfig.timeouts.systemInitialization)
  }

  def finishInitialization(actorRef: Try[ActorRef]) = releasesPromise.tryComplete(actorRef)
}
