/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support.tools;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.api.utils.AccountIdHelper;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.MetadataRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.support.tools.SupportUtilitiesActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.views.LicenseView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\ts\u0001\u0011\t\u0011)A\u0005g!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011%\u0003!Q1A\u0005\u0002)C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t%\u0002\u0011)\u0019!C\u0001'\"AA\f\u0001B\u0001B\u0003%A\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011-\u0004!Q1A\u0005\u00021D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\t\u00012+\u001e9q_J$X\u000b^5mSRLWm\u001d\u0006\u00031e\tQ\u0001^8pYNT!AG\u000e\u0002\u000fM,\b\u000f]8si*\u0011A$H\u0001\nq2\u0014X\r\\3bg\u0016T!AH\u0010\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQa\u001d7gi)T\u0011AL\u0001\tOJL'P\u001f7fI&\u0011\u0001g\u000b\u0002\b\u0019><w-\u001b8h\u0003A\t'o\u00195jm&twmU3sm&\u001cW-F\u00014!\t!t'D\u00016\u0015\t14$A\u0004tKJ4\u0018nY3\n\u0005a*$\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\t'o\u00195jm&twmU3sm&\u001cW\rI\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}Z\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011I\u0010\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n!#\\3uC\u0012\fG/\u0019*fa>\u001c\u0018\u000e^8ssV\tQ\t\u0005\u0002>\r&\u0011qI\u0010\u0002\u0013\u001b\u0016$\u0018\rZ1uCJ+\u0007o\\:ji>\u0014\u00180A\nnKR\fG-\u0019;b%\u0016\u0004xn]5u_JL\b%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O7\u0005\u0011AMY\u0005\u0003!6\u0013\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%\u0001\u000esK2,\u0017m]3BGR|'\u000fT5gK\u000eL8\r\\3Vi&d7/F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,A\u0003vi&d7O\u0003\u0002Z7\u00051\u0011m\u0019;peNL!a\u0017,\u00035I+G.Z1tK\u0006\u001bGo\u001c:MS\u001a,7-_2mKV#\u0018\u000e\\:\u00027I,G.Z1tK\u0006\u001bGo\u001c:MS\u001a,7-_2mKV#\u0018\u000e\\:!\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\ty\u0006-D\u0001Y\u0013\t\t\u0007LA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g.F\u0001e!\t)\u0007.D\u0001g\u0015\t9W$\u0001\u0005eKBdw._5u\u0013\tIgMA\nTKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u000btKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u000fY&\u001cWM\\:f'\u0016\u0014h/[2f+\u0005i\u0007C\u00018s\u001b\u0005y'B\u0001\u001cq\u0015\t\tX$A\u0004mS\u000e,gn]3\n\u0005M|'A\u0004'jG\u0016t7/Z*feZL7-Z\u0001\u0010Y&\u001cWM\\:f'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"\"b^={wrlhp`A\u0001!\tA\b!D\u0001\u0018\u0011\u0015\t\u0004\u00031\u00014\u0011\u0015Q\u0004\u00031\u0001=\u0011\u0015\u0019\u0005\u00031\u0001F\u0011\u0015I\u0005\u00031\u0001L\u0011\u0015\u0011\u0006\u00031\u0001U\u0011\u0015i\u0006\u00031\u0001_\u0011\u0015\u0011\u0007\u00031\u0001e\u0011\u0015Y\u0007\u00031\u0001nQ\r\u0001\u0012Q\u0001\t\u0005\u0003\u000f\ti\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u001f\t\t\"A\u0004gC\u000e$xN]=\u000b\t\u0005M\u0011QC\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003/\tI\"A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY\"A\u0002pe\u001eLA!a\b\u0002\n\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011kB$\u0017\r^3UCN\\7\u000b^1ukN$b!!\n\u0002,\u0005\u0015\u0003c\u0001\u0013\u0002(%\u0019\u0011\u0011F\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[\t\u0002\u0019AA\u0018\u0003\u0019!\u0018m]6JIB!\u0011\u0011GA \u001d\u0011\t\u0019$a\u000f\u0011\u0007\u0005UR%\u0004\u0002\u00028)\u0019\u0011\u0011H\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\ti$J\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005uR\u0005C\u0004\u0002HE\u0001\r!!\u0013\u0002\u00139,wo\u0015;biV\u001c\b\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0007gR\fG/^:\u000b\u0007\u0005M3$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003/\niE\u0001\u0006UCN\\7\u000b^1ukN\f\u0011cZ3u%\u0016dW-Y:f\u0007>tG/\u001a8u)\u0011\ty#!\u0018\t\u000f\u0005}#\u00031\u0001\u00020\u0005I!/\u001a7fCN,\u0017\nZ\u0001\u000eI\u0016dW\r^3SK2,\u0017m]3\u0015\t\u0005\u0015\u0012Q\r\u0005\b\u0003?\u001a\u0002\u0019AA\u0018\u0003E)\b\u000fZ1uK\u0006s\u0017\r\\=uS\u000e\u001c\u0018\n\u001a\u000b\u0003\u0003K\tQcZ3u\u0007V\u0014(/\u001a8u\u0003:\fG.\u001f;jGNLE-\u0006\u0002\u00020!\u001a\u0001!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kRA!a\u001e\u0002\u0016\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005m\u0014Q\u000f\u0002\b'\u0016\u0014h/[2f\u0001")
public class SupportUtilities
implements Logging {
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final MetadataRepository metadataRepository;
    private final ArchivedReleases archivedReleases;
    private final ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    private final ReleaseActorService releaseActorService;
    private final ServerConfiguration serverConfiguration;
    private final LicenseService licenseService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SupportUtilities supportUtilities = this;
        synchronized (supportUtilities) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public MetadataRepository metadataRepository() {
        return this.metadataRepository;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    public ReleaseActorLifecycleUtils releaseActorLifecycleUtils() {
        return this.releaseActorLifecycleUtils;
    }

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public LicenseService licenseService() {
        return this.licenseService;
    }

    public void updateTaskStatus(String taskId, TaskStatus newStatus) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        Checks.checkArgument((boolean)this.releaseRepository().exists(releaseId), (String)("Release [" + releaseId + "] not found"), (Object[])new Object[0]);
        this.releaseActorService.executeCommand(taskId, new SupportUtilitiesActorExtensionHandlerFactory.ForceTaskStatus(taskId, newStatus));
    }

    public String getReleaseContent(String releaseId) {
        if (this.releaseRepository().exists(releaseId)) {
            return this.releaseRepository().getReleaseJson(releaseId);
        }
        return (String)this.archivedReleases().getRelease(releaseId, this.archivedReleases().getRelease$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [" + releaseId + "] not found", new Object[0]);
        });
    }

    public void deleteRelease(String releaseId) {
        String string;
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases().exists(releaseId) ? 1 : 0) != 0, (String)("Release [" + releaseId + "] not found"), (Object[])new Object[0]);
        try {
            string = this.releaseActorLifecycleUtils().terminateReleaseActorAndAwait(releaseId, FiniteDuration$.MODULE$.apply(5L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> "Could not terminate release actor " + releaseId + " within timeout", (Function0 & Serializable)() -> e);
            string = BoxedUnit.UNIT;
        }
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
        if (this.releaseRepository().exists(releaseId)) {
            try {
                this.archivingService().archiveAllIncomingDependencies(releaseId);
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Could not archive incoming dependencies to " + releaseId, (Function0 & Serializable)() -> e);
            }
            this.releaseRepository().delete(releaseId, false);
            return;
        }
    }

    public void updateAnalyticsId() {
        LicenseView licenseView = new LicenseView(this.licenseService().getLicense());
        AccountIdHelper.updateAccountId(this.metadataRepository(), licenseView.getLicensedTo(), this.serverConfiguration().getServerUrl());
    }

    public String getCurrentAnalyticsId() {
        return this.metadataRepository().getEntry("analytics_id");
    }

    @Autowired
    public SupportUtilities(ArchivingService archivingService, ReleaseRepository releaseRepository, MetadataRepository metadataRepository, ArchivedReleases archivedReleases, ReleaseActorLifecycleUtils releaseActorLifecycleUtils, ReleaseActorService releaseActorService, ServerConfiguration serverConfiguration, LicenseService licenseService) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.metadataRepository = metadataRepository;
        this.archivedReleases = archivedReleases;
        this.releaseActorLifecycleUtils = releaseActorLifecycleUtils;
        this.releaseActorService = releaseActorService;
        this.serverConfiguration = serverConfiguration;
        this.licenseService = licenseService;
        Logging.$init$((Logging)this);
    }
}

