package com.xebialabs.xlrelease.views;

import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.metadata.Version;
import scala.Option;

public class PluginView {
    protected String artifactId;

    protected String version;

    public PluginView() {
    }

    public PluginView(PluginId pluginId) {
        this.artifactId = pluginId.name();
        this.version = getVersionString(pluginId.version());
    }

    private String getVersionString(Option<Version> optionalVersion) {
        if (optionalVersion.isEmpty()) {
            return "N/A";
        } else {
            return new Version.VersionOps(optionalVersion.get()).id();
        }
    }

    public String getArtifactId() {
        return artifactId;
    }

    public void setArtifactId(final String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return String.format("%s:%s", artifactId, version);
    }
}
