package com.xebialabs.deployit.plumbing;


import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The following URLs are not valid on XLR side.
 * Requests on these resources will end up with a 200 with empty body.
 */
public class IgnoreUrlFilter implements Filter {

    private static final Logger LOG = LoggerFactory.getLogger(IgnoreUrlFilter.class);

    private static final Supplier<Stream<String>> IGNORED_URLS = () -> Stream.of("angular-gantt.js.map", "ctrl.frameSrc");

    @Override
    public void init(final FilterConfig filterConfig) {}

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            final String requestURI = ((HttpServletRequest) request).getRequestURI();
            if (IGNORED_URLS.get().anyMatch(requestURI::contains)) {
                LOG.debug("Request to [{}] has been ignored", requestURI);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {}

}
