package com.xebialabs.xlrelease.service

import com.xebialabs.xlplatform.cluster.ClusterMode._
import com.xebialabs.xlrelease.actors.BroadcastEventActor
import com.xebialabs.xlrelease.actors.BroadcastEventActor.PublishEvent
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent
import com.xebialabs.xlrelease.events.EventBus
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension
import org.apache.pekko.actor.ActorRef
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component

trait BroadcastService {
  def broadcast(event: DistributedXLReleaseEvent, publishEventOnSelf: Boolean): Unit

}

@Component
@Profile(Array(FULL))
class ClusterBroadcastService extends BroadcastService with ActorInitializer {

  lazy val broadcastEventActor: ActorRef = SpringExtension.actorOf(classOf[BroadcastEventActor])

  override def broadcast(event: DistributedXLReleaseEvent, publishEventOnSelf: Boolean): Unit = {
    broadcastEventActor ! PublishEvent(event, publishEventOnSelf)
  }

  override def initialize(): Unit = {
    this.broadcastEventActor
  }
}

@Component
@Profile(Array(STANDALONE, HOT_STANDBY))
class NonClusteredBroadcastService(eventBus: EventBus) extends BroadcastService {

  override def broadcast(event: DistributedXLReleaseEvent, publishEventOnSelf: Boolean): Unit = {
    if (publishEventOnSelf) eventBus.publish(event)
  }

}
