/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.strategies;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedReleaseExecutedEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.strategies.JobSchedulerStrategy;
import com.xebialabs.xlrelease.scheduler.strategies.LimitParallelJobSchedulerStrategySettings;
import com.xebialabs.xlrelease.scheduler.strategies.NonBlockingBackpressuredJobSchedulerStrategy$;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.slf4j.Marker;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Either;

public final class LimitParallelJobSchedulerStrategy$
implements JobSchedulerStrategy<LimitParallelJobSchedulerStrategySettings>,
ScalaSpringAwareBean,
Logging {
    public static final LimitParallelJobSchedulerStrategy$ MODULE$ = new LimitParallelJobSchedulerStrategy$();
    private static JobRepository jobRepository;
    private static final Map<String, Semaphore> semaphores;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static transient ApplicationContext applicationContext;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        JobSchedulerStrategy.$init$(MODULE$);
        ScalaSpringSupport.$init$((ScalaSpringSupport)MODULE$);
        ScalaSpringAwareBean.$init$((ScalaSpringAwareBean)MODULE$);
        Logging.$init$((Logging)MODULE$);
        semaphores = new ConcurrentHashMap<String, Semaphore>();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ApplicationContext getApplicationContext() {
        return ScalaSpringAwareBean.getApplicationContext$((ScalaSpringAwareBean)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ScalaSpringAwareBean.setApplicationContext$((ScalaSpringAwareBean)this, (ApplicationContext)applicationContext);
    }

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LimitParallelJobSchedulerStrategy$ limitParallelJobSchedulerStrategy$ = this;
        synchronized (limitParallelJobSchedulerStrategy$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public ApplicationContext applicationContext() {
        return applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        applicationContext = x$1;
    }

    private Map<String, Semaphore> semaphores() {
        return semaphores;
    }

    private JobRepository jobRepository$lzycompute() {
        LimitParallelJobSchedulerStrategy$ limitParallelJobSchedulerStrategy$ = this;
        synchronized (limitParallelJobSchedulerStrategy$) {
            if (!bitmap$0) {
                jobRepository = (JobRepository)this.springBean(ClassTag$.MODULE$.apply(JobRepository.class));
                bitmap$0 = true;
            }
        }
        return jobRepository;
    }

    public JobRepository jobRepository() {
        if (!bitmap$0) {
            return this.jobRepository$lzycompute();
        }
        return jobRepository;
    }

    @Override
    public Either<Job, Job> schedule(LimitParallelJobSchedulerStrategySettings configuration, Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            return this.handleJob(configuration, taskJob);
        }
        return package$.MODULE$.Right().apply((Object)job2);
    }

    @Override
    public void unlock(long jobId, Option<String> maybeTaskId) {
        Option<String> option = maybeTaskId;
        if (option instanceof Some) {
            Some some = (Some)option;
            String taskId = (String)some.value();
            String releaseId = this.getReleaseId(taskId);
            this.logger().trace((Function0 & Serializable)() -> "Releasing permit for Release [" + releaseId + "]");
            if (this.semaphores().containsKey(releaseId)) {
                Semaphore releaseSemaphore = this.semaphores().get(releaseId);
                releaseSemaphore.release();
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    @AsyncSubscribe
    public void onReleaseExecutedEvent(DistributedReleaseExecutedEvent event) {
        this.logger().trace((Function0 & Serializable)() -> "Received DistributedReleaseExecutedEvent event for Release [" + event.releaseId() + "]. Going to clear all permits for the release.");
        String rId = Ids.getName((String)event.releaseId());
        this.semaphores().remove(rId);
    }

    private Either<TaskJob<Object>, TaskJob<Object>> handleJob(LimitParallelJobSchedulerStrategySettings configuration, TaskJob<?> job) {
        boolean jobShouldBeDelayed = NonBlockingBackpressuredJobSchedulerStrategy$.MODULE$.shouldBeDelayed(configuration, job.taskId(), System.currentTimeMillis());
        if (jobShouldBeDelayed || this.isMaxJobThresholdReached(configuration, job)) {
            FiniteDuration delay = configuration.delayDuration();
            job.delay(delay);
            return package$.MODULE$.Left().apply(job);
        }
        return package$.MODULE$.Right().apply(job);
    }

    private boolean isMaxJobThresholdReached(LimitParallelJobSchedulerStrategySettings configuration, TaskJob<?> job) {
        String releaseId = this.getReleaseId(job.taskId());
        int maxJobThreshold = configuration.maxJobs();
        Semaphore releaseSemaphore = this.semaphores().computeIfAbsent(releaseId, x$1 -> new Semaphore(maxJobThreshold));
        boolean permitAvailable = releaseSemaphore.tryAcquire();
        this.logger().trace((Function0 & Serializable)() -> "PermitAvailable is " + permitAvailable + " for JobId [" + job.id() + "] with Release [" + releaseId + "]");
        return !permitAvailable;
    }

    private String getReleaseId(String taskId) {
        return Ids.getName((String)Ids.releaseIdFrom((String)taskId));
    }

    private LimitParallelJobSchedulerStrategy$() {
    }
}

