package com.xebialabs.xlrelease.views.tasks

import com.fasterxml.jackson.databind.annotation.{JsonDeserialize, JsonSerialize}
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity
import com.xebialabs.xlrelease.domain.status.{ReleaseStatus, TaskStatus}
import com.xebialabs.xlrelease.serialization.json.jackson.{DomainIdDeserializer, DomainIdSerializer}
import com.xebialabs.xlrelease.views.UserView

import java.util
import java.util.Date
import scala.beans.{BeanProperty, BooleanBeanProperty}

class TaskListRelease {
  @JsonSerialize(using = classOf[DomainIdSerializer])
  @JsonDeserialize(using = classOf[DomainIdDeserializer])
  @BeanProperty
  var id: String = _

  @BeanProperty
  var title: String = _

  @BeanProperty
  var status: ReleaseStatus = _

  @BeanProperty
  var tasks: util.List[TaskListReleaseTask] = new util.ArrayList[TaskListReleaseTask]()

  @BeanProperty
  var security: EffectiveSecurity = _

  @BooleanBeanProperty
  var archived: Boolean = false // UI needs archived for action links
}

class TaskListReleaseTask {
  @JsonSerialize(using = classOf[DomainIdSerializer])
  @JsonDeserialize(using = classOf[DomainIdDeserializer])
  @BeanProperty
  var id: String = _

  @BeanProperty
  var title: String = _

  @BeanProperty
  var scheduledStartDate: Date = _

  @BeanProperty
  var dueDate: Date = _

  @BeanProperty
  var startDate: Date = _

  @BeanProperty
  var endDate: Date = _

  @BeanProperty
  var `type`: String = _

  @BooleanBeanProperty
  var hasBeenStarted: Boolean = _ // Need this?

  @BooleanBeanProperty
  var updatable: Boolean = _ // Need this?

  @BooleanBeanProperty
  var active: Boolean = _ // Need this?

  @BooleanBeanProperty
  var done: Boolean = _ // Need this?

  @BeanProperty
  var plannedDuration: Long = _ // Need this

  @BeanProperty
  var owner: UserView = _

  @BeanProperty
  var team: String = _

  @BeanProperty
  var status: TaskStatus = _

  @BooleanBeanProperty
  var locked: Boolean = _

  @BeanProperty
  var color: String = _

  @BeanProperty
  var customIconLocation: String = _

  @BeanProperty
  var customIconClass: String = _

  @BooleanBeanProperty
  var editable: Boolean = _

  @JsonSerialize(using = classOf[DomainIdSerializer])
  @JsonDeserialize(using = classOf[DomainIdDeserializer])
  @BeanProperty
  var releaseId: String = _

  @BeanProperty
  var phaseTitle: String = _
}
