package com.xebialabs.xlrelease.actors

import com.esotericsoftware.kryo.Kryo
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

// mechanism so we can register custom serializers from other spring modules
abstract class KryoInitializers extends ScalaSpringAwareBean with KryoInitializer with Logging {
  @Autowired(required = false)
  private var kryoInitializers: Array[KryoInitializer] = _

  override def postInit(kryo: Kryo): Unit = {
    if (null != kryoInitializers) {
      kryoInitializers.sortBy(_.getOrder).foreach(_.postInit(kryo))
    }
  }
}


object KryoInitializers extends KryoInitializers {
  override def getOrder: Int = 0
}
