package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.repository.TaskRepository
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.{Set => JSet}

@Service
class TaskWatchersService @Autowired()(taskRepository: TaskRepository) {

  @Timed
  def addWatcher(taskId: String, watcher: String): JSet[String] = {
    val task: Task = taskRepository.findById(taskId)
    LockedTaskOperationChecks.checkAddWatcher(task)
    task.addWatcher(watcher)
    taskRepository.update(task)
    task.getWatchers
  }

  @Timed
  def removeWatcher(taskId: String, watcher: String): JSet[String] = {
    val task: Task = taskRepository.findById(taskId)
    LockedTaskOperationChecks.checkRemoveWatcher(task)
    task.removeWatcher(watcher)
    taskRepository.update(task)
    task.getWatchers
  }

  @Timed
  def updateWatchers(taskId: String, updatedWatchers: JSet[String]): JSet[String] = {
    val task: Task = taskRepository.findById(taskId)
    LockedTaskOperationChecks.checkUpdateWatchers(task)
    task.setWatchers(updatedWatchers)
    taskRepository.update(task)
    task.getWatchers
  }



}
