package com.xebialabs.xlrelease.actors.kryoserializers

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}
import com.xebialabs.xlrelease.script.{TaskSoftReference, TaskSoftReferenceFactory}
import com.xebialabs.xlrelease.service.{ReleaseService, ServiceStarter}
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean
import org.springframework.context.SmartLifecycle

object TaskSoftReferenceSerializer extends Serializer[TaskSoftReference[_]]
  with ScalaSpringAwareBean
  with SmartLifecycle {

  private lazy val releaseService: ReleaseService = springBean[ReleaseService]

  override def write(kryo: Kryo, output: Output, objectInstance: TaskSoftReference[_]): Unit = {
    kryo.writeObjectOrNull(output, objectInstance.getTaskId, classOf[String])
    kryo.writeObjectOrNull(output, objectInstance.getExecutionId, classOf[String])
    kryo.writeObjectOrNull(output, objectInstance.getReleaseCiUid, classOf[Integer])
    kryo.writeObjectOrNull(output, objectInstance.getCapabilities, classOf[java.util.HashSet[String]])
  }

  override def read(kryo: Kryo, input: Input, objectType: Class[_ <: TaskSoftReference[_]]): TaskSoftReference[_] = {
    val taskId = kryo.readObjectOrNull(input, classOf[String])
    val executionId = kryo.readObjectOrNull(input, classOf[String])
    val releaseCiUid = kryo.readObjectOrNull(input, classOf[Integer])
    val requiredCapabilities = kryo.readObjectOrNull(input, classOf[java.util.HashSet[String]])
    val ref = TaskSoftReferenceFactory.taskRef(releaseService, taskId, executionId, releaseCiUid)
    ref.setCapabilities(requiredCapabilities)
    ref
  }

  override def start(): Unit = ()

  override def stop(): Unit = ()

  override def isRunning: Boolean = true

  // make sure serializer has application context populated before we access it as a Scala object in KryoInit
  override def getPhase(): Int = ServiceStarter.LIFECYCLE_PHASE - 2

}
