package com.xebialabs.xlrelease.actors.extension

import org.apache.pekko.actor.{ActorSystem, Address, ExtendedActorSystem, Extension, ExtensionId, ExtensionIdProvider}

class AddressExtension(system: ExtendedActorSystem) extends Extension {
  def address: Address = system.provider.getDefaultAddress
}

object AddressExtension extends ExtensionId[AddressExtension] with ExtensionIdProvider {

  override def lookup(): ExtensionId[AddressExtension] = AddressExtension

  override def createExtension(system: ExtendedActorSystem): AddressExtension = new AddressExtension(system)

  // needed in order to get the right type when used from Java
  override def get(system: ActorSystem): AddressExtension = super.get(system)
}
