/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.plumbing.LogbackAccessSecurityAttributesSaveFilter;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Fields;

public class RequestWrapper
implements HttpServletRequest {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    Request request;
    StringBuffer requestURL;
    Map<String, String> headerMap;
    Map<String, String[]> parameterMap;

    RequestWrapper(Request request) {
        this.request = request;
        this.headerMap = this.buildRequestHeaderMap();
        this.parameterMap = this.buildRequestParameterMap();
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getHeader(String name) {
        return this.headerMap.get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(Set.of(this.headerMap.get(name)));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    public Map<String, String> buildRequestHeaderMap() {
        TreeMap<String, String> requestHeaderMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (HttpField f : this.request.getHeaders()) {
            requestHeaderMap.put(f.getName(), f.getValue());
        }
        return requestHeaderMap;
    }

    public int getIntHeader(String name) {
        return 0;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getQueryString() {
        return this.request.getHttpURI().getQuery();
    }

    public String getRemoteUser() {
        Object remoteUserAttributeValue = this.request.getAttribute(LogbackAccessSecurityAttributesSaveFilter.remoteUserAttribute());
        return remoteUserAttributeValue != null ? remoteUserAttributeValue.toString() : null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        HttpURI.Mutable mutable = HttpURI.build((HttpURI)this.request.getHttpURI());
        mutable.query(null);
        return mutable.asString();
    }

    public StringBuffer getRequestURL() {
        if (this.requestURL == null) {
            String result = this.request.getHttpURI().asString();
            this.requestURL = new StringBuffer(result);
        }
        return this.requestURL;
    }

    public String getServletPath() {
        return null;
    }

    public String getSessionID() {
        Session session = this.request.getSession(false);
        if (session == null) {
            return "-";
        }
        return session.getId();
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        Set attributeNamesSet = this.request.getAttributeNameSet();
        return Collections.enumeration(attributeNamesSet);
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return 0;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public Map<String, String[]> buildRequestParameterMap() {
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        Fields allParameters = Request.extractQueryParameters((Request)this.request, (Charset)StandardCharsets.UTF_8);
        for (Fields.Field field : allParameters) {
            results.put(field.getName(), field.getValues().toArray(EMPTY_STRING_ARRAY));
        }
        return results;
    }

    public String getParameter(String name) {
        String[] results = this.parameterMap.get(name);
        if (results != null) {
            int len = results.length;
            return len > 0 ? results[len - 1] : null;
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        throw new UnsupportedOperationException();
    }

    public String getProtocol() {
        return this.request.getConnectionMetaData().getProtocol();
    }

    public String getScheme() {
        return this.request.getHttpURI().getScheme();
    }

    public String getServerName() {
        return Request.getServerName((Request)this.request);
    }

    public int getServerPort() {
        return Request.getServerPort((Request)this.request);
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return Request.getRemoteAddr((Request)this.request);
    }

    public String getRemoteHost() {
        return Request.getRemoteAddr((Request)this.request);
    }

    public void setAttribute(String name, Object o) {
    }

    public void removeAttribute(String name) {
    }

    public Locale getLocale() {
        return (Locale)Request.getLocales((Request)this.request).get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Request.getLocales((Request)this.request));
    }

    public boolean isSecure() {
        return HttpScheme.HTTPS.is(this.request.getHttpURI().getScheme());
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public String getRequestId() {
        return this.request.getConnectionMetaData().getId() + "#" + this.request.getId();
    }

    public String getProtocolRequestId() {
        HttpVersion httpVersion = this.request.getConnectionMetaData().getHttpVersion();
        if (httpVersion == HttpVersion.HTTP_2 || httpVersion == HttpVersion.HTTP_3) {
            return this.request.getId();
        }
        return "-";
    }

    public ServletConnection getServletConnection() {
        return null;
    }
}

