package com.xebialabs.xlrelease.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;

@Service
public class SessionService {
    private final SessionRegistry sessionRegistry;

    private final CustomPersistentTokenRepository customPersistentTokenRepository;

    @Autowired
    public SessionService(SessionRegistry sessionRegistry, CustomPersistentTokenRepository customPersistentTokenRepository) {
        this.sessionRegistry = sessionRegistry;
        this.customPersistentTokenRepository = customPersistentTokenRepository;
    }

    public void disconnect(String username) {
        if (XlrConfig.getInstance().server_session_storage_enabled()) {
            // sessionRegistry.getAllPrincipals() is not supported by spring-session lib
            // sessionRegistry.getAllSessions finds all session from database in case of spring-session. See org.springframework.session.security.SpringSessionBackedSessionRegistry.getAllSessions.
            clearAllSessions(username);
        } else {
            var principals = sessionRegistry.getAllPrincipals();
            principals.stream()
                    .filter(p -> p instanceof AuthenticatedPrincipal)
                    .filter(ap -> ((AuthenticatedPrincipal) ap).getName().equalsIgnoreCase(username))
                    .forEach(this::clearAllSessions);
        }
        customPersistentTokenRepository.removeUserTokens(username);
    }

    private void clearAllSessions(Object principal) {
        for (SessionInformation session : sessionRegistry.getAllSessions(principal, false)) {
            session.expireNow();
        }
    }
}
