/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t-a\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011B/\t\u000b%\u0004A\u0011\u00016\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\u001e9\u0011Q`\f\t\u0002\u0005}hA\u0002\f\u0018\u0011\u0003\u0011\t\u0001\u0003\u0004U'\u0011\u0005!1\u0001\u0005\b\u0005\u000b\u0019B\u0011\u0001B\u0004\u0005]!\u0016m]6Fq\u0016\u001cW\u000f^5p]2{wmU3sm&\u001cWM\u0003\u0002\u00193\u0005!An\\4t\u0015\tQ2$A\u0005tG\",G-\u001e7fe*\u0011A$H\u0001\nq2\u0014X\r\\3bg\u0016T!AH\u0010\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQa\u001d7gi)T\u0011AL\u0001\tOJL'P\u001f7fI&\u0011\u0001g\u000b\u0002\b\u0019><w-\u001b8h\u0003=\u0019\bO]5oO\u0016CH/\u001a8tS>t\u0007CA\u001a;\u001b\u0005!$BA\u001b7\u0003\u0019\u0019\bO]5oO*\u0011q\u0007O\u0001\u0006a\u0016\\7n\u001c\u0006\u0003sm\tqa];qa>\u0014H/\u0003\u0002<i\ty1\u000b\u001d:j]\u001e,\u0005\u0010^3og&|g.\u0001\tce>\fGmY1tiN+'O^5dKB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iG\u0001\bg\u0016\u0014h/[2f\u0013\t\u0011uH\u0001\tCe>\fGmY1tiN+'O^5dK\u0006q1\u000f^8sC\u001e,7+\u001a:wS\u000e,\u0007CA#J\u001b\u00051%B\u0001!H\u0015\tA5$A\u0004ti>\u0014\u0018mZ3\n\u0005)3%AD*u_J\fw-Z*feZL7-Z\u0001\fi\u0006\u001c8nU3sm&\u001cW\r\u0005\u0002?\u001b&\u0011aj\u0010\u0002\f)\u0006\u001c8nU3sm&\u001cW-A\fuCN\\W\t_3dkRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0011KU\u0007\u0002/%\u00111k\u0006\u0002\u0018)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8SKB|7/\u001b;pef\fa\u0001P5oSRtDC\u0002,X1fS6\f\u0005\u0002R\u0001!)\u0011G\u0002a\u0001e!)AH\u0002a\u0001{!)1I\u0002a\u0001\t\")1J\u0002a\u0001\u0019\")qJ\u0002a\u0001!\u0006YR\r_3dkRLwN\u001c'pO^\u000bGo\u00195fe\u0006\u001bGo\u001c:SK\u001a,\u0012A\u0018\t\u0003?\u001el\u0011\u0001\u0019\u0006\u0003C\n\fQ!Y2u_JT!aN2\u000b\u0005\u0011,\u0017AB1qC\u000eDWMC\u0001g\u0003\ry'oZ\u0005\u0003Q\u0002\u0014\u0001\"Q2u_J\u0014VMZ\u0001\u0006o\u0006$8\r\u001b\u000b\u0004W:\\\bC\u0001\u0013m\u0013\tiWE\u0001\u0003V]&$\b\"B8\t\u0001\u0004\u0001\u0018A\u0002;bg.LE\r\u0005\u0002rq:\u0011!O\u001e\t\u0003g\u0016j\u0011\u0001\u001e\u0006\u0003k\u0006\na\u0001\u0010:p_Rt\u0014BA<&\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005],\u0003\"\u0002?\t\u0001\u0004\u0001\u0018aC3yK\u000e,H/[8o\u0013\u0012\f\u0011b\u001d;pa^\u000bGo\u00195\u0015\u0005-|\b\"\u0002?\n\u0001\u0004\u0001\u0018!\u00024fi\u000eDGcC6\u0002\u0006\u0005\u001d\u0011\u0011BA\u000f\u0003\u0017BQa\u001c\u0006A\u0002ADQ\u0001 \u0006A\u0002ADq!a\u0003\u000b\u0001\u0004\ti!\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0005%|'BAA\f\u0003\u0011Q\u0017M^1\n\t\u0005m\u0011\u0011\u0003\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003?Q\u0001\u0019AA\u0011\u0003\u001da\u0017m\u001d;K_\n\u0004B!a\t\u0002F9!\u0011QEA \u001d\u0011\t9#!\u000f\u000f\t\u0005%\u0012Q\u0007\b\u0005\u0003W\t\u0019D\u0004\u0003\u0002.\u0005EbbA:\u00020%\t\u0001%\u0003\u0002\u001f?%\u0011A$H\u0005\u0004\u0003oY\u0012A\u0002:v]:,'/\u0003\u0003\u0002<\u0005u\u0012A\u00023p[\u0006LgNC\u0002\u00028mIA!!\u0011\u0002D\u00059\u0001/Y2lC\u001e,'\u0002BA\u001e\u0003{IA!a\u0012\u0002J\t)!j\u001c2JI*!\u0011\u0011IA\"\u0011\u001d\tiE\u0003a\u0001\u0003\u001f\n\u0011\u0002\\1ti\u000eCWO\\6\u0011\u0007\u0011\n\t&C\u0002\u0002T\u0015\u0012A\u0001T8oO\u0006!\u0001o\u001c8h)\rY\u0017\u0011\f\u0005\u0006y.\u0001\r\u0001]\u0001\u0013M\u0016$8\r[!mY\u0016CXmY;uS>t7\u000f\u0006\u0003\u0002`\u0005]\u0004CBA1\u0003O\nY'\u0004\u0002\u0002d)!\u0011QMA\u000b\u0003\u0011)H/\u001b7\n\t\u0005%\u00141\r\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\thG\u0001\u0006m&,wo]\u0005\u0005\u0003k\nyG\u0001\u000bUCN\\W\t_3dkRLwN\u001c'pOZKWm\u001e\u0005\u0006_2\u0001\r\u0001]\u0001\u0004Y><GcA6\u0002~!9\u0011qP\u0007A\u0002\u0005\u0005\u0015\u0001\u00037pO\u0016sGO]=\u0011\t\u0005\r\u0015qQ\u0007\u0003\u0003\u000bS1!a\u000fH\u0013\u0011\tI)!\"\u0003\u00111{w-\u00128uef\fQcZ3u)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]R\u0014\u0018\u0010\u0006\u0004\u0002\u0010\u0006m\u0015Q\u0014\t\u0006I\u0005E\u0015QS\u0005\u0004\u0003'+#AB(qi&|g\u000eE\u0002R\u0003/K1!!'\u0018\u0005I!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sGO]=\t\u000b=t\u0001\u0019\u00019\t\u000bqt\u0001\u0019\u00019\u0002\u001b=t'j\u001c2GS:L7\u000f[3e)\rY\u00171\u0015\u0005\b\u0003K{\u0001\u0019AAT\u0003\u0015)g/\u001a8u!\u0011\tI+a,\u000e\u0005\u0005-&bAAW3\u00051QM^3oiNLA!!-\u0002,\n\u0001\"j\u001c2GS:L7\u000f[3e\u000bZ,g\u000e\u001e\u0015\u0004\u001f\u0005U\u0006\u0003BA\\\u0003wk!!!/\u000b\u0007\u000556$\u0003\u0003\u0002>\u0006e&!C*vEN\u001c'/\u001b2f\u0003Ayg\u000eV1tW2{wm\u0011:fCR,G\rF\u0002l\u0003\u0007Dq!!2\u0011\u0001\u0004\t9-\u0001\u0007uCN\\Gj\\4Fm\u0016tG\u000fE\u0002R\u0003\u0013L1!a3\u0018\u00059!\u0016m]6M_\u001e\u001c%/Z1uK\u0012D3\u0001EA[\u0003Myg\u000eV1tW\u0016CXmY;uS>tGi\u001c8f)\rY\u00171\u001b\u0005\b\u0003K\u000b\u0002\u0019AAk!\u0011\t9.!8\u000e\u0005\u0005e'\u0002BAW\u00037T1!a\u000f\u001c\u0013\u0011\ty.!7\u0003)Q\u000b7o\u001b&pE\u0016CXmY;uK\u0012,e/\u001a8uQ\r\t\u0012Q\u0017\u0015\u0004\u0001\u0005\u0015\b\u0003BAt\u0003cl!!!;\u000b\t\u0005-\u0018Q^\u0001\u000bgR,'/Z8usB,'bAAxK\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002t\u0006%(aB*feZL7-\u001a\u0015\u0004\u0001\u0005]\b\u0003BA\\\u0003sLA!a?\u0002:\niQI^3oi2K7\u000f^3oKJ\fq\u0003V1tW\u0016CXmY;uS>tGj\\4TKJ4\u0018nY3\u0011\u0005E\u001b2CA\n$)\t\ty0\u0001\u0003iCNDGc\u00019\u0003\n!)q.\u0006a\u0001a\u0002")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private final SpringExtension springExtension;
    private final BroadcastService broadcastService;
    private final StorageService storageService;
    private final TaskService taskService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String hash(String taskId) {
        return TaskExecutionLogService$.MODULE$.hash(taskId);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        if (!this.bitmap$0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    public void watch(String taskId, String executionId) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, User.AUTHENTICATED_USER.getName());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void stopWatch(String executionId) {
        ExecutionLogWatchActor.StopWatching x$1 = new ExecutionLogWatchActor.StopWatching(executionId, (Option<String>)new Some((Object)User.AUTHENTICATED_USER.getName()));
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public void pong(String executionId) {
        ExecutionLogWatchActor.Pong x$1 = new ExecutionLogWatchActor.Pong(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                Option$.MODULE$.apply((Object)row.endDate()).foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        String x$1 = "xlr-local";
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, "xlr-local");
        URI storedEntryUri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskStatus taskStatus = this.taskService.getStatus(logEntry.taskId());
        this.logger().debug((Function0 & Serializable)() -> "Adding log entry: " + logEntry + ", with task status: " + taskStatus);
        Option<TaskExecutionEntry> option = taskStatus.isOneOf(new TaskStatus[]{TaskStatus.COMPLETED, TaskStatus.SKIPPED, TaskStatus.ABORTED, TaskStatus.FAILED, TaskStatus.FAILING, TaskStatus.ABORT_SCRIPT_IN_PROGRESS, TaskStatus.FAILURE_HANDLER_IN_PROGRESS}) ? this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)new Some((Object)Instant.now()))) : this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)None$.MODULE$));
        this.broadcastService.broadcast(new TaskLogCreated(logEntry.taskId(), logEntry.executionId(), storedEntryUri), true);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uri());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        TaskExecutionRepository.FinishExecution finishExecution = new TaskExecutionRepository.FinishExecution(event.taskId(), event.executionId(), Instant.now());
        this.taskExecutionRepository.update(finishExecution);
    }

    public TaskExecutionLogService(SpringExtension springExtension, BroadcastService broadcastService, StorageService storageService, TaskService taskService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.broadcastService = broadcastService;
        this.storageService = storageService;
        this.taskService = taskService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

