package com.xebialabs.xlrelease.license

import com.xebialabs.license._
import com.xebialabs.license.service.{LicenseInstallServiceImpl, LicenseService}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent
import com.xebialabs.xlrelease.repository.LicenseRepository
import com.xebialabs.xlrelease.service.BroadcastService
import org.springframework.beans.factory.annotation.Autowired

case class LicenseRenewEvent() extends DistributedXLReleaseEvent

class XLRLicenseInstallService @Autowired()(broadcastService: BroadcastService,
                                            licenseService: LicenseService,
                                            licenseRepository: LicenseRepository)
  extends LicenseInstallServiceImpl(XlrConfig.getInstance.license_location, licenseService) {

  override def installNewLicense(licenseText: String): License = {
    val lic = install(licenseText)
    storeInDB(licenseText)
    broadcastLicenseRenewal()
    lic
  }

  def install(licenseText: String): License = {
    // this will write the license to node's filesystem
    // currently there's no easy way of getting around this without refactoring license services in platform
    val license = super.installNewLicense(licenseText)
    license
  }

  def broadcastLicenseRenewal(): Unit = {
    // signal to all other nodes to pull license from DB and reinstall in their memory
    broadcastService.broadcast(LicenseRenewEvent(), publishEventOnSelf = false)
  }

  def storeInDB(licenseText: String): Unit = {
    licenseRepository.createOrUpdate(licenseText)
  }

  def findLicenseInDB(): Option[String] = {
    licenseRepository.find()
  }
}

