package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.service.UiExtensionsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import jakarta.ws.rs.core.Response
import jakarta.ws.rs.{GET, Path, Produces}

@Path("/ui-extensions")
@Controller
class UiExtensionsResource @Autowired()(val uiExtensionsService: UiExtensionsService) {

  @GET
  @Path("xlrelease-module.js")
  @Produces(Array("application/javascript"))
  def getDependenciesJs = Response.ok(uiExtensionsService.getXlReleaseModuleJs).build

  @GET
  @Path("xlrelease-plugins.js")
  @Produces(Array("application/javascript"))
  def getPluginJavascript = Response.ok(uiExtensionsService.getAllJs).build

  @GET
  @Path("xlrelease-plugins.css")
  @Produces(Array("text/css"))
  def getPluginCss = Response.ok(uiExtensionsService.getAllCss).build
}
