package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.config.XlrConfig;

@Component
public class CsrfFilterPostProcessor implements BeanPostProcessor, Ordered {

    @Override
    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        if (!XlrConfig.getInstance().server_http_csrf_enabled() && bean instanceof DefaultSecurityFilterChain) {
            ((DefaultSecurityFilterChain) bean).getFilters().removeIf(f -> f instanceof CsrfFilter);
        }
        return bean;
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}

