/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.DescriptorJsonWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class DescriptorsJsonWriter
implements MessageBodyWriter<Collection<Descriptor>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = AbstractConfigurationItemReaderWriter.getClassFromGenericType(genericType);
        }
        return Descriptor.class.isAssignableFrom(type);
    }

    public long getSize(Collection<Descriptor> descriptors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<Descriptor> descriptors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(descriptors).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<Descriptor> descriptors) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.array();
        for (Descriptor descriptor : descriptors) {
            new DescriptorJsonWriter().writeJson(descriptor, writer);
        }
        writer.endArray();
        return stringWriter.toString();
    }
}

