package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Database troubleshooting",
  description = "With query logging turned on, database queries that take longer " +
    "than a specified time are logged in the server log to facilitate database optimization.")
class DatabaseProxyFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable long SQL query logging", category = "input", defaultValue = "false")
  var enableStatementLog: Boolean = _

  @BeanProperty
  @XLProperty(
    label = "Query execution duration longer than",
    description = "Log SQL query that takes longer than the given threshold value",
    category = "input",
    defaultValue = "2000")
  @validation.Range(minimum = 0)
  var executionThresholdMs: Integer = _

  @BeanProperty
  @XLProperty(label = "Enable SQL query parameters logging", category = "input", defaultValue = "false")
  var logParameters: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "database", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "0", hidden = true)
  var weight: Integer = _

}
