package com.xebialabs.xlrelease.spring.configuration;

import jakarta.servlet.MultipartConfigElement;
import org.springframework.beans.factory.BeanFactory;

public class DeferredMultipartConfigElement extends MultipartConfigElement {

    private final BeanFactory context;
    private MultipartConfigElement _delegate;

    DeferredMultipartConfigElement(BeanFactory context) {
        super("");
        this.context = context;
    }

    private MultipartConfigElement delegate() {
        if (null == _delegate) {
            _delegate = context.getBeanProvider(MultipartConfigElement.class).getIfAvailable();
        }
        if (_delegate == null) {
            throw new IllegalStateException("MultipartConfigElement bean not available.");
        }
        return _delegate;
    }

    @Override
    public String getLocation() {
        return delegate().getLocation();
    }

    @Override
    public long getMaxFileSize() {
        return delegate().getMaxFileSize();
    }

    @Override
    public long getMaxRequestSize() {
        return delegate().getMaxRequestSize();
    }

    @Override
    public int getFileSizeThreshold() {
        return delegate().getFileSizeThreshold();
    }
}
