/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.UserTokenPermission;
import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokensDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003E\u0001\u0011\u0005Q\tC\u0003x\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA9\u0001\u0011%\u00111\u000f\u0002\u0011+N,'\u000fV8lK:\u001cVM\u001d<jG\u0016T!!\u0005\n\u0002\u000fM,'O^5dK*\u00111\u0003F\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQa\u001d7gi)T\u0011!J\u0001\tOJL'P\u001f7fI&\u0011qE\t\u0002\b\u0019><w-\u001b8h\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0013\u0003\u0019)g/\u001a8ug&\u0011af\u000b\u0002\t\u000bZ,g\u000e\u001e\"vg\u0006\u0019Ro]3s)>\\WM\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0007N\u0007\u0002e)\u00111GE\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001b3\u0005M)6/\u001a:U_.,gNU3q_NLGo\u001c:z\u0003i\u0001XM]:p]\u0006d\u0017iY2fgN$vn[3o\r\u0016\fG/\u001e:f!\tA4(D\u0001:\u0015\tQ$#\u0001\u0005gK\u0006$XO]3t\u0013\ta\u0014H\u0001\u000eQKJ\u001cxN\\1m\u0003\u000e\u001cWm]:U_.,gNR3biV\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0005\u007f\u0005\u00135\t\u0005\u0002A\u00015\t\u0001\u0003C\u0003)\t\u0001\u0007\u0011\u0006C\u00030\t\u0001\u0007\u0001\u0007C\u00037\t\u0001\u0007q'A\bde\u0016\fG/Z+tKJ$vn[3o)\u00151E*W.f!\t9%*D\u0001I\u0015\tI%#\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u0017\"\u0013\u0011\"V:feR{7.\u001a8\t\u000b5+\u0001\u0019\u0001(\u0002\u0011U\u001cXM\u001d8b[\u0016\u0004\"a\u0014,\u000f\u0005A#\u0006CA)\u001d\u001b\u0005\u0011&BA*\u0019\u0003\u0019a$o\\8u}%\u0011Q\u000bH\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V9!)!,\u0002a\u0001\u001d\u0006IAo\\6f]:{G/\u001a\u0005\u00069\u0016\u0001\r!X\u0001\u000bKb\u0004\u0018N]=ECR,\u0007C\u00010d\u001b\u0005y&B\u00011b\u0003\u0011)H/\u001b7\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0005\t\u0006$X\rC\u0003g\u000b\u0001\u0007q-A\thY>\u0014\u0017\r\u001c)fe6L7o]5p]N\u00042a\u00145O\u0013\tI\u0007LA\u0002TKRD#!B6\u0011\u00051,X\"A7\u000b\u00059|\u0017AC1o]>$\u0018\r^5p]*\u0011\u0001/]\u0001\u0005G>\u0014XM\u0003\u0002sg\u0006QQ.[2s_6,G/\u001a:\u000b\u0003Q\f!![8\n\u0005Yl'!\u0002+j[\u0016$\u0017a\u00043fY\u0016$X-V:feR{7.\u001a8\u0015\u0005ed\bCA\u000e{\u0013\tYHD\u0001\u0003V]&$\b\"B?\u0007\u0001\u00041\u0015!C;tKJ$vn[3oQ\t11.\u0001\neK2,G/Z!mYV\u001bXM\u001d+pW\u0016tGcA=\u0002\u0004!)Qj\u0002a\u0001\u001d\"\u0012qa[\u0001\u0005M&tG\r\u0006\u0004\u0002\f\u0005\u0005\u00121\u0005\t\u0006\u0003\u001b\tiBR\u0007\u0003\u0003\u001fQ1!SA\t\u0015\u0011\t\u0019\"!\u0006\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003/\tI\"A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY\"A\u0002pe\u001eLA!a\b\u0002\u0010\t!\u0001+Y4f\u0011\u0015i\u0005\u00021\u0001O\u0011\u001d\t)\u0003\u0003a\u0001\u0003O\t\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003\u001b\tI#\u0003\u0003\u0002,\u0005=!\u0001\u0003)bO\u0016\f'\r\\3)\u0005!Y\u0017a\u00034j]\u0012\u0014\u0015pQ5VS\u0012$B!a\r\u0002:A!1$!\u000eG\u0013\r\t9\u0004\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005m\u0012\u00021\u0001\u0002>\u0005)1-[+jIB!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\u0005\fA\u0001\\1oO&!\u0011qIA!\u0005\u001dIe\u000e^3hKJD#!C6\u0002\u001f\u0019Lg\u000e\u001a\"z+N,'\u000fV8lK:$B!a\r\u0002P!1\u0011\u0011\u000b\u0006A\u00029\u000b\u0011\u0002^8lK:D\u0015m\u001d5)\u0005)Y\u0017!\u00078pi&4\u0017\u0010V8lK:\u001c\u0018IY8viR{W\t\u001f9je\u0016$\u0012!\u001f\u0015\u0003\u0017-\fq\"^:feR{7.\u001a8Fq&\u001cHo\u001d\u000b\u0007\u0003?\n)'a\u001a\u0011\u0007m\t\t'C\u0002\u0002dq\u0011qAQ8pY\u0016\fg\u000eC\u0003N\u0019\u0001\u0007a\nC\u0003[\u0019\u0001\u0007a\n\u000b\u0002\rW\u0006\u0001b/\u00197jI\u0006$X\rR;sCRLwN\u001c\u000b\u0004s\u0006=\u0004\"\u0002/\u000e\u0001\u0004i\u0016\u0001\u00079vE2L7\u000f\u001b+pW\u0016t7I]3bi\u0016$WI^3oiR\u0019\u00110!\u001e\t\u000but\u0001\u0019\u0001$")
public class UserTokenService
implements Logging {
    private final EventBus eventBus;
    private final UserTokenRepository userTokenRepository;
    private final PersonalAccessTokenFeature personalAccessTokenFeature;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenService userTokenService = this;
        synchronized (userTokenService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public UserToken createUserToken(String username, String tokenNote, Date expiryDate, scala.collection.immutable.Set<String> globalPermissions) {
        this.validateDuration(expiryDate);
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RPA());
        UserToken userToken = new UserToken();
        userToken.tokenNote_$eq(tokenNote);
        userToken.username_$eq(username);
        userToken.createdDate_$eq(new Date());
        if (expiryDate == null) {
            userToken.expiryDate_$eq(expiryDate);
        } else {
            LocalDateTime localExpiryDate = expiryDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            userToken.expiryDate_$eq(Date.from(localExpiryDate.atZone(ZoneId.systemDefault()).toInstant()));
        }
        UserTokenPermission userTokenPermission = (UserTokenPermission)Type.valueOf(UserTokenPermission.class).getDescriptor().newInstance(null);
        if (globalPermissions != null && globalPermissions.nonEmpty()) {
            userTokenPermission.globalPermissions_$eq(CollectionConverters$.MODULE$.SetHasAsJava((Set)globalPermissions.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PlatformPermissions.LOGIN.getPermissionName()})))).asJava());
        }
        userToken.userTokenPermission_$eq(userTokenPermission);
        Integer ciUid = this.userTokenRepository.create(userToken, TokenGenerator$.MODULE$.hash(token));
        userToken.ciUid_$eq(ciUid);
        userToken.token_$eq(token);
        this.publishTokenCreatedEvent(userToken);
        return userToken;
    }

    @Timed
    public void deleteUserToken(UserToken userToken) {
        this.userTokenRepository.delete(userToken.ciUid());
        this.eventBus.publish((XLReleaseEvent)new UserTokenDeletedEvent(userToken));
    }

    @Timed
    public void deleteAllUserToken(String username) {
        if (Strings.isNotBlank((String)username)) {
            this.userTokenRepository.delete(username);
            this.eventBus.publish((XLReleaseEvent)new UserTokensDeletedEvent(username));
            return;
        }
        throw new IllegalArgumentException("Username can't be blank");
    }

    @Timed
    public Page<UserToken> find(String username, Pageable pageable) {
        return this.userTokenRepository.query(new UserTokenRepository.ByUsername(username), pageable);
    }

    @Timed
    public Option<UserToken> findByCiUid(Integer ciUid) {
        return this.userTokenRepository.findByCiUid(ciUid);
    }

    @Timed
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.userTokenRepository.findByUserToken(tokenHash);
    }

    @Timed
    public void notifyTokensAboutToExpire() {
        LocalDateTime localTime = Instant.now().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX).plusDays(1L);
        Date expiryDate = Date.from(localTime.atZone(ZoneId.systemDefault()).toInstant());
        Buffer tokensAboutToExpire = CollectionConverters$.MODULE$.ListHasAsScala(this.userTokenRepository.query(new UserTokenRepository.TokensAboutToExpire(expiryDate), (Pageable)PageRequest.ofSize((int)1024)).getContent()).asScala();
        tokensAboutToExpire.foreach((Function1 & Serializable)userToken -> {
            UserTokenService.$anonfun$notifyTokensAboutToExpire$1(this, userToken);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public boolean userTokenExists(String username, String tokenNote) {
        Option<UserToken> option = this.userTokenRepository.findByUserAndNote(username, tokenNote);
        if (option instanceof Some) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was found with user[" + username + "] and note[" + tokenNote + "]");
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was not found with user[" + username + "] and note[" + tokenNote + "]");
            return false;
        }
        throw new MatchError(option);
    }

    private void validateDuration(Date expiryDate) {
        boolean noPresetExpirationLimit;
        int maximumPresetExpirationDays = this.personalAccessTokenFeature.maxTokenExpiry();
        boolean bl = noPresetExpirationLimit = maximumPresetExpirationDays == -1;
        if (!noPresetExpirationLimit) {
            boolean tokenReqExceedsPresetExpirationLimit;
            LocalDateTime today = new Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            Date maximumExpiryDate = Date.from(today.plusDays(maximumPresetExpirationDays).atZone(ZoneId.systemDefault()).toInstant());
            boolean tokenReqHasExpiryDate = expiryDate != null;
            boolean tokenReqExceedsMaximumExpiryDate = tokenReqHasExpiryDate && expiryDate.after(maximumExpiryDate);
            boolean tokenReqIsNonExpiringButNotAllowed = !tokenReqHasExpiryDate && !noPresetExpirationLimit;
            boolean bl2 = tokenReqExceedsPresetExpirationLimit = tokenReqExceedsMaximumExpiryDate || tokenReqIsNonExpiringButNotAllowed;
            if (tokenReqExceedsPresetExpirationLimit) {
                throw new IllegalArgumentException("Personal access token expiration cannot exceed " + maximumPresetExpirationDays + " days.");
            }
            return;
        }
    }

    private void publishTokenCreatedEvent(UserToken userToken) {
        UserToken userTokenForEvent = CiCloneHelper.cloneCi(userToken);
        userTokenForEvent.token_$eq(PasswordVerificationUtils$.MODULE$.PASSWORD_MASK());
        this.eventBus.publish((XLReleaseEvent)new UserTokenCreatedEvent(userTokenForEvent));
    }

    public static final /* synthetic */ void $anonfun$notifyTokensAboutToExpire$1(UserTokenService $this, UserToken userToken) {
        $this.eventBus.publish((XLReleaseEvent)new UserTokenAboutToExpireEvent(userToken));
        $this.userTokenRepository.updateTokenExpiredNotified(userToken.ciUid());
    }

    public UserTokenService(EventBus eventBus, UserTokenRepository userTokenRepository, PersonalAccessTokenFeature personalAccessTokenFeature) {
        this.eventBus = eventBus;
        this.userTokenRepository = userTokenRepository;
        this.personalAccessTokenFeature = personalAccessTokenFeature;
        Logging.$init$((Logging)this);
    }
}

