package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Script engine options",
  description = "Flags to control the script engine lifecycle."
)
class ScriptEngineFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable reload of Jython and Groovy engines",
    description = "Recycle the engines to remove references to cached script classes and class loaders",
    category = "input",
    defaultValue = "false")
  var enableEngineReload: Boolean = false

  @BeanProperty
  @XLProperty(label = "Reload interval",
    description = "Recycle the script engines on all nodes at the given interval in minutes",
    category = "input",
    defaultValue = "60")
  var reloadInterval: Integer = 60

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @XLProperty(defaultValue = "42", hidden = true)
  var weight: Integer = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings.html", hidden = true)
  var documentationPage: String = _
}
