/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePermissionsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlrelease.api.v1.filters.RolePrincipalsFilters;
import com.xebialabs.xlrelease.domain.events.GlobalRolesOrPermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.ReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.security.RolePermission;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001B\f\u0019\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\ty\u000b\u0001C!\u0003cCq!!0\u0001\t\u0003\ny\fC\u0004\u0002j\u0002!\t%a;\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9!1\u0003\u0001\u0005B\tU\u0001b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013BqA!\u0016\u0001\t\u0013\u00119FA\rEK\u001a\fW\u000f\u001c;SK2,\u0017m]3S_2,7+\u001a:wS\u000e,'BA\r\u001b\u0003!\u0019XmY;sSRL(BA\u000e\u001d\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001e=\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tI#&D\u0001\u0019\u0013\tY\u0003D\u0001\nSK2,\u0017m]3S_2,7+\u001a:wS\u000e,\u0017!\u0005=m%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vgB\u0011a&M\u0007\u0002_)\u0011\u0001GG\u0001\u0007KZ,g\u000e^:\n\u0005Iz#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006Y1-[%e'\u0016\u0014h/[2f!\t)\u0004(D\u00017\u0015\t9$$A\u0004tKJ4\u0018nY3\n\u0005e2$aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fQC]3mK\u0006\u001cXMU8mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002*y%\u0011Q\b\u0007\u0002\u0016%\u0016dW-Y:f%>dWMU3q_NLGo\u001c:z\u0003}\u0011X\r\\3bg\u0016\u0014v\u000e\\3QKJl\u0017n]:j_:\u0014V\r]8tSR|'/\u001f\t\u0003S\u0001K!!\u0011\r\u0003?I+G.Z1tKJ{G.\u001a)fe6L7o]5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0006\t\u00163u\t\u0013\t\u0003S\u0001AQ\u0001L\u0003A\u00025BQaM\u0003A\u0002QBQAO\u0003A\u0002mBQAP\u0003A\u0002}\nabZ3u\u000f2|'-\u00197S_2,7\u000f\u0006\u0003L5\u001e\u001c\bc\u0001'R'6\tQJ\u0003\u0002O\u001f\u0006!Q\u000f^5m\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\t1K7\u000f\u001e\t\u0003)bk\u0011!\u0016\u0006\u00033YS!a\u0016\u000f\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!W+\u0003\tI{G.\u001a\u0005\u00067\u001a\u0001\r\u0001X\u0001\fe>dW\rU1ui\u0016\u0014h\u000e\u0005\u0002^I:\u0011aL\u0019\t\u0003?\u0012j\u0011\u0001\u0019\u0006\u0003C\u0002\na\u0001\u0010:p_Rt\u0014BA2%\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r$\u0003\"\u00025\u0007\u0001\u0004I\u0017A\u00029bO&tw\r\u0005\u0002kc6\t1N\u0003\u0002m[\u0006\u0019A\r^8\u000b\u00059|\u0017aA1qS*\u0011\u0001OV\u0001\u0007K:<\u0017N\\3\n\u0005I\\'A\u0002)bO&tw\rC\u0003u\r\u0001\u0007Q/A\u0003pe\u0012,'\u000f\u0005\u0002km&\u0011qo\u001b\u0002\t\u001fJ$WM]5oO\"\u0012a!\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018AC1o]>$\u0018\r^5p]*\u0011ap`\u0001\b[\u0016$(/[2t\u0015\r\t\tAH\u0001\tG>$\u0017\r[1mK&\u0019\u0011QA>\u0003\u000bQKW.\u001a3\u00027\u001d,Go\u00127pE\u0006d'k\u001c7f!JLgnY5qC24\u0016.Z<t)\u0019\tY!a\f\u0002DA1\u0011QBA\u0010\u0003Gi!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0007I>l\u0017-\u001b8\u000b\t\u0005U\u0011qC\u0001\u0005I\u0006$\u0018M\u0003\u0003\u0002\u001a\u0005m\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005u\u0011aA8sO&!\u0011\u0011EA\b\u0005\u0011\u0001\u0016mZ3\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u001b\u0003\u00151\u0018.Z<t\u0013\u0011\ti#a\n\u0003%I{G.\u001a)sS:\u001c\u0017\u000e]1mgZKWm\u001e\u0005\b\u0003c9\u0001\u0019AA\u001a\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003c\tID\u0003\u0003\u0002<\u0005u\u0012A\u0001<2\u0015\tq'$\u0003\u0003\u0002B\u0005]\"!\u0006*pY\u0016\u0004&/\u001b8dSB\fGn\u001d$jYR,'o\u001d\u0005\b\u0003\u000b:\u0001\u0019AA$\u0003!\u0001\u0018mZ3bE2,\u0007\u0003BA\u0007\u0003\u0013JA!a\u0013\u0002\u0010\tA\u0001+Y4fC\ndW\r\u000b\u0002\bs\u000611M]3bi\u0016$b!a\u0015\u0002Z\u0005u\u0003cA\u0012\u0002V%\u0019\u0011q\u000b\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u00037B\u0001\u0019\u0001/\u0002'=t7i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\t\u000f\u0005}\u0003\u00021\u0001\u0002b\u0005)!o\u001c7fgB!1%a\u0019T\u0013\r\t)\u0007\n\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\u0005\u0002jA!\u00111NA8\u001b\t\tiG\u0003\u0002}I%!\u0011\u0011OA7\u0005\u001d1\u0018M]1sOND#\u0001C=\u0002\rU\u0004H-\u0019;f)\u0019\t\u0019&!\u001f\u0002|!1\u00111L\u0005A\u0002qCq!a\u0018\n\u0001\u0004\t\t\u0007K\u0002\n\u0003SB#!C=\u0002!I,g.Y7f\u000f2|'-\u00197S_2,GCBA*\u0003\u000b\u000bI\t\u0003\u0004\u0002\b*\u0001\r\u0001X\u0001\b_2$g*Y7f\u0011\u0019\tYI\u0003a\u00019\u00069a.Z<OC6,\u0007F\u0001\u0006z\u0003A!W\r\\3uK\u001ecwNY1m%>dW\r\u0006\u0003\u0002T\u0005M\u0005BBAK\u0017\u0001\u0007A,\u0001\u0005s_2,g*Y7fQ\tY\u00110A\u0007hKR<En\u001c2bYJ{G.\u001a\u000b\u0005\u0003;\u000b\u0019\u000b\u0005\u0003$\u0003?\u001b\u0016bAAQI\t1q\n\u001d;j_:Da!!&\r\u0001\u0004a\u0006F\u0001\u0007z\u0003m9W\r^$m_\n\fGNU8mKB\u0013\u0018N\\2ja\u0006d7OV5foR!\u00111EAV\u0011\u0019\t)*\u0004a\u00019\"\u0012Q\"_\u0001\u0011O2|'-\u00197S_2,W\t_5tiN$B!a-\u0002:B\u00191%!.\n\u0007\u0005]FEA\u0004C_>dW-\u00198\t\r\u0005Ue\u00021\u0001]Q\tq\u00110\u0001\u0012de\u0016\fG/Z$m_\n\fGNU8mK\u0006sGMU8mKB+'/\\5tg&|gn\u001d\u000b\u0005\u0003'\n\t\rC\u0004\u0002D>\u0001\r!!2\u0002\u0011I,\u0017/^3tiN\u0004RaIA2\u0003\u000f\u0004B!!3\u0002`:!\u00111ZAn\u001d\u0011\ti-!7\u000f\t\u0005=\u0017q\u001b\b\u0005\u0003#\f)ND\u0002`\u0003'L\u0011aH\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012bAAo1\u0005\u0011\"+\u001a7fCN,'k\u001c7f'\u0016\u0014h/[2f\u0013\u0011\t\t/a9\u0003#I{G.Z\"sK\u0006$XMU3rk\u0016\u001cHOC\u0002\u0002^bA3aDA5Q\ty\u00110\u0001\u0012va\u0012\fG/Z$m_\n\fGNU8mK\u0006sGMU8mKB+'/\\5tg&|gn\u001d\u000b\u0005\u0003'\ni\u000fC\u0004\u0002DB\u0001\r!a<\u0011\u000b\r\n\u0019'!=\u0011\t\u0005%\u00171_\u0005\u0005\u0003k\f\u0019OA\tS_2,W\u000b\u001d3bi\u0016\u0014V-];fgRD3\u0001EA5Q\t\u0001\u00120\u0001\rhKR<En\u001c2bYJ{G.\u001a)fe6L7o]5p]N$B!a@\u0003\u0006A!\u0011\u0011\u001aB\u0001\u0013\u0011\u0011\u0019!a9\u0003+\u001dcwNY1m%>dW\rU3s[&\u001c8/[8og\"9!qA\tA\u0002\t%\u0011a\u0002:pY\u0016LEm\u001d\t\u0006G\u0005\r$1\u0002\t\u0005\u0003\u0013\u0014i!\u0003\u0003\u0003\u0010\u0005\r(A\u0002*pY\u0016LE\r\u000b\u0002\u0012s\u0006\u0011r-\u001a;S_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8t)\u0011\u00119B!\b\u0011\t\u0005%'\u0011D\u0005\u0005\u00057\t\u0019OA\bQKJl\u0017n]:j_:t\u0015-\\3t\u0011\u001d\u0011yB\u0005a\u0001\u0005\u0017\taA]8mK&#\u0007F\u0001\nz\u0003m\u0019'/Z1uK\u001ecwNY1m%>dW\rU3s[&\u001c8/[8ogR!\u00111\u000bB\u0014\u0011\u001d\t\u0019m\u0005a\u0001\u0005S\u0001RaIA2\u0005W\u0001B!!3\u0003.%!!qFAr\u0005m\u0011v\u000e\\3QKJl\u0017n]:j_:\u001c%/Z1uKJ+\u0017/^3ti\"\u001a1#!\u001b)\u0005MI\u0018aG;qI\u0006$Xm\u00127pE\u0006d'k\u001c7f!\u0016\u0014X.[:tS>t7\u000f\u0006\u0003\u0002T\te\u0002bBAb)\u0001\u0007!1\b\t\u0006G\u0005\r$Q\b\t\u0005\u0003\u0013\u0014y$\u0003\u0003\u0003B\u0005\r(a\u0007*pY\u0016\u0004VM]7jgNLwN\\+qI\u0006$XMU3rk\u0016\u001cH\u000fK\u0002\u0015\u0003SB#\u0001F=\u0002?\u0019L'/\u001a*pY\u0016\u0004VM]7jgNLwN\\:DQ\u0006tw-\u001a3Fm\u0016tG\u000f\u0006\u0003\u0002T\t-\u0003bBAb+\u0001\u0007!Q\n\t\u0006G\u0005\r$q\n\t\u0005\u0003\u0013\u0014\t&\u0003\u0003\u0003T\u0005\r(\u0001\u0006*pY\u0016\u0004VM]7jgNLwN\\\"iC:<W-A\u000fgSJ,'k\u001c7f!JLgnY5qC2\u001c\u0005.\u00198hK\u00163XM\u001c;t)\u0011\t\u0019F!\u0017\t\u000f\u0005}c\u00031\u0001\u0002b\u0001")
public class DefaultReleaseRoleService
implements ReleaseRoleService {
    private final XLReleaseEventBus xlReleaseEventBus;
    private final CiIdService ciIdService;
    private final ReleaseRoleRepository releaseRoleRepository;
    private final ReleaseRolePermissionRepository releaseRolePermissionRepository;

    @Override
    public List<Role> getGlobalRoles() {
        return ReleaseRoleService.getGlobalRoles$(this);
    }

    @Override
    public void create(scala.collection.immutable.Seq<Role> roles) {
        ReleaseRoleService.create$((ReleaseRoleService)this, roles);
    }

    @Override
    public void update(scala.collection.immutable.Seq<Role> roles) {
        ReleaseRoleService.update$((ReleaseRoleService)this, roles);
    }

    @Override
    public void create(Role ... roles) {
        ReleaseRoleService.create$((ReleaseRoleService)this, roles);
    }

    @Override
    public void update(Role ... roles) {
        ReleaseRoleService.update$((ReleaseRoleService)this, roles);
    }

    @Override
    public java.util.Map<String, Set<String>> getGlobalRolePermissions(String ... roleIds) {
        return ReleaseRoleService.getGlobalRolePermissions$(this, roleIds);
    }

    @Override
    public void create(String onConfigurationItem, Role ... roles) {
        this.create(onConfigurationItem, (scala.collection.immutable.Seq<Role>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @Override
    public void update(String onConfigurationItem, Role ... roles) {
        this.update(onConfigurationItem, (scala.collection.immutable.Seq<Role>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @Override
    public void createGlobalRoleAndRolePermissions(ReleaseRoleService.RoleCreateRequest ... requests) {
        this.createGlobalRoleAndRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RoleCreateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void updateGlobalRoleAndRolePermissions(ReleaseRoleService.RoleUpdateRequest ... requests) {
        this.updateGlobalRoleAndRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RoleUpdateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void createGlobalRolePermissions(ReleaseRoleService.RolePermissionCreateRequest ... requests) {
        this.createGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void updateGlobalRolePermissions(ReleaseRoleService.RolePermissionUpdateRequest ... requests) {
        this.updateGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    @Timed
    public List<Role> getGlobalRoles(String rolePattern, Paging paging, Ordering order) {
        return this.releaseRoleRepository.getGlobalRoles(rolePattern, paging, order);
    }

    @Override
    @Timed
    public Page<RolePrincipalsView> getGlobalRolePrincipalViews(RolePrincipalsFilters filters, Pageable pageable) {
        return this.releaseRoleRepository.getGlobalRolePrincipals(filters, pageable);
    }

    @Override
    @Timed
    public void create(String onConfigurationItem, scala.collection.immutable.Seq<Role> roles) {
        this.releaseRoleRepository.create(onConfigurationItem, roles);
        this.fireRolePrincipalChangeEvents(roles);
    }

    @Override
    @Timed
    public void update(String onConfigurationItem, scala.collection.immutable.Seq<Role> roles) {
        this.releaseRoleRepository.update(onConfigurationItem, roles);
        this.fireRolePrincipalChangeEvents(roles);
    }

    @Override
    @Timed
    public void renameGlobalRole(String oldName, String newName) {
        this.releaseRoleRepository.renameGlobalRole(oldName, newName);
        EventBusHolder.publish((Object)new RoleRenamedEvent(oldName, newName));
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public void deleteGlobalRole(String roleName) {
        Role foundRole = (Role)this.releaseRoleRepository.getGlobalRole(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
        });
        this.releaseRoleRepository.deleteGlobalRole(foundRole.getId());
        EventBusHolder.publish((Object)new RoleDeletedEvent(roleName));
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public Option<Role> getGlobalRole(String roleName) {
        return this.releaseRoleRepository.getGlobalRole(roleName);
    }

    @Override
    @Timed
    public RolePrincipalsView getGlobalRolePrincipalsView(String roleName) {
        return (RolePrincipalsView)this.releaseRoleRepository.getGlobalRolePrincipal(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Role [" + roleName + "] not found", new Object[0]);
        });
    }

    @Override
    @Timed
    public boolean globalRoleExists(String roleName) {
        return this.releaseRoleRepository.globalRoleExists(roleName);
    }

    @Override
    @Timed
    public void createGlobalRoleAndRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RoleCreateRequest> requests) {
        Tuple2 tuple2 = ((IterableOps)requests.map((Function1 & Serializable)request -> {
            String roleId = Ids.getName((String)$this.ciIdService.getUniqueId("Role", TeamService.GLOBAL_ROLES_ROOT));
            Role role = new Role(roleId, request.roleName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.SetHasAsScala(request.rolePrincipals()).asScala().toList()).asJava());
            ReleaseRoleService.RolePermissionCreateRequest rolePermission = new ReleaseRoleService.RolePermissionCreateRequest(roleId, role.getName(), request.rolePermissions());
            return new Tuple2((Object)role, (Object)rolePermission);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)roles, (Object)rolePermissions);
        scala.collection.immutable.Seq roles2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq rolePermissions2 = (scala.collection.immutable.Seq)tuple22._2();
        this.create((scala.collection.immutable.Seq<Role>)roles2);
        this.createGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest>)rolePermissions2);
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public void updateGlobalRoleAndRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RoleUpdateRequest> requests) {
        Tuple2 tuple2 = ((IterableOps)requests.map((Function1 & Serializable)request -> {
            Role role = new Role(request.roleId(), request.roleName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.SetHasAsScala(request.rolePrincipals()).asScala().toList()).asJava());
            ReleaseRoleService.RolePermissionUpdateRequest rolePermission = new ReleaseRoleService.RolePermissionUpdateRequest(request.roleId(), role.getName(), request.rolePermissions());
            return new Tuple2((Object)role, (Object)rolePermission);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq rolePermissionRequests = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)roles, (Object)rolePermissionRequests);
        scala.collection.immutable.Seq roles2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq rolePermissionRequests2 = (scala.collection.immutable.Seq)tuple22._2();
        this.update((scala.collection.immutable.Seq<Role>)roles2);
        this.updateGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest>)rolePermissionRequests2);
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public java.util.Map<String, Set<String>> getGlobalRolePermissions(scala.collection.immutable.Seq<String> roleIds) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.releaseRolePermissionRepository.getGlobalRolePermissions(roleIds).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends RolePermission, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String roleId = A1.roleId();
                    Set<String> rps = A1.permissionNames();
                    return (B1)new Tuple2((Object)roleId, rps);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(RolePermission x1) {
                RolePermission rolePermission = x1;
                return rolePermission != null;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    @Override
    @Timed
    public Set<String> getRolePermissions(String roleId) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releaseRolePermissionRepository.getRolePermissions(roleId)).asJava();
    }

    @Override
    @Timed
    public void createGlobalRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest> requests) {
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> new RolePermission(request.roleId(), request.permissionNames()));
        this.releaseRolePermissionRepository.createGlobalRolePermissions((scala.collection.immutable.Seq<RolePermission>)rolePermissions);
        this.fireRolePermissionsChangedEvent(requests);
    }

    @Override
    @Timed
    public void updateGlobalRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest> requests) {
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> new RolePermission(request.roleId(), request.permissionNames()));
        this.releaseRolePermissionRepository.updateGlobalRolePermissions((scala.collection.immutable.Seq<RolePermission>)rolePermissions);
        this.fireRolePermissionsChangedEvent(requests);
    }

    private void fireRolePermissionsChangedEvent(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionChange> requests) {
        scala.collection.immutable.Seq msgs = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> request.roleName() + " => " + request.permissionNames());
        EventBusHolder.publish((Object)new RolePermissionsChangedEvent(PermissionChecker$.MODULE$.GLOBAL_SECURITY_ALIAS(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)msgs).asJava()));
    }

    private void fireRolePrincipalChangeEvents(scala.collection.immutable.Seq<Role> roles) {
        scala.collection.immutable.Seq rolePrincipals = (scala.collection.immutable.Seq)roles.map((Function1 & Serializable)role -> role.getName() + " => " + role.getPrincipals());
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rolePrincipals).asJava()));
    }

    public DefaultReleaseRoleService(XLReleaseEventBus xlReleaseEventBus, CiIdService ciIdService, ReleaseRoleRepository releaseRoleRepository, ReleaseRolePermissionRepository releaseRolePermissionRepository) {
        this.xlReleaseEventBus = xlReleaseEventBus;
        this.ciIdService = ciIdService;
        this.releaseRoleRepository = releaseRoleRepository;
        this.releaseRolePermissionRepository = releaseRolePermissionRepository;
        ReleaseRoleService.$init$(this);
    }
}

