/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.AbortRelease;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.BasicReleaseView;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseFullSearchResult;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.ReleaseOverview;
import com.xebialabs.xlrelease.views.ReleaseOverviewResultsView;
import com.xebialabs.xlrelease.views.converters.BasicReleaseViewConverter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReleaseApiImpl
implements ReleaseApi {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseApiImpl.class);
    private final PermissionChecker permissions;
    private final ReleaseService releaseService;
    private final ReleaseSearchService releaseSearchService;
    private final ReleaseActorService releaseActorService;
    private final VariableComponent variableComponent;
    private final TeamFacade teamFacade;
    private final AttachmentService attachmentService;
    private final VariableService variableService;
    private final FolderVariableService folderVariableService;

    @Autowired
    public ReleaseApiImpl(PermissionChecker permissions, ReleaseService releaseService, ReleaseSearchService releaseSearchService, VariableComponent variableComponent, ReleaseActorService releaseActorService, TeamFacade teamFacade, AttachmentService attachmentService, VariableService variableService, FolderVariableService folderVariableService) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releaseSearchService = releaseSearchService;
        this.releaseActorService = releaseActorService;
        this.variableComponent = variableComponent;
        this.teamFacade = teamFacade;
        this.attachmentService = attachmentService;
        this.variableService = variableService;
        this.folderVariableService = folderVariableService;
    }

    @Timed
    public Response downloadAttachment(String attachmentId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)attachmentId));
        Attachment attachment = this.attachmentService.findByIdIncludingArchived(attachmentId);
        StreamingOutput output = outputStream -> {
            WorkDirContext.initWorkdir((String)"download");
            try (InputStream inputStream = attachment.getFile().getInputStream();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.flush();
                WorkDirContext.get().delete();
                WorkDirContext.clear();
            }
        };
        String fileName = attachment.getFile().getName();
        return ResponseHelper.streamFile(fileName, output, attachment.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timed
    public byte[] getAttachment(String attachmentId) throws IOException {
        byte[] byteArray;
        this.permissions.checkView(Ids.releaseIdFrom((String)attachmentId));
        WorkdirHolder.initWorkdir((String)"download");
        Attachment attachment = this.attachmentService.findByIdIncludingArchived(attachmentId);
        WorkDir workDir = WorkDirContext.get();
        try (InputStream inputStream = attachment.getFile().getInputStream();){
            byteArray = ByteStreams.toByteArray((InputStream)inputStream);
        }
        finally {
            workDir.delete();
        }
        return byteArray;
    }

    @Timed
    public ReleaseCountResults countReleases(ReleasesFilters releasesFilters) {
        if (null == releasesFilters) {
            releasesFilters = new ReleasesFilters();
        }
        return this.releaseSearchService.count(releasesFilters);
    }

    @Timed
    public List<Release> searchReleases(ReleasesFilters releasesFilters, Long page, Long resultsPerPage, Boolean pageIsOffset) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == releasesFilters) {
            releasesFilters = new ReleasesFilters();
        }
        return this.releaseSearchService.search(releasesFilters, page, resultsPerPage, pageIsOffset).getReleases();
    }

    @Timed
    public List<Release> searchReleases(ReleasesFilters releasesFilters, Long page, Long resultsPerPage) {
        return this.searchReleases(releasesFilters, page, resultsPerPage, false);
    }

    @Timed
    public List<Release> searchReleases(ReleasesFilters releasesFilters) {
        return this.searchReleases(releasesFilters, 0L, 100L);
    }

    @Timed
    public List<BasicReleaseView> searchReleasesOverview(ReleasesFilters releasesFilters, Long page, Long resultsPerPage) {
        ReleaseOverviewResultsView searchResult = this.releaseSearchService.releasesOverview(releasesFilters, page != null ? page : 0L, Optional.ofNullable(resultsPerPage).orElse(this.releaseSearchService.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE()));
        List<ReleaseOverview> overviews = searchResult.getCis();
        return overviews.stream().map(BasicReleaseViewConverter::fromReleaseOverview).collect(Collectors.toList());
    }

    @Timed
    public ReleaseFullSearchResult fullSearchReleases(Long page, Long archivePage, Long resultsPerPage, Long archiveResultsPerPage, ReleasesFilters releasesFilters) {
        Optional<Object> size = Optional.ofNullable(resultsPerPage);
        Page pageForCurrent = Page.parse(Optional.ofNullable(page), size, Optional.empty());
        Optional<Object> archiveSize = Optional.ofNullable(archiveResultsPerPage).map(Optional::of).orElse(size);
        Optional<Object> archiveOrCurrentPage = Optional.ofNullable(archivePage).map(Optional::of).orElse(Optional.ofNullable(page));
        Page pageForArchive = Page.parse(archiveOrCurrentPage, archiveSize, Optional.empty());
        return this.releaseSearchService.fullSearch(releasesFilters, pageForCurrent, pageForArchive);
    }

    @Timed
    public List<Release> getReleases(Long page, Long resultsPerPage, Integer depth) {
        return this.getReleases(page, resultsPerPage);
    }

    @Timed
    public List<Release> getReleases(Long page, Long resultsPerPage) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        ReleasesFilters filters = new ReleasesFilters();
        filters.setPlanned(true);
        filters.setActive(true);
        filters.setOrderBy(ReleaseOrderMode.start_date);
        ReleaseSearchResult searchResult = this.releaseSearchService.search(filters, page, resultsPerPage);
        return searchResult.getReleases();
    }

    @Timed
    public List<Release> getReleases() {
        return this.getReleases(0L, 100L);
    }

    @Timed
    public Release getRelease(String releaseId, boolean withRoleIds) {
        Release release = this.releaseService.findById(releaseId, withRoleIds);
        this.permissions.checkView(release);
        return release;
    }

    @Timed
    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getArchivedRelease(String releaseId, boolean withRoleIds) {
        Release release = this.releaseService.findByIdInArchive(releaseId, withRoleIds);
        this.permissions.checkView(release);
        return release;
    }

    @Timed
    public Release getArchivedRelease(String releaseId) {
        return this.getArchivedRelease(releaseId, false);
    }

    @Timed
    public List<Task> getActiveTasks(String releaseId) {
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        return release.getActiveTasks();
    }

    @Timed
    public Release start(String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        Checks.checkArgument((!this.releaseService.isTemplate(releaseId) ? 1 : 0) != 0, (String)String.format("Could not start %s because it is a template.", releaseId), (Object[])new Object[0]);
        try {
            this.releaseService.checkCanBeStarted(releaseId);
            return this.releaseActorService.startRelease(releaseId, User.AUTHENTICATED_USER);
        }
        catch (IllegalStateException e) {
            logger.error("Could not start release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @Timed
    public Release updateRelease(String releaseId, Release release) {
        this.permissions.checkEdit(releaseId);
        return this.releaseActorService.updateRelease(releaseId, release);
    }

    @Timed
    public Release updateRelease(Release release) {
        return this.updateRelease(release.getId(), release);
    }

    @Timed
    public void delete(String releaseId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.releaseActorService.deleteRelease(releaseId);
    }

    @Timed
    public Release abort(String releaseId, AbortRelease abortRelease) {
        this.permissions.checkAbort(releaseId);
        return this.abort(releaseId, abortRelease.getAbortComment());
    }

    @Timed
    public Release abort(String releaseId, String abortComment) {
        this.permissions.checkAbort(releaseId);
        return this.releaseActorService.abortRelease(releaseId, abortComment);
    }

    @Timed
    public List<Release> searchReleasesByTitle(String releaseTitle) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseTitle) ? 1 : 0) != 0, (String)"Query parameter releaseTitle must be provided", (Object[])new Object[0]);
        return this.releaseSearchService.searchReleasesByTitle(releaseTitle, ReleaseKind.RELEASE, 0L, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(String releaseId) {
        return this.variableComponent.getVariables(releaseId);
    }

    @Timed
    public Map<String, String> getVariableValues(String releaseId) {
        List variables = this.variableService.findGlobalVariablesOrEmpty().getVariables();
        List folderVariables2 = this.folderVariableService.getAllFromAncestry(Ids.findFolderId((String)releaseId)).getVariables();
        variables.addAll(folderVariables2);
        variables.addAll(this.variableComponent.getVariables(releaseId));
        return VariableHelper.getVariableValuesAsStrings((List)variables);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(String variableId) {
        return this.variableComponent.getVariable(variableId);
    }

    @Timed
    public Collection<Object> getVariablePossibleValues(String variableId) {
        return this.variableComponent.getVariablePossibleValues(variableId);
    }

    @Timed
    public Boolean isVariableUsed(String variableId) {
        return this.variableComponent.isVariableUsed(variableId);
    }

    @Timed
    public void replaceVariable(String variableId, VariableOrValue variableOrValue) {
        this.variableComponent.replaceVariable(variableId, variableOrValue);
    }

    @Timed
    public void deleteVariable(String variableId) {
        this.variableComponent.deleteVariable(variableId);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(String releaseId, Variable variable) {
        return this.variableComponent.createVariable(releaseId, variable);
    }

    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(String releaseId, List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        return this.variableComponent.updateVariables(releaseId, variables);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variableId, variable);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variable.getId(), variable);
    }

    @Timed
    public List<String> getPermissions() {
        return XLReleasePermissions.getReleasePermissions();
    }

    @Timed
    public List<TeamView> getTeams(String releaseId) {
        return this.teamFacade.getTeams(releaseId);
    }

    @Timed
    public List<TeamView> setTeams(String releaseId, List<TeamView> teams) {
        return this.teamFacade.setTeams(releaseId, teams);
    }

    @Timed
    public Release resume(String releaseId) {
        this.permissions.checkAny(releaseId, XLReleasePermissions.RESTART_PHASE, XLReleasePermissions.EDIT_RELEASE);
        try {
            return this.releaseActorService.resume(releaseId);
        }
        catch (IllegalStateException e) {
            logger.error("Could not resume release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @Timed
    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        Checks.checkNotNull((Object)releaseId, (String)"releaseId");
        Checks.checkNotNull((Object)phaseId, (String)"fromPhaseId");
        Checks.checkNotNull((Object)taskId, (String)"fromTaskId");
        Checks.checkNotNull((Object)phaseVersion, (String)"phaseVersion");
        this.permissions.check(XLReleasePermissions.RESTART_PHASE, releaseId);
        try {
            return this.releaseActorService.restartPhase(releaseId, phaseId, taskId, phaseVersion, resumeRelease);
        }
        catch (IllegalStateException e) {
            logger.error("Could not restart phases of release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    public Release restartPhase(Release release) {
        return this.restartPhase(release, false);
    }

    public Release restartPhase(Release release, boolean resumeRelease) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkArgument((boolean)release.hasCurrentPhase(), (String)"Release '%s' must have a current phase in order to restart phases", (Object[])new Object[]{release.getTitle()});
        Checks.checkArgument((!release.getCurrentPhase().getTasks().isEmpty() ? 1 : 0) != 0, (String)"The given release does not have any task", (Object[])new Object[0]);
        return this.restartPhase(release, release.getCurrentPhase(), release.getCurrentPhase().getTask(Integer.valueOf(0)), PhaseVersion.ALL, resumeRelease);
    }

    public Release restartPhase(Release release, Phase phase) {
        return this.restartPhase(release, phase, PhaseVersion.ALL);
    }

    public Release restartPhase(Release release, Phase phase, PhaseVersion phaseVersion) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkArgument((!phase.getTasks().isEmpty() ? 1 : 0) != 0, (String)"The release with given phase does not have any task", (Object[])new Object[0]);
        return this.restartPhases(release.getId(), phase.getId(), phase.getTask(Integer.valueOf(0)).getId(), phaseVersion, false);
    }

    public Release restartPhase(Release release, Phase phase, Task task) {
        return this.restartPhase(release, phase, task, PhaseVersion.ALL);
    }

    public Release restartPhase(Release release, Phase phase, Task task, PhaseVersion phaseVersion) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkNotNull((Object)task, (String)"given task");
        return this.restartPhases(release.getId(), phase.getId(), task.getId(), phaseVersion, false);
    }

    public Release restartPhase(Release release, Phase phase, Task task, PhaseVersion phaseVersion, boolean resumeRelease) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkNotNull((Object)task, (String)"given task");
        return this.restartPhases(release.getId(), phase.getId(), task.getId(), phaseVersion, resumeRelease);
    }
}

